/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.monet.renderers.templates.java.ProcessDefinitionTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import java.io.File;
import java.util.ArrayList;
import org.monet.metamodel.ContainerDefinitionBase;
import org.monet.metamodel.Definition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.ProcessDefinitionBase;
import org.monet.metamodel.internal.Ref;

public abstract class ProcessRenderer<D extends ProcessDefinition>
extends DefinitionRenderer<D> {
    public ProcessRenderer(Dictionary dictionary, Modernization modernization, D definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        super.write();
        this.writeEmbeddedTemplate();
        this.writeStateView();
        this.writeTargetViews();
        this.writeShortcutViews();
    }

    @Override
    protected FrameBuilder buildFrame() {
        return this.baseDefinitionFrame().add("process");
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.monet.renderers.templates.konos.ProcessDefinitionTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new ProcessDefinitionTemplate();
    }

    protected void addDisplayList(FrameBuilder builder) {
        this.resetAddedDisplays();
        this.addTargetDisplays(builder);
    }

    private void addTargetViews(FrameBuilder builder) {
        ((ProcessDefinition)this.definition()).getViewList().stream().filter(v -> v.getShow() != null && v.getShow().getTarget() != null).forEach(v -> this.addTargetView((ProcessDefinitionBase.ViewProperty)v, builder));
    }

    private void addTargetView(ProcessDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        Ref targetDefinition = viewProperty.getShow().getTarget();
        if (targetDefinition == null) {
            return;
        }
        builder.add("view", this.viewFrame(viewProperty).add("target"));
    }

    private void addShortcutViews(FrameBuilder builder) {
        ((ProcessDefinition)this.definition()).getViewList().stream().filter(v -> v.getShow() != null && v.getShow().getShortcut() != null).forEach(v -> this.addShortcutView((ProcessDefinitionBase.ViewProperty)v, builder));
    }

    private void addShortcutView(ProcessDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        ArrayList<Ref> shortcutDefinition = viewProperty.getShow().getShortcutDefinition();
        if (shortcutDefinition == null || shortcutDefinition.isEmpty()) {
            return;
        }
        builder.add("view", this.viewFrame(viewProperty).add("shortcut"));
    }

    protected FrameBuilder viewFrame(ProcessDefinitionBase.ViewProperty viewProperty) {
        FrameBuilder result = this.baseFrame().add("view");
        result.add("definition", this.nameOf((Definition)this.definition()));
        result.add("code", viewProperty.getCode());
        result.add("name", this.nameOf(viewProperty));
        result.add("label", this.clean(this.labelOf(viewProperty)));
        this.addShow(viewProperty, result);
        return result;
    }

    private void addShow(ProcessDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        ProcessDefinitionBase.ViewProperty.ShowProperty show = viewProperty.getShow();
        if (show.getShortcut() != null) {
            this.addShortcutShow(viewProperty, builder);
        } else if (show.getTarget() != null) {
            this.addTargetShow(viewProperty, builder);
        }
    }

    private void addShortcutShow(ProcessDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        ArrayList<Ref> definitionRefList = viewProperty.getShow().getShortcutDefinition();
        builder.add("shortcut", viewProperty.getShow().getShortcut());
        definitionRefList.forEach(ref -> this.addShortcutShow(viewProperty, (Ref)ref, builder));
    }

    private void addShortcutShow(ProcessDefinitionBase.ViewProperty viewProperty, Ref definitionRef, FrameBuilder builder) {
        String view = viewProperty.getShow().getShortcutView();
        NodeDefinition nodeDefinition = this.dictionary.getNodeDefinition(definitionRef.getValue());
        NodeViewProperty nodeViewProperty = view != null && nodeDefinition.getNodeView(view) != null ? nodeDefinition.getNodeView(view) : nodeDefinition.getDefaultView();
        builder.add("show", this.showFrame(viewProperty, nodeDefinition, nodeViewProperty).add("shortcut").add("shortcut", viewProperty.getShow().getShortcut()));
    }

    private void addTargetShow(ProcessDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        Ref definitionRef = viewProperty.getShow().getTarget();
        builder.add("target", definitionRef);
        this.addTargetShow(viewProperty, definitionRef, builder);
    }

    private void addTargetShow(ProcessDefinitionBase.ViewProperty viewProperty, Ref definitionRef, FrameBuilder builder) {
        String view = definitionRef.getValue();
        NodeDefinition nodeDefinition = this.dictionary.getNodeDefinition(definitionRef.getDefinition());
        NodeViewProperty nodeViewProperty = view != null && nodeDefinition.getNodeView(view) != null ? nodeDefinition.getNodeView(view) : nodeDefinition.getDefaultView();
        builder.add("show", this.showFrame(viewProperty, nodeDefinition, nodeViewProperty).add("target").add("target", definitionRef));
    }

    private FrameBuilder showFrame(ProcessDefinitionBase.ViewProperty viewProperty, NodeDefinition nodeDefinition, NodeViewProperty nodeViewProperty) {
        FrameBuilder result = new FrameBuilder().add("show");
        result.add("definitionName", this.nameOf(nodeDefinition));
        result.add("definitionCode", nodeDefinition.getCode());
        result.add("code", viewProperty.getCode());
        result.add("name", this.nameOf(viewProperty));
        result.add("viewCode", nodeViewProperty != null ? nodeViewProperty.getCode() : nodeDefinition.getCode());
        result.add("viewName", nodeViewProperty != null ? this.nameOf(nodeViewProperty) + "ViewTemplate" : "EmbeddedTemplate");
        this.addContain(nodeDefinition, nodeViewProperty, result);
        return result;
    }

    private void addContain(NodeDefinition nodeDefinition, NodeViewProperty nodeViewProperty, FrameBuilder builder) {
        if (!nodeDefinition.isContainer() || nodeViewProperty == null) {
            return;
        }
        ContainerDefinitionBase.ViewProperty containViewProperty = (ContainerDefinitionBase.ViewProperty)nodeViewProperty;
        if (containViewProperty.getShow().getComponent() == null || containViewProperty.getShow().getComponent().isEmpty()) {
            return;
        }
        Ref ref = containViewProperty.getShow().getComponent().get(0);
        NodeDefinition containDefinition = this.dictionary.getNodeDefinition(ref.getDefinition());
        FrameBuilder result = new FrameBuilder("showContain");
        result.add("definitionName", this.nameOf(nodeDefinition));
        result.add("definitionCode", nodeDefinition.getCode());
        result.add("code", nodeViewProperty.getCode());
        result.add("name", this.nameOf(nodeViewProperty));
        result.add("viewCode", nodeViewProperty.getCode());
        result.add("viewName", this.nameOf(nodeViewProperty) + "ViewTemplate");
        result.add("containDefinitionName", this.nameOf(containDefinition));
        result.add("containDefinitionCode", containDefinition.getCode());
        builder.add("showContain", result);
    }

    private void addTargetDisplays(FrameBuilder builder) {
        ((ProcessDefinition)this.definition()).getViewList().stream().filter(v -> v.getShow() != null && v.getShow().getTarget() != null).forEach(v -> {
            Ref target = v.getShow().getTarget();
            NodeDefinition definition = this.dictionary.getNodeDefinition(target.getDefinition());
            this.addDisplayFor(definition, target.getValue(), builder);
        });
        ((ProcessDefinition)this.definition()).getEditionActionList().forEach(a -> {
            NodeDefinition definition = this.dictionary.getNodeDefinition(a.getUse().getForm().getValue());
            this.addDisplayFor(definition, a.getUse().getWithView().getValue(), builder);
        });
    }

    @Override
    protected void writeKonos(FrameBuilder builder) {
        File file = new File(this.konosPackage() + this.nameOf((Definition)this.definition()) + ".konos");
        this.addTargetViews(builder);
        this.addShortcutViews(builder);
        this.addDisplayList(builder);
        this.writeFrame(file, this.konosTemplate().render(builder.toFrame()));
    }

    private void writeEmbeddedTemplate() {
        FrameBuilder builder = this.baseDefinitionFrame().add("embedded");
        this.addTargetViews(builder);
        this.addShortcutViews(builder);
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + "EmbeddedTemplate.java");
        this.writeFrame(file, new ProcessDefinitionTemplate().render(builder.toFrame()));
    }

    private void writeStateView() {
        FrameBuilder builder = this.baseDefinitionFrame().add("stateview");
        this.addDisplayList(builder);
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + "StateViewTemplate.java");
        this.writeFrame(file, new ProcessDefinitionTemplate().render(builder.toFrame()));
    }

    private void writeTargetViews() {
        ((ProcessDefinition)this.definition()).getViewList().stream().filter(v -> v.getShow() != null && v.getShow().getTarget() != null).forEach(this::writeTargetView);
    }

    protected void writeTargetView(ProcessDefinitionBase.ViewProperty viewProperty) {
        Ref targetDefinition = viewProperty.getShow().getTarget();
        if (targetDefinition == null) {
            return;
        }
        FrameBuilder builder = this.viewFrame(viewProperty).add("target").add("process");
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + StringFormatters.firstUpperCase().format(this.nameOf(viewProperty)) + "ViewTemplate.java");
        this.writeFrame(file, new ProcessDefinitionTemplate().render(builder.toFrame()));
    }

    private void writeShortcutViews() {
        ((ProcessDefinition)this.definition()).getViewList().stream().filter(v -> v.getShow() != null && v.getShow().getShortcut() != null).forEach(this::writeShortcutView);
    }

    protected void writeShortcutView(ProcessDefinitionBase.ViewProperty viewProperty) {
        ArrayList<Ref> shortcutDefinition = viewProperty.getShow().getShortcutDefinition();
        if (shortcutDefinition == null || shortcutDefinition.isEmpty()) {
            return;
        }
        FrameBuilder builder = this.viewFrame(viewProperty).add("shortcut").add("process");
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + StringFormatters.firstUpperCase().format(this.nameOf(viewProperty)) + "ViewTemplate.java");
        this.writeFrame(file, new ProcessDefinitionTemplate().render(builder.toFrame()));
    }
}

