/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.monet.renderers.RendererHelper;
import io.intino.goros.modernizing.monet.renderers.templates.konos.IndexTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import java.io.File;
import org.monet.metamodel.AttributeProperty;
import org.monet.metamodel.Definition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.IndexDefinitionBase;
import org.monet.metamodel.internal.Ref;

public class IndexRenderer
extends DefinitionRenderer<IndexDefinition> {
    public IndexRenderer(Dictionary dictionary, Modernization modernization, IndexDefinition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        if (((IndexDefinition)this.definition()).getViewList().size() <= 0) {
            return;
        }
        FrameBuilder builder = this.buildFrame();
        this.writeKonos(builder);
        this.writeViewsTemplate();
    }

    @Override
    protected FrameBuilder buildFrame() {
        FrameBuilder result = this.baseFrame().add("indexdefinition");
        this.addViews(result);
        return result;
    }

    private void addViews(FrameBuilder builder) {
        ((IndexDefinition)this.definition()).getViewList().forEach(view -> this.addView((IndexDefinitionBase.IndexViewProperty)view, builder));
    }

    private void addView(IndexDefinitionBase.IndexViewProperty viewProperty, FrameBuilder builder) {
        if (RendererHelper.countAttributes(viewProperty) == 0) {
            return;
        }
        builder.add("view", this.viewFrame(viewProperty));
    }

    private void addAttributes(IndexDefinitionBase.IndexViewProperty viewProperty, FrameBuilder builder) {
        IndexDefinitionBase.IndexViewProperty.ShowProperty show = viewProperty.getShow();
        int countAttributes = RendererHelper.countAttributes(viewProperty);
        if (show.getTitle() != null) {
            this.addAttribute("title", this.attributeFrame(viewProperty, show.getTitle(), countAttributes).add("value", "Cargando..."), builder);
        }
        if (show.getPicture() != null) {
            this.addAttribute("picture", this.attributeFrame(viewProperty, show.getPicture(), countAttributes), builder);
        }
        if (show.getIcon() != null) {
            this.addAttribute("icon", this.attributeFrame(viewProperty, show.getIcon(), countAttributes), builder);
        }
        show.getHighlight().forEach(h -> this.addAttribute("highlight", this.attributeFrame(viewProperty, (Ref)h, countAttributes), builder));
        show.getLine().forEach(l -> this.addAttribute("line", this.attributeFrame(viewProperty, (Ref)l, countAttributes), builder));
        show.getLineBelow().forEach(lb -> this.addAttribute("lineBelow", this.attributeFrame(viewProperty, (Ref)lb, countAttributes), builder));
        show.getFooter().forEach(f -> this.addAttribute("footer", this.attributeFrame(viewProperty, (Ref)f, countAttributes), builder));
    }

    private void addAttribute(String section, FrameBuilder attributeFrame, FrameBuilder builder) {
        builder.add(section, attributeFrame);
        builder.add("attribute", attributeFrame);
    }

    private FrameBuilder attributeFrame(IndexDefinitionBase.IndexViewProperty viewProperty, Ref attribute, int countAttributes) {
        AttributeProperty attributeProperty = ((IndexDefinition)this.definition()).getAttribute(attribute.getValue());
        FrameBuilder result = this.baseFrame().add("attribute");
        AttributeProperty.TypeEnumeration type = attributeProperty.getType();
        long width = countAttributes > 0 ? Math.round(100.0 / (double)countAttributes) : 0L;
        result.add(attributeProperty.getType().name().toLowerCase());
        result.add("definition", this.nameOf((Definition)this.definition()));
        result.add("view", this.nameOf(viewProperty));
        result.add("name", this.normalize(attributeProperty.getName()));
        result.add("code", attributeProperty.getCode());
        result.add("label", this.clean(attributeProperty.getLabel()));
        result.add("type", RendererHelper.attributeTypeOf(attributeProperty));
        result.add("width", width);
        if (type == AttributeProperty.TypeEnumeration.STRING) {
            result.add("cropWithEllipsis", width);
        }
        return result;
    }

    @Override
    protected Template konosTemplate() {
        return new IndexTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new io.intino.goros.modernizing.monet.renderers.templates.java.IndexTemplate();
    }

    private void writeViewsTemplate() {
        ((IndexDefinition)this.definition()).getViewList().stream().filter(this::hasTemplate).forEach(this::writeViewTemplate);
    }

    protected boolean hasTemplate(IndexDefinitionBase.IndexViewProperty viewProperty) {
        IndexDefinitionBase.IndexViewProperty.ShowProperty showProperty = viewProperty.getShow();
        return RendererHelper.countAttributes(viewProperty) > 0;
    }

    private void writeViewTemplate(IndexDefinitionBase.IndexViewProperty view) {
        this.resetAddedDisplays();
        FrameBuilder viewFrame = this.viewFrame(view);
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + StringFormatters.firstUpperCase().format(this.nameOf(view)) + "Table.java");
        this.writeFrame(file, this.javaTemplate().render(viewFrame.toFrame()));
    }

    private FrameBuilder viewFrame(IndexDefinitionBase.IndexViewProperty viewProperty) {
        FrameBuilder result = this.baseFrame().add("view");
        result.add("definition", RendererHelper.nameOf(this.definition(), this.dictionary.basePackage()));
        result.add("name", RendererHelper.nameOf(viewProperty));
        result.add("code", viewProperty.getCode());
        result.add("label", this.clean(viewProperty.getName()));
        this.addAttributes(viewProperty, result);
        return result;
    }

    @Override
    protected String javaPackage() {
        return this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "tables" + File.separator;
    }
}

