/*
 * Decompiled with CFR 0.152.
 */
package org.monet.bpi;

import java.sql.Timestamp;
import java.util.Date;
import org.monet.bpi.OperationExpression;
import org.monet.bpi.types.File;
import org.monet.bpi.types.Link;
import org.monet.bpi.types.Picture;
import org.monet.bpi.types.Term;

public class Param {
    private boolean isValueParam = false;
    private String name;
    private Object value;

    public Param(String name) {
        this.name = name;
    }

    public Param(String name, Object value) {
        this.name = name;
        this.value = value instanceof Date && value != null ? new Timestamp(((Date)value).getTime()) : value;
        this.isValueParam = true;
    }

    public String getName(String idx) {
        return "@" + this.getParamName(idx);
    }

    public String getParamName(String idx) {
        return this.name + idx;
    }

    public boolean isExtended() {
        return this.value instanceof Timestamp || this.value instanceof Term || this.value instanceof Link || this.value instanceof Picture || this.value instanceof File;
    }

    public boolean isTimestamp() {
        return this.value instanceof Timestamp;
    }

    public String getColumn() {
        return this.name;
    }

    public String getColumnExtended() {
        if (!this.isExtended()) {
            return "";
        }
        return this.name + "$ex";
    }

    public boolean isValueParam() {
        return this.isValueParam;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueAsString() {
        if (!this.isExtended()) {
            return this.value;
        }
        if (this.value instanceof Term) {
            return ((Term)this.value).getLabel();
        }
        if (this.value instanceof Link) {
            return ((Link)this.value).getLabel();
        }
        if (this.value instanceof Picture) {
            return ((Picture)this.value).getFilename();
        }
        if (this.value instanceof File) {
            return ((File)this.value).getFilename();
        }
        return this.value;
    }

    public Object getValueExtended() {
        if (!this.isExtended()) {
            return null;
        }
        if (this.value instanceof Term) {
            return ((Term)this.value).getKey();
        }
        if (this.value instanceof Link) {
            return ((Link)this.value).getId();
        }
        if (this.value instanceof Picture) {
            return ((Picture)this.value).getFilename();
        }
        if (this.value instanceof File) {
            return ((File)this.value).getFilename();
        }
        return this.value;
    }

    public OperationExpression Like(String value) {
        return new OperationExpression(this, "LIKE", new Param(this.name, value));
    }

    public OperationExpression Eq(Param param) {
        this.value = param.getValue();
        return new OperationExpression(this, "=", param);
    }

    public OperationExpression Eq(Enum<?> value) {
        return this.Eq(new Param(this.name, value.toString()));
    }

    public OperationExpression Eq(String value) {
        return this.Eq(new Param(this.name, value));
    }

    public OperationExpression Eq(Date value) {
        return this.Eq(new Param(this.name, value));
    }

    public OperationExpression Eq(int value) {
        return this.Eq(new Param(this.name, value));
    }

    public OperationExpression Eq(Term value) {
        return this.Eq(new Param(this.name, value));
    }

    public OperationExpression Eq(Link value) {
        return this.Eq(new Param(this.name, value));
    }

    public OperationExpression Ge(Param param) {
        this.value = param.getValue();
        return new OperationExpression(this, ">=", param);
    }

    public OperationExpression Ge(String value) {
        return this.Ge(new Param(this.name, value));
    }

    public OperationExpression Ge(Date value) {
        return this.Ge(new Param(this.name, value));
    }

    public OperationExpression Ge(int value) {
        return this.Ge(new Param(this.name, value));
    }

    public OperationExpression Gt(Param param) {
        this.value = param.getValue();
        return new OperationExpression(this, ">", param);
    }

    public OperationExpression Gt(String value) {
        return this.Gt(new Param(this.name, value));
    }

    public OperationExpression Gt(Date value) {
        return this.Gt(new Param(this.name, value));
    }

    public OperationExpression Gt(int value) {
        return this.Gt(new Param(this.name, value));
    }

    public OperationExpression Le(Param param) {
        this.value = param.getValue();
        return new OperationExpression(this, "<=", param);
    }

    public OperationExpression Le(String value) {
        return this.Le(new Param(this.name, value));
    }

    public OperationExpression Le(Date value) {
        return this.Le(new Param(this.name, value));
    }

    public OperationExpression Le(int value) {
        return this.Le(new Param(this.name, value));
    }

    public OperationExpression Lt(Param param) {
        this.value = param.getValue();
        return new OperationExpression(this, "<", param);
    }

    public OperationExpression Lt(String value) {
        return this.Lt(new Param(this.name, value));
    }

    public OperationExpression Lt(Date value) {
        return this.Lt(new Param(this.name, value));
    }

    public OperationExpression Lt(int value) {
        return this.Lt(new Param(this.name, value));
    }

    public OperationExpression Ne(Param param) {
        this.value = param.getValue();
        return new OperationExpression(this, "<>", param);
    }

    public OperationExpression Ne(Enum<?> value) {
        return this.Ne(new Param(this.name, value.toString()));
    }

    public OperationExpression Ne(String value) {
        return this.Ne(new Param(this.name, value));
    }

    public OperationExpression Ne(Date value) {
        return this.Ne(new Param(this.name, value));
    }

    public OperationExpression Ne(int value) {
        return this.Ne(new Param(this.name, value));
    }

    public OperationExpression Ne(Term value) {
        return this.Ne(new Param(this.name, value));
    }

    public OperationExpression Ne(Link value) {
        return this.Ne(new Param(this.name, value));
    }
}

