/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.rules.conditions;

import io.intino.itrules.Frame;
import io.intino.itrules.Rule;
import io.intino.itrules.TemplateEngine;
import java.util.Iterator;

public class AttributeCondition
implements Rule.Condition {
    private static final String THIS = "this";
    private final String attribute;
    private final boolean isThis;
    private Object value;

    public AttributeCondition(String attribute) {
        this(attribute, null);
    }

    public AttributeCondition(String attribute, Object value) {
        this.isThis = attribute.equals(THIS) || attribute.isEmpty();
        this.attribute = this.isThis ? "" : attribute.toLowerCase();
        this.value = value;
    }

    public String attribute() {
        return this.attribute;
    }

    public Object value() {
        return this.value;
    }

    @Override
    public boolean check(TemplateEngine.Trigger trigger) {
        return this.checkAttribute(trigger.frame()) && this.checkValue(trigger.frame());
    }

    private boolean checkAttribute(Frame frame) {
        return this.isThis ? frame != null : frame.contains(this.attribute);
    }

    private boolean checkValue(Frame frame) {
        if (this.value == null) {
            return true;
        }
        return this.isThis ? this.equalTo(frame.value()) : this.isIn(frame);
    }

    private boolean isIn(Frame frame) {
        Iterator<Frame> frames = frame.frames(this.attribute);
        while (frames.hasNext()) {
            if (!this.equalTo(frames.next().value())) continue;
            return true;
        }
        return false;
    }

    private boolean equalTo(Object o) {
        if (o == null) {
            return false;
        }
        return this == o || o.toString().equalsIgnoreCase(this.value.toString());
    }
}

