/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.Definition;
import org.monet.metamodel.ReferenceableProperty;
import org.monet.space.kernel.model.DefinitionType;

public class MeasureUnitDefinition
extends Definition {
    protected LinkedHashMap<String, ScaleProperty> _scalePropertyMap = new LinkedHashMap();

    @Override
    public DefinitionType getType() {
        return null;
    }

    public void addScale(ScaleProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        ScaleProperty current = this._scalePropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    ScaleProperty instance = (ScaleProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._scalePropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._scalePropertyMap.put(key, value);
        }
    }

    public Map<String, ScaleProperty> getScaleMap() {
        return this._scalePropertyMap;
    }

    public Collection<ScaleProperty> getScaleList() {
        return this._scalePropertyMap.values();
    }

    public void copy(MeasureUnitDefinition instance) {
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        for (ScaleProperty item : instance._scalePropertyMap.values()) {
            this.addScale(item);
        }
        this._isAbstract = instance._isAbstract;
    }

    public void merge(MeasureUnitDefinition child) {
        super.merge(child);
        for (ScaleProperty item : child._scalePropertyMap.values()) {
            this.addScale(item);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return MeasureUnitDefinition.class;
    }

    public static class ScaleProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected Double _max;
        protected Double _factor;

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public Double getMax() {
            return this._max;
        }

        public void setMax(Double value) {
            this._max = value;
        }

        public Double getFactor() {
            return this._factor;
        }

        public void setFactor(Double value) {
            this._factor = value;
        }

        protected void copy(ScaleProperty instance) {
            this._label = instance._label;
            this._max = instance._max;
            this._factor = instance._factor;
            this._code = instance._code;
            this._name = instance._name;
        }

        protected void merge(ScaleProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (child._max != null) {
                this._max = child._max;
            }
            if (child._factor != null) {
                this._factor = child._factor;
            }
        }
    }
}

