/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.CategoryProperty;
import org.monet.metamodel.EntityDefinition;
import org.monet.metamodel.ReferenceableProperty;
import org.monet.metamodel.TaxonomyRuleProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.DefinitionType;

public class DimensionDefinition
extends EntityDefinition {
    protected LinkedHashMap<String, FeatureProperty> _featurePropertyMap = new LinkedHashMap();
    protected LinkedHashMap<String, TaxonomyProperty> _taxonomyPropertyMap = new LinkedHashMap();

    @Override
    public DefinitionType getType() {
        return null;
    }

    public void addFeature(FeatureProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        FeatureProperty current = this._featurePropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    FeatureProperty instance = (FeatureProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._featurePropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._featurePropertyMap.put(key, value);
        }
    }

    public Map<String, FeatureProperty> getFeatureMap() {
        return this._featurePropertyMap;
    }

    public Collection<FeatureProperty> getFeatureList() {
        return this._featurePropertyMap.values();
    }

    public void addTaxonomy(TaxonomyProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        TaxonomyProperty current = this._taxonomyPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    TaxonomyProperty instance = (TaxonomyProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._taxonomyPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._taxonomyPropertyMap.put(key, value);
        }
    }

    public Map<String, TaxonomyProperty> getTaxonomyMap() {
        return this._taxonomyPropertyMap;
    }

    public Collection<TaxonomyProperty> getTaxonomyList() {
        return this._taxonomyPropertyMap.values();
    }

    public void copy(DimensionDefinition instance) {
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        for (FeatureProperty featureProperty : instance._featurePropertyMap.values()) {
            this.addFeature(featureProperty);
        }
        for (TaxonomyProperty taxonomyProperty : instance._taxonomyPropertyMap.values()) {
            this.addTaxonomy(taxonomyProperty);
        }
        this._isAbstract = instance._isAbstract;
    }

    public void merge(DimensionDefinition child) {
        super.merge(child);
        for (FeatureProperty featureProperty : child._featurePropertyMap.values()) {
            this.addFeature(featureProperty);
        }
        for (TaxonomyProperty taxonomyProperty : child._taxonomyPropertyMap.values()) {
            this.addTaxonomy(taxonomyProperty);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return DimensionDefinition.class;
    }

    public static class TaxonomyProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected LinkedHashMap<String, CategoryProperty> _categoryPropertyMap = new LinkedHashMap();
        protected ArrayList<TaxonomyRuleProperty> _taxonomyRulePropertyList = new ArrayList();

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public void addCategoryProperty(CategoryProperty value) {
            String key = value.getName() != null ? value.getName() : value.getCode();
            CategoryProperty current = this._categoryPropertyMap.get(key);
            if (current != null) {
                if (current.getClass().isAssignableFrom(value.getClass())) {
                    try {
                        CategoryProperty instance = (CategoryProperty)value.getClass().newInstance();
                        instance.copy(current);
                        instance.setCode(value.getCode());
                        instance.setName(value.getName());
                        instance.merge(value);
                        this._categoryPropertyMap.put(key, instance);
                    }
                    catch (Exception exception) {}
                } else {
                    current.merge(value);
                }
            } else {
                this._categoryPropertyMap.put(key, value);
            }
        }

        public Map<String, CategoryProperty> getCategoryPropertyMap() {
            return this._categoryPropertyMap;
        }

        public Collection<CategoryProperty> getCategoryPropertyList() {
            return this._categoryPropertyMap.values();
        }

        public void addTaxonomyRuleProperty(TaxonomyRuleProperty value) {
            this._taxonomyRulePropertyList.add(value);
        }

        public ArrayList<TaxonomyRuleProperty> getTaxonomyRulePropertyList() {
            return this._taxonomyRulePropertyList;
        }

        protected void copy(TaxonomyProperty instance) {
            this._label = instance._label;
            this._code = instance._code;
            this._name = instance._name;
            for (CategoryProperty item : instance._categoryPropertyMap.values()) {
                this.addCategoryProperty(item);
            }
            this._taxonomyRulePropertyList.addAll(instance._taxonomyRulePropertyList);
        }

        protected void merge(TaxonomyProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            for (CategoryProperty item : child._categoryPropertyMap.values()) {
                this.addCategoryProperty(item);
            }
            this._taxonomyRulePropertyList.addAll(child._taxonomyRulePropertyList);
        }
    }

    public static class FeatureProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected TypeEnumeration _type;
        protected Ref _source;
        protected Ref _metric;

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public TypeEnumeration getType() {
            return this._type;
        }

        public void setType(TypeEnumeration value) {
            this._type = value;
        }

        public Ref getSource() {
            return this._source;
        }

        public void setSource(Ref value) {
            this._source = value;
        }

        public Ref getMetric() {
            return this._metric;
        }

        public void setMetric(Ref value) {
            this._metric = value;
        }

        protected void copy(FeatureProperty instance) {
            this._label = instance._label;
            this._type = instance._type;
            this._source = instance._source;
            this._metric = instance._metric;
            this._code = instance._code;
            this._name = instance._name;
        }

        protected void merge(FeatureProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (child._type != null) {
                this._type = child._type;
            }
            if (child._source != null) {
                this._source = child._source;
            }
            if (child._metric != null) {
                this._metric = child._metric;
            }
        }

        public static enum TypeEnumeration {
            STRING,
            TERM,
            BOOLEAN,
            INTEGER,
            REAL,
            DATE;

        }
    }
}

