/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.Renderer;
import io.intino.goros.modernizing.monet.renderers.templates.konos.TasksTemplate;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.TaskDefinition;

public class TasksRenderer
extends Renderer {
    public TasksRenderer(Dictionary dictionary, Modernization modernization) {
        super(dictionary, modernization);
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        this.writeJava(builder);
        this.writeKonos(builder);
        this.writeTaskTrayTemplate();
        this.writeTaskBoardTemplate();
        this.writeEmbeddedTemplate();
        this.writeNodeTasksTemplate();
    }

    private FrameBuilder buildFrame() {
        FrameBuilder result = this.baseFrame().add("tasks");
        this.addTasks(result);
        return result;
    }

    private FrameBuilder inboxFrame(String type) {
        FrameBuilder result = this.buildFrame().add("inbox");
        result.add("inboxType", type);
        return result;
    }

    private void addTasks(FrameBuilder builder) {
        this.dictionary.getTaskDefinitionList().stream().filter(t -> t instanceof ProcessDefinition).forEach(d -> this.addTask((TaskDefinition)d, builder));
    }

    private void addTask(TaskDefinition definition, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("process");
        result.add("name", this.nameOf(definition));
        result.add("code", definition.getCode());
        builder.add("process", result);
    }

    protected void writeJava(FrameBuilder builder) {
        File file = new File(this.javaPackage() + "TasksTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.TasksTemplate().render(builder.toFrame()));
    }

    protected void writeKonos(FrameBuilder builder) {
        File file = new File(this.konosPackage() + "Tasks.konos");
        this.writeFrame(file, new TasksTemplate().render(builder.toFrame()));
    }

    protected void writeTaskTrayTemplate() {
        FrameBuilder builder = this.inboxFrame("TaskTray");
        File file = new File(this.javaPackage() + "TaskTrayTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.TasksTemplate().render(builder.toFrame()));
    }

    protected void writeTaskBoardTemplate() {
        FrameBuilder builder = this.inboxFrame("TaskBoard");
        File file = new File(this.javaPackage() + "TaskBoardTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.TasksTemplate().render(builder.toFrame()));
    }

    protected void writeEmbeddedTemplate() {
        FrameBuilder builder = this.buildFrame().add("embedded");
        File file = new File(this.javaPackage() + "TasksEmbeddedTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.TasksTemplate().render(builder.toFrame()));
    }

    private void writeNodeTasksTemplate() {
        FrameBuilder builder = this.buildFrame().add("nodetasks");
        File file = new File(this.javaPackage() + "NodeTasksTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.TasksTemplate().render(builder.toFrame()));
    }
}

