/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.monet.util.StringUtil;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.CompositeFieldProperty;
import org.monet.metamodel.Definition;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeDefinitionBase;
import org.monet.metamodel.NodeFieldProperty;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.internal.Ref;

public abstract class NodeRenderer<D extends NodeDefinition>
extends DefinitionRenderer<D> {
    private static final int MaxOperationsInToolbar = 2;

    public NodeRenderer(Dictionary dictionary, Modernization modernization, D definition) {
        super(dictionary, modernization, definition);
    }

    protected abstract FrameBuilder viewFrame(NodeViewProperty var1);

    protected abstract boolean hasTemplate(NodeViewProperty var1);

    protected abstract boolean isVisibleOnRevision(NodeViewProperty var1);

    @Override
    public void write() {
        super.write();
        this.writeEmbeddedTemplate();
        this.writeViewsTemplate();
    }

    @Override
    protected FrameBuilder buildFrame() {
        return this.buildFrame(false);
    }

    protected FrameBuilder baseViewFrame(NodeViewProperty viewProperty) {
        FrameBuilder result = this.baseFrame().add("nodeview");
        NodeDefinition definition = (NodeDefinition)this.definition();
        result.add(this.typeOf(viewProperty));
        result.add("definition", this.nameOf(definition));
        result.add("code", viewProperty.getCode());
        result.add("name", this.nameOf(viewProperty));
        result.add("label", this.clean(this.labelOf(viewProperty)));
        if (viewProperty.isVisibleWhenEmbedded()) {
            result.add("visibleWhenEmbedded");
        }
        if (!this.isVisibleOnRevision(viewProperty)) {
            result.add("notVisibleOnRevision");
        }
        return result;
    }

    protected void addParent(FrameBuilder builder) {
        NodeDefinition parent = this.findParentDefinition();
        if (parent == null) {
            return;
        }
        FrameBuilder result = this.baseFrame().add("parent");
        result.add("name", this.nameOf(parent));
        result.add("label", this.clean(parent.getLabel()));
        if (parent.isSingleton()) {
            result.add("singleton");
        }
        this.addResourceType(parent, result);
        builder.add("parent", result);
    }

    protected void addDisplayFor(FieldProperty field, FrameBuilder builder) {
        if (field instanceof CompositeFieldProperty) {
            ((CompositeFieldProperty)field).getAllFieldPropertyList().forEach(f -> this.addDisplayFor((FieldProperty)f, builder));
        } else if (field instanceof NodeFieldProperty) {
            List<NodeDefinition> nodeDefinitionList = this.nodeDefinitions((NodeFieldProperty)field);
            nodeDefinitionList.forEach(definition -> this.addDisplayFor((NodeDefinition)definition, (NodeViewProperty)null, builder));
        }
    }

    protected void writeEmbeddedTemplate() {
        this.resetAddedDisplays();
        FrameBuilder builder = this.buildFrame().add("embedded");
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + "EmbeddedTemplate.java");
        this.writeFrame(file, this.javaTemplate().render(builder.toFrame()));
    }

    protected void writeViewsTemplate() {
        ((NodeDefinition)this.definition()).getViewDefinitionList().stream().filter(this::hasTemplate).forEach(this::writeViewTemplate);
    }

    private FrameBuilder buildFrame(boolean revision) {
        FrameBuilder result = this.baseDefinitionFrame().add("nodedefinition");
        if (revision) {
            result.add("revision");
        }
        if (((NodeDefinition)this.definition()).isSingleton()) {
            result.add("singleton");
            result.add("singleton", ((NodeDefinition)this.definition()).getCode());
        }
        result.add("readonly", ((NodeDefinition)this.definition()).isReadonly() ? "true" : "readonly");
        this.addDesktop(result);
        this.addParent(result);
        this.addToolbar(result);
        this.addViews(result, revision);
        return result;
    }

    private void addToolbar(FrameBuilder builder) {
        builder.add("toolbar", this.toolbarFrame());
    }

    protected FrameBuilder toolbarFrame() {
        boolean collectable;
        FrameBuilder result = this.baseFrame().add("toolbar");
        result.add("definition", this.nameOf((Definition)this.definition()));
        if (((NodeDefinition)this.definition()).isSingleton()) {
            result.add("singleton");
        }
        boolean bl = collectable = this.findParentDefinition() != null;
        if (collectable) {
            result.add("collectable");
        }
        if (((NodeDefinition)this.definition()).isSet()) {
            result.add("collection");
        }
        this.addOperations((NodeDefinition)this.definition(), result);
        this.addResourceType((Definition)this.definition(), result);
        return result;
    }

    protected void addOperations(D definition, FrameBuilder result) {
        List<NodeDefinitionBase.OperationProperty> allowGroupOperations = this.allowGroupOperations(definition);
        if (allowGroupOperations.size() >= 2) {
            this.addOperationsGroup(definition, allowGroupOperations, result);
            this.disallowGroupOperations(definition).forEach(o -> this.addOperation((NodeDefinitionBase.OperationProperty)o, result));
        } else {
            ((NodeDefinitionBase)definition).getOperationList().forEach(o -> this.addOperation((NodeDefinitionBase.OperationProperty)o, result));
        }
    }

    private List<NodeDefinitionBase.OperationProperty> allowGroupOperations(D definition) {
        return ((NodeDefinitionBase)definition).getOperationList().stream().filter(this::allowGrouping).collect(Collectors.toList());
    }

    private List<NodeDefinitionBase.OperationProperty> disallowGroupOperations(D definition) {
        return ((NodeDefinitionBase)definition).getOperationList().stream().filter(o -> !this.allowGrouping((NodeDefinitionBase.OperationProperty)o)).collect(Collectors.toList());
    }

    private boolean allowGrouping(NodeDefinitionBase.OperationProperty o) {
        return !this.isDownloadOperation(o) && o.getConfirmation() == null;
    }

    protected void addOperationsGroup(D definition, List<NodeDefinitionBase.OperationProperty> groupableOperations, FrameBuilder builder) {
        FrameBuilder result = new FrameBuilder("operationsGroup");
        groupableOperations.forEach(o -> this.addOperation((NodeDefinitionBase.OperationProperty)o, result));
        result.add("defaultOperation", groupableOperations.get(0).getLabel());
        builder.add("operationsGroup", result);
    }

    protected void addOperation(NodeDefinitionBase.OperationProperty operation, FrameBuilder builder) {
        FrameBuilder result = new FrameBuilder("operation");
        if (this.isDownloadOperation(operation)) {
            result.add("download");
        }
        if (operation.getConfirmation() != null) {
            result.add("confirmation");
        }
        result.add("name", operation.getName());
        result.add("label", this.clean(operation.getLabel()));
        result.add("dispatchOperationListener", this.dispatchOperationListenerFrame());
        if (operation.getConfirmation() != null) {
            result.add("confirmText", operation.getConfirmation().getDescription());
        }
        builder.add("operation", result);
    }

    protected FrameBuilder dispatchOperationListenerFrame() {
        NodeDefinition definition = (NodeDefinition)this.definition();
        FrameBuilder result = this.baseFrame();
        result.add("dispatchOperationListener");
        if (definition.getType() != null) {
            result.add(definition.getType().name().toLowerCase());
        }
        if (definition.isSingleton()) {
            result.add("singleton");
        }
        return result;
    }

    protected boolean isDownloadOperation(NodeDefinitionBase.OperationProperty operation) {
        String name = operation.getName().toLowerCase();
        String label = ((String)operation.getLabel()).toLowerCase();
        return name.contains("descargar") || name.contains("download") || label.contains("descargar") || label.contains("download");
    }

    private NodeDefinition findParentDefinition() {
        return this.dictionary.getCollectionDefinitionList().stream().filter(c -> {
            ArrayList<Ref> refList = c.getAdd().getNode();
            return refList.stream().map(ref -> this.dictionary.getAllImplementersOfNodeDefinition(ref.getValue())).flatMap(Collection::stream).anyMatch(def -> def.getCode().equals(((NodeDefinition)this.definition()).getCode()));
        }).findFirst().orElse(null);
    }

    private void addViews(FrameBuilder builder, boolean revision) {
        ((NodeDefinition)this.definition()).getViewDefinitionList().stream().filter(v -> !revision || this.isVisibleOnRevision((NodeViewProperty)v)).forEach(v -> this.addView((NodeViewProperty)v, builder));
    }

    private void addView(NodeViewProperty viewProperty, FrameBuilder builder) {
        if (this.typeOf(viewProperty) == null) {
            return;
        }
        builder.add("view", this.viewFrame(viewProperty));
    }

    private void writeViewTemplate(NodeViewProperty view) {
        this.resetAddedDisplays();
        FrameBuilder viewFrame = this.viewFrame(view);
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + StringUtil.firstUpperCase(this.nameOf(view)) + "ViewTemplate.java");
        this.writeFrame(file, this.javaTemplate().render(viewFrame.toFrame()));
    }

    private List<NodeDefinition> nodeDefinitions(NodeFieldProperty field) {
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        if (field.getContain() != null) {
            result.add(this.dictionary.getNodeDefinition(field.getContain().getNode().getValue()));
        }
        if (field.getAdd() != null) {
            field.getAdd().getNode().forEach(ref -> result.add(this.dictionary.getNodeDefinition(ref.getValue())));
        }
        return result;
    }
}

