/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.definition.NodeRenderer;
import io.intino.goros.modernizing.monet.renderers.templates.java.DesktopTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.util.ArrayList;
import org.monet.metamodel.Definition;
import org.monet.metamodel.DesktopDefinition;
import org.monet.metamodel.DesktopDefinitionBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.internal.Ref;

public class DesktopRenderer
extends NodeRenderer<DesktopDefinition> {
    public DesktopRenderer(Dictionary dictionary, Modernization modernization, DesktopDefinition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        this.writeJava(builder);
        this.writeKonos(builder);
    }

    @Override
    protected FrameBuilder buildFrame() {
        return super.buildFrame().add("desktopdefinition");
    }

    @Override
    protected FrameBuilder viewFrame(NodeViewProperty viewProperty) {
        FrameBuilder result = this.baseViewFrame(viewProperty);
        this.addShow((DesktopDefinitionBase.ViewProperty)viewProperty, result);
        return result;
    }

    private void addShow(DesktopDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("show");
        this.addItems(viewProperty.getShow().getLink(), result);
        this.addItems(viewProperty.getShow().getDashboard(), result);
        builder.add("show", result);
    }

    private void addItems(ArrayList<Ref> itemList, FrameBuilder builder) {
        itemList.forEach(item -> this.addItem((Ref)item, builder));
    }

    private void addItem(Ref item, FrameBuilder builder) {
        Definition definition = this.dictionary.getDefinition(item.getValue());
        FrameBuilder result = this.baseFrame().add("item");
        result.add(definition.getType().name().toLowerCase());
        result.add("name", this.nameOf(definition));
        result.add("code", definition.getCode());
        result.add("label", this.clean(definition.getLabel()));
        result.add("description", definition.getDescription());
        this.addResourceType(definition, result);
        builder.add("item", result);
    }

    @Override
    protected boolean isVisibleOnRevision(NodeViewProperty viewProperty) {
        return false;
    }

    @Override
    protected boolean hasTemplate(NodeViewProperty viewProperty) {
        return false;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.monet.renderers.templates.konos.DesktopTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new DesktopTemplate();
    }
}

