/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.xml.Node;
import io.intino.alexandria.xml.Xml;
import io.intino.goros.modernizing.monet.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Modernization {
    private Map<String, String> properties = new HashMap<String, String>();

    public String version() {
        return this.properties.getOrDefault("version", "");
    }

    public File logo() {
        return new File(this.properties.getOrDefault("logo", ""));
    }

    public File businessModel() {
        return new File(this.properties.getOrDefault("model", ""));
    }

    public String projectPackage() {
        return this.properties.getOrDefault("project.package", "");
    }

    public String projectPackageDirectory() {
        return this.projectPackage().replace(".", File.separator);
    }

    public String sourceDirectory() {
        return this.moduleDirectory() + File.separator + "src" + File.separator + this.projectPackageDirectory() + File.separator + this.moduleName();
    }

    public String sourceBoxDirectory() {
        return this.sourceDirectory() + File.separator + "box";
    }

    public String sourceGraphDirectory() {
        return this.sourceDirectory() + File.separator + "graph";
    }

    public String sourceUiDirectory() {
        return this.sourceBoxDirectory() + File.separator + "ui";
    }

    public String projectName() {
        return this.properties.getOrDefault("project.name", "");
    }

    public File projectDirectory() {
        return new File(this.properties.getOrDefault("project.directory", ""));
    }

    public String moduleName() {
        return this.properties.getOrDefault("module.name", "");
    }

    public String boxName() {
        String boxName = this.properties.getOrDefault("artifact.name", "");
        if (boxName.isEmpty()) {
            return this.moduleName();
        }
        return StringUtil.snakeCaseToCamelCase(boxName);
    }

    public File moduleDirectory() {
        return new File(this.projectDirectory() + File.separator + this.moduleName());
    }

    public List<String> excludedDefinitions() {
        String value = this.properties.getOrDefault("definitions.excluded", "");
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(","));
    }

    private void put(String key, String value) {
        this.properties.put(key, value);
    }

    public static Modernization load(File file) {
        try {
            Modernization modernization = new Modernization();
            Xml xml = new Xml(new FileInputStream(file));
            Node root = xml.document().getChildNodes().get(0);
            org.w3c.dom.Node projectNode = root.child("project").get();
            org.w3c.dom.Node moduleNode = root.child("module").get();
            org.w3c.dom.Node artifactNode = root.child("artifact") != null ? root.child("artifact").get() : null;
            org.w3c.dom.Node definitionsNode = root.child("definitions").get();
            modernization.put("model", root.child("model").get().getTextContent());
            modernization.put("project.name", projectNode.getAttributes().getNamedItem("name").getTextContent());
            modernization.put("project.package", projectNode.getAttributes().getNamedItem("package").getTextContent());
            modernization.put("project.directory", projectNode.getAttributes().getNamedItem("directory").getTextContent());
            modernization.put("module.name", moduleNode.getAttributes().getNamedItem("name").getTextContent());
            modernization.put("artifact.name", artifactNode != null ? artifactNode.getAttributes().getNamedItem("name").getTextContent() : "");
            modernization.put("definitions.excluded", definitionsNode.getAttributes().getNamedItem("excluded").getTextContent());
            return modernization;
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }
}

