/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.ActivityDefinition;
import org.monet.metamodel.PlaceProperty;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.ProcessDefinitionBase;
import org.monet.metamodel.TaskContestProperty;
import org.monet.metamodel.TaskProviderProperty;

public class ActivityDefinitionBase
extends ProcessDefinition {
    protected LinkedHashMap<String, ActivityDefinition.ActivityPlaceProperty> _activityPlacePropertyMap = new LinkedHashMap();

    public void addPlace(ActivityDefinition.ActivityPlaceProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        ActivityDefinition.ActivityPlaceProperty current = this._activityPlacePropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    ActivityDefinition.ActivityPlaceProperty instance = (ActivityDefinition.ActivityPlaceProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._activityPlacePropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._activityPlacePropertyMap.put(key, value);
        }
    }

    public Map<String, ActivityDefinition.ActivityPlaceProperty> getPlaceMap() {
        return this._activityPlacePropertyMap;
    }

    public Collection<ActivityDefinition.ActivityPlaceProperty> getPlaceList() {
        return this._activityPlacePropertyMap.values();
    }

    public void copy(ActivityDefinitionBase instance) {
        this._target = instance._target;
        this._role = instance._role;
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        for (ActivityDefinition.ActivityPlaceProperty activityPlaceProperty : instance._activityPlacePropertyMap.values()) {
            this.addPlace(activityPlaceProperty);
        }
        for (ProcessDefinitionBase.ShortcutProperty shortcutProperty : instance._shortcutPropertyMap.values()) {
            this.addShortcut(shortcutProperty);
        }
        this._isManual = instance._isManual;
        for (ProcessDefinitionBase.ViewProperty viewProperty : instance._viewPropertyMap.values()) {
            this.addView(viewProperty);
        }
        this._isPrivate = instance._isPrivate;
        this._isBackground = instance._isBackground;
        this._isAbstract = instance._isAbstract;
        for (TaskContestProperty taskContestProperty : instance._taskContestPropertyMap.values()) {
            this.addTaskContestProperty(taskContestProperty);
        }
        for (TaskProviderProperty taskProviderProperty : instance._taskProviderPropertyMap.values()) {
            this.addTaskProviderProperty(taskProviderProperty);
        }
    }

    public void merge(ActivityDefinitionBase child) {
        super.merge(child);
        for (ActivityDefinition.ActivityPlaceProperty item : child._activityPlacePropertyMap.values()) {
            this.addPlace(item);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return ActivityDefinitionBase.class;
    }

    public static class ActivityPlacePropertyBase
    extends PlaceProperty {
        protected void copy(ActivityPlacePropertyBase instance) {
            this._code = instance._code;
            this._name = instance._name;
            this._isInitial = instance._isInitial;
            this._isOust = instance._isOust;
            this._isFinal = instance._isFinal;
            this._backEnableProperty = instance._backEnableProperty;
            this.setEditionActionProperty(instance._editionActionProperty);
            this.setWaitActionProperty(instance._waitActionProperty);
            this.setSendResponseActionProperty(instance._sendResponseActionProperty);
            this.setSendRequestActionProperty(instance._sendRequestActionProperty);
            this.setSendJobActionProperty(instance._sendJobActionProperty);
            this.setLineActionProperty(instance._lineActionProperty);
            this.setEnrollActionProperty(instance._enrollActionProperty);
            this.setDoorActionProperty(instance._doorActionProperty);
            this.setDelegationActionProperty(instance._delegationActionProperty);
        }

        protected void merge(ActivityPlacePropertyBase child) {
            super.merge(child);
        }
    }
}

