/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.rules.output;

import io.intino.itrules.Rule;

public class Mark
implements Rule.Output {
    private static final String OptionSeparator = "+";
    private static final String THIS = "this";
    public static final Rule.Output This = new Mark("", new String[0]);
    private final boolean isThis;
    private final String name;
    private final String[] formatters;
    private String separator = null;

    public Mark(String name, String ... formatters) {
        this.isThis = name.equals(THIS) || name.isEmpty();
        this.name = this.isThis ? "" : name;
        this.formatters = formatters;
    }

    public String name() {
        return this.name;
    }

    public String[] formatters() {
        return this.formatters;
    }

    public String separator() {
        return this.separator;
    }

    public boolean isThis() {
        return this.isThis;
    }

    private boolean isMultiple() {
        return this.separator != null;
    }

    public String fullName() {
        StringBuilder result = new StringBuilder(this.name);
        for (String formatter : this.formatters) {
            result.append(OptionSeparator).append(formatter);
        }
        return result.toString();
    }

    public Mark multiple(String separator) {
        this.separator = separator;
        return this;
    }

    public String toString() {
        return "[" + this.fullName() + (this.isMultiple() ? "..." : "") + "]";
    }
}

