/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.adapters;

import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilderContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class DefaultAdapter<T>
implements Adapter<T> {
    @Override
    public void adapt(T source, FrameBuilderContext context) {
        new SlotBuilder(source, context).create();
    }

    private boolean isExcluded(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || this.isContextFieldOfInnerClass(field);
    }

    protected boolean isProcessable(Field field) {
        return !this.isExcluded(field);
    }

    private boolean isContextFieldOfInnerClass(Field field) {
        return field.getName().startsWith("this$");
    }

    private class SlotBuilder {
        private static final String Count = "Count";
        private FrameBuilderContext context;
        private Object source;

        SlotBuilder(Object source, FrameBuilderContext context) {
            this.context = context;
            this.source = source;
        }

        void create() {
            try {
                this.execute(this.source.getClass());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        private void execute(Class aClass) throws IllegalAccessException {
            while (aClass != null) {
                this.processClass(aClass);
                aClass = aClass.getSuperclass();
            }
        }

        private void processClass(Class aClass) throws IllegalAccessException {
            for (Field field : aClass.getDeclaredFields()) {
                if (!DefaultAdapter.this.isProcessable(field)) continue;
                this.processField(field);
            }
        }

        private void processField(Field field) throws IllegalAccessException {
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            if (field.get(this.source) != null) {
                this.processField(field.getName(), field.get(this.source));
            }
            field.setAccessible(accessibility);
        }

        private void processField(String name, Object value) {
            if (this.isArray(value.getClass())) {
                this.processArray(name, value);
            } else if (this.isList(value.getClass())) {
                this.processList(name, value);
            } else if (this.isMap(value.getClass())) {
                this.processMap(name, value);
            } else {
                this.context.add(name, value);
            }
        }

        private void processArray(String name, Object value) {
            Object[] objects = (Object[])value;
            this.context.add(name + Count, objects.length);
            for (Object item : objects) {
                this.context.add(name, item);
            }
        }

        private void processList(String name, Object value) {
            List list = (List)value;
            this.context.add(name + Count, list.size());
            for (Object item : list) {
                this.context.add(name, item);
            }
        }

        private void processMap(String name, Object value) {
            Map map = (Map)value;
            this.context.add(name + Count, map.keySet().size());
            for (Object key : map.keySet()) {
                this.context.add(name, new Item(key, map.get(key)));
            }
        }

        private boolean isMap(Class<?> aClass) {
            return Map.class.isAssignableFrom(aClass);
        }

        private boolean isList(Class<?> aClass) {
            return List.class.isAssignableFrom(aClass);
        }

        private boolean isArray(Class<?> aClass) {
            return aClass.isArray();
        }
    }

    private static class Item {
        Object key;
        Object value;

        Item(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

