/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules;

import io.intino.itrules.Adapter;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.formatters.DateFormatters;
import io.intino.itrules.formatters.NumberFormatters;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.itrules.rules.output.Expression;
import io.intino.itrules.rules.output.Literal;
import io.intino.itrules.rules.output.Mark;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemplateEngine {
    private static final String Blanks = " \u00a0\t\n";
    private static final String NewLine = "\n";
    private final RuleSet ruleSet;
    private final Configuration configuration;
    private final Map<String, Formatter> formatters;
    private final Map<Class, Adapter> adapters;

    public TemplateEngine(RuleSet ruleSet) {
        this(ruleSet, new Configuration());
    }

    public TemplateEngine(RuleSet ruleSet, Configuration configuration) {
        this.ruleSet = ruleSet;
        this.configuration = configuration;
        this.formatters = this.formattersFor(configuration);
        this.adapters = new HashMap<Class, Adapter>();
    }

    public TemplateEngine add(String name, Formatter formatter) {
        this.formatters.put(name.toLowerCase(), formatter);
        return this;
    }

    public <T> TemplateEngine add(Class<T> class_, Adapter<T> adapter) {
        this.adapters.put(class_, adapter);
        return this;
    }

    public String render(Object object) {
        return this.generate(new Trigger("root").on(this.frameOf(object)));
    }

    private String generate(Trigger trigger) {
        return this.write(new Display(trigger).generate());
    }

    private String write(Canvas canvas) {
        return canvas.contentWith(this.configuration);
    }

    private Frame frameOf(Object object) {
        if (object instanceof Frame) {
            return (Frame)object;
        }
        if (object instanceof FrameBuilder) {
            return ((FrameBuilder)object).toFrame();
        }
        return new FrameBuilder().put(this.adapters).append(object).toFrame();
    }

    private Map<String, Formatter> formattersFor(Configuration configuration) {
        HashMap<String, Formatter> map = new HashMap<String, Formatter>();
        map.putAll(StringFormatters.get(configuration.locale));
        map.putAll(NumberFormatters.get(configuration.locale));
        map.putAll(DateFormatters.get(configuration.locale));
        return map;
    }

    private static boolean isBlank(char c) {
        return Blanks.indexOf(c) >= 0;
    }

    private static class Canvas {
        private StringBuilder sb = new StringBuilder();
        private boolean touched = false;

        Canvas append(String s) {
            this.sb.append(s);
            return this;
        }

        String contentWith(Configuration configuration) {
            return this.clean(this.withoutStakes(this.sb).toString()).collect(Collectors.joining(configuration.isCRLF() ? "\r\n" : TemplateEngine.NewLine));
        }

        private Stream<String> clean(String str) {
            return this.clean(str.split(TemplateEngine.NewLine));
        }

        private Stream<String> clean(String[] lines) {
            return Arrays.stream(lines).map(this::cleanLine);
        }

        private String cleanLine(String line) {
            return line.replaceAll("^\\s*$", "");
        }

        Canvas touch() {
            this.touched = true;
            return this;
        }

        boolean isTouched() {
            return this.touched;
        }

        boolean isNotTouched() {
            return !this.isTouched();
        }

        Canvas stake() {
            this.sb.appendCodePoint(65535);
            return this;
        }

        private StringBuilder withoutStakes(StringBuilder sb) {
            return sb.codePoints().filter(c -> c != 65535).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append);
        }

        public boolean isEmpty() {
            return this.sb.length() == 0;
        }

        public boolean isNotEmpty() {
            return this.sb.length() > 0;
        }

        private void backSpaces() {
            int index;
            for (index = this.sb.length() - 1; index >= 0 && TemplateEngine.isBlank(this.sb.charAt(index)); --index) {
            }
            this.sb.delete(index + 1, this.sb.length());
        }

        public boolean hasNewLines() {
            return this.sb.indexOf(TemplateEngine.NewLine) >= 0;
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    private class Display {
        private final Trigger trigger;
        private final Canvas canvas;

        Display(Trigger trigger) {
            this.trigger = trigger;
            this.canvas = new Canvas();
        }

        private Display set(boolean constant) {
            if (constant) {
                this.canvas.touch();
            }
            return this;
        }

        Canvas generate() {
            return this.generate(this.ruleFor(this.trigger).outputs());
        }

        private Canvas generate(Stream<Rule.Output> outputs) {
            outputs.forEach(this::write);
            return this.canvas;
        }

        private Rule ruleFor(Trigger trigger) {
            for (Rule rule : TemplateEngine.this.ruleSet) {
                if (!rule.conditions().allMatch(trigger::check)) continue;
                return rule;
            }
            return this.defaultRule(trigger.frame);
        }

        private Rule defaultRule(Frame frame) {
            return this.hasValue(frame) ? new Rule().output(Mark.This) : new Rule().output(new Rule.Output[0]);
        }

        private void write(Rule.Output output) {
            if (output instanceof Literal) {
                this.write((Literal)output);
            }
            if (output instanceof Mark) {
                this.write((Mark)output);
            }
            if (output instanceof Expression) {
                this.write((Expression)output);
            }
        }

        private void write(Literal literal) {
            this.append(this.canvas, literal.toString());
        }

        private void write(Mark mark) {
            this.append(this.canvas, mark.isThis() ? this.evaluateThis(this.trigger.frame, mark.formatters()) : this.evaluate(mark));
        }

        private void write(Expression expression) {
            Canvas o = this.evaluate(expression);
            if (o.isNotTouched() || o.isEmpty()) {
                this.canvas.backSpaces();
            }
            this.append(this.canvas, o);
        }

        private Canvas evaluateThis(Frame frame, String[] formatters) {
            return this.hasValue(frame) ? this.evaluateThis(this.format(frame, formatters)) : new Canvas();
        }

        private Frame format(Frame frame, String[] formatters) {
            if (formatters.length == 0) {
                return frame;
            }
            Object object = frame.value() != null ? frame.value() : frame;
            for (String name : formatters) {
                object = this.formatter(name).format(object);
            }
            return TemplateEngine.this.frameOf(object);
        }

        private Formatter formatter(String name) {
            name = name.trim().toLowerCase();
            return TemplateEngine.this.formatters.getOrDefault(name, Formatter.Null);
        }

        private Canvas evaluateThis(Frame frame) {
            return new Canvas().append(this.valueOf(frame)).touch();
        }

        private Canvas evaluate(Mark mark) {
            return this.hasContent(mark) ? this.evaluate(mark, this.trigger.frames(mark.name())) : new Canvas();
        }

        private Canvas evaluate(Mark mark, Iterator<Frame> frames) {
            Canvas canvas = new Canvas();
            while (frames.hasNext()) {
                Frame frame = frames.next();
                this.append(canvas, this.evaluate(mark, frame), mark.separator());
            }
            return canvas;
        }

        private Canvas evaluate(Mark mark, Frame frame) {
            Canvas canvas = new Display(new Trigger(mark.fullName()).on(this.format(frame, mark.formatters()))).generate();
            if (canvas.isNotEmpty()) {
                canvas.touch();
            }
            return canvas;
        }

        private boolean hasValue(Frame frame) {
            return frame.value() != null;
        }

        private boolean hasContent(Mark mark) {
            return this.trigger.frames(mark.name()).hasNext();
        }

        private Canvas evaluate(Expression expression) {
            Canvas canvas = new Display(this.trigger).set(expression.isConstant()).generate(expression.outputs());
            return canvas.isTouched() ? canvas.stake() : this.validate(expression.next());
        }

        private Canvas validate(Expression expression) {
            return expression != null ? this.evaluate(expression) : new Canvas();
        }

        private void append(Canvas canvas, String str) {
            canvas.append(str);
        }

        private void append(Canvas canvas, Canvas o, String separator) {
            if (o.isNotTouched()) {
                return;
            }
            if (canvas.isNotEmpty()) {
                canvas.append(separator);
            }
            canvas.append(o.toString()).touch();
        }

        private void append(Canvas canvas, Canvas o) {
            if (o.isNotTouched()) {
                return;
            }
            canvas.append(this.indent(o.toString())).touch();
        }

        private String valueOf(Frame frame) {
            return frame.value().toString();
        }

        private String indent(String str) {
            return this.canvas.hasNewLines() ? this.replaceNewLines(str) : str;
        }

        private String replaceNewLines(String str) {
            return str.replace(TemplateEngine.NewLine, TemplateEngine.NewLine + this.indentOf(this.canvas.toString()));
        }

        private String indentOf(String str) {
            return this.onlyBlanks(str.substring(this.lastNewLine(str) + 1));
        }

        private int lastNewLine(String str) {
            return str.lastIndexOf(TemplateEngine.NewLine);
        }

        private String onlyBlanks(String str) {
            int first;
            int last;
            if (str.isEmpty()) {
                return "";
            }
            for (last = first = str.charAt(0) == '\uffff' ? 1 : 0; last < str.length() && TemplateEngine.isBlank(str.charAt(last)); ++last) {
            }
            return str.substring(first, last);
        }
    }

    public static class Trigger {
        private final String name;
        private Frame frame;

        Trigger(String name) {
            this.name = name.toLowerCase();
        }

        Trigger on(Frame frame) {
            this.frame = frame;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Frame frame() {
            return this.frame;
        }

        Iterator<Frame> frames(String slot) {
            return this.frame.frames(slot.toLowerCase());
        }

        boolean check(Rule.Condition condition) {
            return condition.check(this);
        }
    }

    public static class Configuration {
        private Locale locale;
        private LineSeparator lineSeparator;

        public Configuration(Locale locale, LineSeparator lineSeparator) {
            this.locale = locale;
            this.lineSeparator = lineSeparator;
        }

        Configuration() {
            this(Locale.ENGLISH, LineSeparator.LF);
        }

        boolean isCRLF() {
            return this.lineSeparator == LineSeparator.CRLF;
        }

        public static enum LineSeparator {
            LF,
            CRLF;

        }
    }
}

