/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.util;

import java.io.Serializable;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.StringTokenizer;

public class StringUtil {
    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static String stripAccents(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return s;
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String camelCaseToSnakeCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        Object result = String.valueOf(Character.toLowerCase(string.charAt(0)));
        for (int i = 1; i < string.length(); ++i) {
            result = (String)result + (Serializable)(Character.isUpperCase(string.charAt(i)) ? "-" + Character.toLowerCase(string.charAt(i)) : Character.valueOf(string.charAt(i)));
        }
        return result;
    }

    public static String snakeCaseToCamelCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        Object result = "";
        for (String part : string.replace("_", "-").split("-")) {
            result = (String)result + String.valueOf(Character.toUpperCase(part.charAt(0))) + part.substring(1);
        }
        return result;
    }

    public static String replaceSpecialChars(String sData, String sReplacement) {
        sData = sData.replaceAll("\n", sReplacement);
        sData = sData.replaceAll("\r", sReplacement);
        sData = sData.replaceAll("\t", sReplacement);
        return sData;
    }

    public static String cleanSpecialChars(String sData) {
        return StringUtil.replaceSpecialChars(sData, "");
    }

    public static String capitalize(String sContent) {
        char[] aChars = sContent.toCharArray();
        aChars[0] = Character.toUpperCase(aChars[0]);
        return new String(aChars);
    }

    public static String cleanAccents(String sData) {
        sData = sData.replaceAll("\u00e1", "a");
        sData = sData.replaceAll("\u00e0", "a");
        sData = sData.replaceAll("\u00e2", "a");
        sData = sData.replaceAll("\u00e3", "a");
        sData = sData.replaceAll("\u00aa", "a");
        sData = sData.replaceAll("\ufffd?", "A");
        sData = sData.replaceAll("\u00c0", "A");
        sData = sData.replaceAll("\u00c2", "A");
        sData = sData.replaceAll("\u00c3", "A");
        sData = sData.replaceAll("\u00e9", "e");
        sData = sData.replaceAll("\u00e8", "e");
        sData = sData.replaceAll("\u00ea", "e");
        sData = sData.replaceAll("\u00c9", "E");
        sData = sData.replaceAll("\u00c8", "E");
        sData = sData.replaceAll("\u00ca", "E");
        sData = sData.replaceAll("\u00f3", "o");
        sData = sData.replaceAll("\u00f2", "o");
        sData = sData.replaceAll("\u00f4", "o");
        sData = sData.replaceAll("\u00f5", "o");
        sData = sData.replaceAll("\u00ba", "o");
        sData = sData.replaceAll("\u00d3", "O");
        sData = sData.replaceAll("\u00d2", "O");
        sData = sData.replaceAll("\u00d4", "O");
        sData = sData.replaceAll("\u00d5", "O");
        sData = sData.replaceAll("\u00fa", "u");
        sData = sData.replaceAll("\u00f9", "u");
        sData = sData.replaceAll("\u00fb", "u");
        sData = sData.replaceAll("\u00da", "U");
        sData = sData.replaceAll("\u00d9", "U");
        sData = sData.replaceAll("\u00db", "U");
        sData = sData.replaceAll("\u00ed", "i");
        sData = sData.replaceAll("\u00ec", "i");
        sData = sData.replaceAll("\u00ee", "i");
        sData = sData.replaceAll("\ufffd?", "I");
        sData = sData.replaceAll("\u00cc", "I");
        sData = sData.replaceAll("\u00ce", "I");
        sData = sData.replaceAll("\u00e7", "c");
        sData = sData.replaceAll("\u00c7", "C");
        sData = sData.replaceAll("\u00f1", "n");
        sData = sData.replaceAll("\u00d1", "N");
        return sData;
    }

    public static String removeBrackets(String sData) {
        sData = sData.replaceAll("\\[", "");
        sData = sData.replaceAll("\\]", "");
        return sData;
    }

    public static String cleanString(String sContent, String sAlphabet) {
        String sAux = sContent;
        for (int iPos = 0; iPos < sContent.length(); ++iPos) {
            String sChar = sContent.substring(iPos, iPos + 1);
            if (sAlphabet.indexOf(sChar.toLowerCase()) != -1) continue;
            sAux = sAux.replace(sChar, "");
        }
        return sAux;
    }

    public static String cleanString(String sContent) {
        return StringUtil.cleanString(sContent, "abcdefghijklmnopqrstuvwxyz1234567890");
    }

    public static String greatestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }

    public static String[] getKeywords(String sData, Integer iMinLength) {
        HashMap<String, String> hmKeywords = new HashMap<String, String>();
        StringTokenizer tok = new StringTokenizer(sData);
        while (tok.hasMoreTokens()) {
            String sToken = tok.nextToken();
            sToken = StringUtil.cleanString(sToken, "abcdefghijklmnopqrstuvwxyz1234567890");
            if (iMinLength != null && sToken.length() <= iMinLength) continue;
            hmKeywords.put(sToken.toLowerCase(), sToken.toLowerCase());
        }
        return hmKeywords.keySet().toArray(new String[0]);
    }

    public static String[] getKeywordsWithEmpty(String data) {
        String[] keyWordsArray = StringUtil.getKeywords(data, null);
        if (keyWordsArray.length <= 0) {
            keyWordsArray = new String[]{""};
        }
        return keyWordsArray;
    }

    public static int getLevenshteinDistance(String s, String t) {
        if (s != null && t != null) {
            int n = s.length();
            int m = t.length();
            if (n == 0) {
                return m;
            }
            if (m == 0) {
                return n;
            }
            int[] p = new int[n + 1];
            int[] d = new int[n + 1];
            int i = 0;
            while (i <= n) {
                p[i] = i++;
            }
            for (int j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                d[0] = j;
                for (i = 1; i <= n; ++i) {
                    int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                    d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
                }
                int[] _d = p;
                p = d;
                d = _d;
            }
            return p[n];
        }
        return -1;
    }

    public static String replaceAll(String sContent, String sValue, String sReplacement) {
        Integer iPos = ((String)sContent).indexOf(sValue);
        while (iPos != -1) {
            String sLeftSide = ((String)sContent).substring(0, iPos);
            String sRightSide = ((String)sContent).substring(iPos + sValue.length());
            sContent = sLeftSide + sReplacement + sRightSide;
            ((String)sContent).substring(0, iPos);
            iPos = ((String)sContent).indexOf(sValue);
        }
        return sContent;
    }

    public static String generatePassword() {
        Object sPassword = "";
        String[] aSyllables = new String[]{"er", "in", "tia", "wol", "fe", "pre", "vet", "jo", "nes", "al", "len", "son", "cha", "ir", "ler", "bo", "ok", "tio", "nar", "sim", "ple", "bla", "ten", "toe", "cho", "co", "lat", "spe", "ak", "er", "po", "co", "lor", "pen", "cil", "li", "ght", "wh", "at", "the", "he", "ck", "is", "mam", "bo", "no", "fi", "ve", "any", "way", "pol", "iti", "cs", "ra", "dio", "sou", "rce", "sea", "rch", "pa", "per", "com", "bo", "sp", "eak", "st", "fi", "rst", "gr", "oup", "boy", "ea", "gle", "tr", "ail", "bi", "ble", "brb", "pri", "dee", "kay", "en", "be", "se"};
        Integer iCount = 1;
        while (iCount <= 4) {
            sPassword = Math.random() % 10.0 == 1.0 ? (String)sPassword + Integer.toString(Math.round(Math.round(Math.random() % 50.0) + 1L)) : (String)sPassword + aSyllables[Math.round(Math.round(Math.random() % 62.0))];
            iCount = iCount + 1;
        }
        return sPassword;
    }

    public static String implodeAndWrap(String[] aObject, String sDelimiter, String sWrapper) {
        Object sResult = "";
        for (int iPos = 0; iPos < aObject.length; ++iPos) {
            if (iPos != 0) {
                sResult = (String)sResult + sDelimiter;
            }
            sResult = (String)sResult + (sWrapper != null ? sWrapper : "");
            sResult = (String)sResult + aObject[iPos];
            sResult = (String)sResult + (sWrapper != null ? sWrapper : "");
        }
        return sResult;
    }

    public static String toJavaIdentifier(String aString) {
        String identifier = StringUtil.toAttributeJavaIdentifier(aString);
        return Character.toUpperCase(identifier.charAt(0)) + identifier.substring(1);
    }

    public static String toAttributeJavaIdentifier(String aString) {
        StringBuffer res = new StringBuffer();
        int idx = 0;
        boolean toUpper = false;
        while (idx < aString.length()) {
            char c;
            if (Character.isJavaIdentifierPart(c = aString.charAt(idx++))) {
                if (toUpper) {
                    c = Character.toUpperCase(c);
                    toUpper = false;
                }
                res.append(c);
                continue;
            }
            toUpper = true;
        }
        return res.toString();
    }

    public static class DummyValue {
        private String sValue;

        public DummyValue(String sValue) {
            this.sValue = sValue;
        }

        public String getValue() {
            return this.sValue;
        }
    }
}

