/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.definition.NodeRenderer;
import io.intino.goros.modernizing.monet.renderers.templates.java.ContainerTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.util.ArrayList;
import org.monet.metamodel.ContainerDefinition;
import org.monet.metamodel.ContainerDefinitionBase;
import org.monet.metamodel.Definition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.TaskDefinition;
import org.monet.metamodel.internal.Ref;

public class ContainerRenderer
extends NodeRenderer<ContainerDefinition> {
    public ContainerRenderer(Dictionary dictionary, Modernization modernization, ContainerDefinition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    protected FrameBuilder viewFrame(NodeViewProperty viewProperty) {
        FrameBuilder result = this.baseViewFrame(viewProperty);
        this.addContain((ContainerDefinitionBase.ViewProperty)viewProperty, result);
        this.addShow((ContainerDefinitionBase.ViewProperty)viewProperty, result);
        return result;
    }

    @Override
    protected boolean isVisibleOnRevision(NodeViewProperty viewProperty) {
        ContainerDefinitionBase.ViewProperty.ShowProperty showProperty = ((ContainerDefinitionBase.ViewProperty)viewProperty).getShow();
        return showProperty.getComponent().size() > 0;
    }

    @Override
    protected boolean hasTemplate(NodeViewProperty viewProperty) {
        ContainerDefinitionBase.ViewProperty.ShowProperty showProperty = ((ContainerDefinitionBase.ViewProperty)viewProperty).getShow();
        if (showProperty.getRecentTask() != null) {
            return true;
        }
        if (showProperty.getRevisions() != null) {
            return true;
        }
        return showProperty.getComponent().size() > 0;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.monet.renderers.templates.konos.ContainerTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new ContainerTemplate();
    }

    private void addContain(ContainerDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        ContainerDefinitionBase.ViewProperty.ShowProperty showProperty = viewProperty.getShow();
        if (showProperty.getComponent().size() <= 0) {
            return;
        }
        NodeDefinition containDefinition = this.dictionary.getNodeDefinition(showProperty.getComponent().get(0).getDefinition());
        FrameBuilder result = this.baseFrame().add("contain");
        result.add("name", this.nameOf(viewProperty));
        result.add("contain", containDefinition.getCode());
        result.add("containName", this.nameOf(containDefinition));
        builder.add("contain", result);
    }

    private void addShow(ContainerDefinitionBase.ViewProperty viewProperty, FrameBuilder builder) {
        ContainerDefinitionBase.ViewProperty.ShowProperty showProperty = viewProperty.getShow();
        FrameBuilder result = this.baseFrame().add("show");
        result.add(((ContainerDefinition)this.definition()).getType().name().toLowerCase());
        result.add(this.typeOf(showProperty));
        result.add("view", this.nameOf(viewProperty));
        result.add("definition", this.nameOf((Definition)this.definition()));
        if (showProperty.getRecentTask() != null) {
            this.addRecentTaskShow(viewProperty, showProperty, result);
        } else if (showProperty.getComponent().size() > 0) {
            this.addComponentShow(viewProperty, showProperty, result);
        }
        builder.add("show", result);
    }

    private void addRecentTaskShow(ContainerDefinitionBase.ViewProperty viewProperty, ContainerDefinitionBase.ViewProperty.ShowProperty showProperty, FrameBuilder builder) {
        this.findTaskDefinitionsWith((Definition)this.definition()).forEach(d -> this.addRecentTaskType((TaskDefinition)d, builder));
    }

    private void addComponentShow(ContainerDefinitionBase.ViewProperty viewProperty, ContainerDefinitionBase.ViewProperty.ShowProperty showProperty, FrameBuilder builder) {
        ArrayList<Ref> componentList = showProperty.getComponent();
        componentList.forEach(ref -> {
            NodeDefinition definition = this.dictionary.getNodeDefinition(ref.getDefinition());
            NodeViewProperty view = definition.getNodeView(ref.getValue());
            this.addComponent(definition, view, builder);
        });
    }

    private void addComponent(NodeDefinition definition, NodeViewProperty viewProperty, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("component");
        if (definition.getType() != null) {
            result.add(definition.getType().name());
        }
        result.add("name", this.nameOf(definition));
        result.add("view", this.nameOf(viewProperty));
        result.add("viewCode", viewProperty.getCode());
        builder.add("component", result);
    }
}

