/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.definition.SetRenderer;
import io.intino.itrules.FrameBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.monet.metamodel.CollectionDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.internal.Ref;

public class CollectionRenderer
extends SetRenderer<CollectionDefinition> {
    public CollectionRenderer(Dictionary dictionary, Modernization modernization, CollectionDefinition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    protected FrameBuilder toolbarFrame() {
        FrameBuilder result = super.toolbarFrame();
        this.addRefAddList(result);
        return result;
    }

    private void addRefAddList(FrameBuilder builder) {
        FrameBuilder result = new FrameBuilder("addList");
        Collection<Ref> addList = ((CollectionDefinition)this.definition()).getAdd().getNode().stream().collect(Collectors.toMap(Ref::getValue, a -> a, (a1, a2) -> a1)).values();
        if (addList.size() > 0) {
            result.add("defaultAdd", this.addFrame(this.dictionary.getNodeDefinition(addList.iterator().next().getValue())));
        }
        result.add("addVisibility", this.addVisibilityFrame(addList.size() == 1));
        result.add("addSplitVisibility", this.addVisibilityFrame(addList.size() > 1));
        addList.forEach(ref -> {
            this.addRefAdd((Ref)ref, result);
            this.addRefAdd((Ref)ref, builder);
        });
        builder.add("addList", result);
    }

    private FrameBuilder addVisibilityFrame(boolean visible) {
        FrameBuilder result = this.baseFrame().add("addVisibility");
        if (visible) {
            result.add("visible");
        }
        return result;
    }

    private void addRefAdd(Ref ref, FrameBuilder builder) {
        ArrayList<NodeDefinition> nodeDefinitionList = this.dictionary.getAllImplementersOfNodeDefinition(ref.getValue());
        nodeDefinitionList.stream().forEach(def -> builder.add("add", this.addFrame((NodeDefinition)def)));
    }

    private FrameBuilder addFrame(NodeDefinition nodeDefinition) {
        FrameBuilder result = this.baseFrame().add("add");
        result.add("name", this.nameOf(nodeDefinition));
        result.add("code", nodeDefinition.getCode());
        result.add("label", this.clean(nodeDefinition.getLabel()));
        return result;
    }
}

