/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.Renderer;
import io.intino.goros.modernizing.monet.renderers.templates.konos.UITemplate;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.util.List;
import org.monet.metamodel.Definition;
import org.monet.metamodel.DesktopDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.SourceDefinition;

public class UIRenderer
extends Renderer {
    private final List<Definition> definitionList;

    public UIRenderer(Dictionary dictionary, Modernization modernization, List<Definition> definitionList) {
        super(dictionary, modernization);
        this.definitionList = definitionList;
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        this.writeAppTemplate();
        this.writeRouteDispatcherTemplate();
        this.writeHeaderTemplate();
        this.writeFrame(this.file(), new UITemplate().render(builder.toFrame()));
    }

    private FrameBuilder buildFrame() {
        FrameBuilder result = this.baseFrame();
        result.add("ui");
        Definition desktopDefinition = this.definitionList.stream().filter(d -> d instanceof DesktopDefinition).findFirst().orElse(null);
        if (desktopDefinition != null) {
            result.add("defaultDesktop", this.nameOf(desktopDefinition));
        }
        this.addRootDefinitions(result);
        return result;
    }

    private void addRootDefinitions(FrameBuilder builder) {
        this.definitionList.forEach(d -> builder.add("definition", this.definitionFrame((Definition)d)));
    }

    private FrameBuilder definitionFrame(Definition definition) {
        FrameBuilder result = this.baseFrame().add("definition");
        result.add(definition.getType().name().toLowerCase());
        if (definition instanceof SourceDefinition) {
            result.add("source");
        }
        if (definition instanceof NodeDefinition && ((NodeDefinition)definition).isSingleton()) {
            result.add("singleton");
        }
        if (definition instanceof NodeDefinition && ((NodeDefinition)definition).isComponent()) {
            result.add("component");
        }
        if (definition instanceof ProcessDefinition) {
            result.add("process");
        }
        result.add("name", this.nameOf(definition));
        result.add("code", definition.getCode());
        result.add("label", this.clean(definition.getLabel()));
        this.addResourceType(definition, result);
        this.addSourceDesktop(definition, result);
        return result;
    }

    private void addSourceDesktop(Definition definition, FrameBuilder builder) {
        DesktopDefinition desktopDefinition = this.desktopWithDefinition(definition);
        if (desktopDefinition == null) {
            return;
        }
        builder.add("sourceDesktop", this.desktopFrame(definition, desktopDefinition));
    }

    private FrameBuilder desktopFrame(Definition definition, DesktopDefinition desktopDefinition) {
        FrameBuilder result = new FrameBuilder("sourceDesktop");
        result.add("name", this.nameOf(definition));
        result.add("desktop", this.nameOf(desktopDefinition));
        result.add("desktopLabel", desktopDefinition.getLabel());
        return result;
    }

    private File file() {
        return new File(this.modernization.sourceUiDirectory() + File.separator + "UI.konos");
    }

    private void writeAppTemplate() {
        FrameBuilder builder = this.buildFrame().add("app");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "AppTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeRouteDispatcherTemplate() {
        FrameBuilder builder = this.buildFrame().add("routedispatcher");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "RouteDispatcher.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }

    private void writeHeaderTemplate() {
        FrameBuilder builder = this.buildFrame().add("header");
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "displays" + File.separator + "templates" + File.separator + "HeaderTemplate.java");
        this.writeFrame(file, new io.intino.goros.modernizing.monet.renderers.templates.java.UITemplate().render(builder.toFrame()));
    }
}

