/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.ActivityRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.CatalogRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.CollectionRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.ContainerRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.DefaultDefinitionRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.DesktopRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.DocumentRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.FormRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.IndexRenderer;
import io.intino.goros.modernizing.monet.renderers.definition.ServiceRenderer;
import java.util.HashMap;
import java.util.Map;
import org.monet.metamodel.ActivityDefinition;
import org.monet.metamodel.CatalogDefinition;
import org.monet.metamodel.CollectionDefinition;
import org.monet.metamodel.ContainerDefinition;
import org.monet.metamodel.Definition;
import org.monet.metamodel.DesktopDefinition;
import org.monet.metamodel.DocumentDefinition;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.ServiceDefinition;
import org.monet.space.kernel.model.DefinitionType;

public class DefinitionRendererFactory {
    private static Map<DefinitionType, DefinitionRendererBuilder<? extends DefinitionRenderer<?>>> renderers = new HashMap();

    public DefinitionRenderer renderer(Dictionary dictionary, Modernization modernization, Definition definition) {
        if (definition.getType() == null) {
            return null;
        }
        return renderers.getOrDefault((Object)definition.getType(), DefaultDefinitionRenderer::new).build(dictionary, modernization, definition);
    }

    static {
        renderers.put(DefinitionType.activity, (dictionary, modernization, definition) -> new ActivityRenderer(dictionary, modernization, (ActivityDefinition)definition));
        renderers.put(DefinitionType.service, (dictionary, modernization, definition) -> new ServiceRenderer(dictionary, modernization, (ServiceDefinition)definition));
        renderers.put(DefinitionType.form, (dictionary, modernization, definition) -> new FormRenderer(dictionary, modernization, (FormDefinition)definition));
        renderers.put(DefinitionType.container, (dictionary, modernization, definition) -> new ContainerRenderer(dictionary, modernization, (ContainerDefinition)definition));
        renderers.put(DefinitionType.collection, (dictionary, modernization, definition) -> new CollectionRenderer(dictionary, modernization, (CollectionDefinition)definition));
        renderers.put(DefinitionType.catalog, (dictionary, modernization, definition) -> new CatalogRenderer(dictionary, modernization, (CatalogDefinition)definition));
        renderers.put(DefinitionType.index, (dictionary, modernization, definition) -> new IndexRenderer(dictionary, modernization, (IndexDefinition)definition));
        renderers.put(DefinitionType.document, (dictionary, modernization, definition) -> new DocumentRenderer(dictionary, modernization, (DocumentDefinition)definition));
        renderers.put(DefinitionType.desktop, (dictionary, modernization, definition) -> new DesktopRenderer(dictionary, modernization, (DesktopDefinition)definition));
    }

    private static interface DefinitionRendererBuilder<R extends DefinitionRenderer<?>> {
        public R build(Dictionary var1, Modernization var2, Definition var3);
    }
}

