/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.ArtifactRenderer;
import io.intino.goros.modernizing.monet.renderers.BoxRenderer;
import io.intino.goros.modernizing.monet.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.monet.renderers.MainRenderer;
import io.intino.goros.modernizing.monet.renderers.TasksRenderer;
import io.intino.goros.modernizing.monet.renderers.ThemeRenderer;
import io.intino.goros.modernizing.monet.renderers.TranslationsRenderer;
import io.intino.goros.modernizing.monet.renderers.UIRenderer;
import io.intino.goros.modernizing.monet.util.FileUtil;
import io.intino.goros.modernizing.monet.util.ZipUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.monet.metamodel.Definition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.SourceDefinition;
import org.monet.metamodel.internal.TaskOrderDefinition;

public class MonetModernizer {
    private final Modernization modernization;
    private Dictionary dictionary;
    private DefinitionRendererFactory factory = new DefinitionRendererFactory();

    public MonetModernizer(Modernization modernization) {
        this.modernization = modernization;
    }

    public void compile() {
        this.loadDictionary();
        this.createProjectSkeleton();
        this.compileDefinitions();
    }

    private void createProjectSkeleton() {
        Logger.info("Creating project skeleton");
        File projectDir = this.modernization.projectDirectory();
        if (projectDir.exists()) {
            Logger.info("Project skeleton already created");
            return;
        }
        projectDir.mkdirs();
        ZipUtil.decompress(MonetModernizer.class.getResourceAsStream("/skeleton.zip"), projectDir.getAbsolutePath());
        Logger.info("Project skeleton created");
    }

    private void compileDefinitions() {
        Logger.info("Compiling definitions");
        new ArtifactRenderer(this.dictionary, this.modernization).write();
        new MainRenderer(this.dictionary, this.modernization).write();
        new BoxRenderer(this.dictionary, this.modernization).write();
        new UIRenderer(this.dictionary, this.modernization, this.definitions().collect(Collectors.toList())).write();
        new ThemeRenderer(this.dictionary, this.modernization).write();
        new TranslationsRenderer(this.dictionary, this.modernization).write();
        new TasksRenderer(this.dictionary, this.modernization).write();
        this.definitions().filter(d -> !(d instanceof SourceDefinition)).forEach(this::compileDefinition);
        Logger.info("Definitions compiled");
    }

    private void compileDefinition(Definition definition) {
        if (definition.getType() == null) {
            return;
        }
        this.factory.renderer(this.dictionary, this.modernization, definition).write();
    }

    private void loadDictionary() {
        Logger.info("Loading dictionary from " + this.modernization.businessModel().getAbsolutePath());
        this.loadDictionaryLibraries();
        this.loadDictionaryDefinitions();
        Logger.info("Dictionary loaded. Definitions count: " + this.dictionary.getAllDefinitions().size());
    }

    private void loadDictionaryLibraries() {
        String businessModelDir = this.modernization.businessModel().getAbsolutePath();
        String librariesDir = businessModelDir + File.separator + "libs";
        String[] libraries = FileUtil.listDir(librariesDir);
        String librariesClassesDir = businessModelDir + File.separator + "classes_libraries";
        if (libraries == null || new File(librariesClassesDir).exists()) {
            return;
        }
        Arrays.stream(libraries).forEach(library -> {
            String libraryPath = librariesDir + "/" + library;
            File libraryFile = new File(libraryPath);
            try {
                ZipUtil.decompress(libraryFile, librariesClassesDir);
            }
            catch (Exception exception) {
                Logger.error("Can't add model library error.");
            }
        });
    }

    private void loadDictionaryDefinitions() {
        this.dictionary = new Dictionary();
        org.monet.metamodel.Dictionary.injectCurrentInstance(this.dictionary);
        this.dictionary.initialize(this.modernization.businessModel().getAbsolutePath());
    }

    private Stream<Definition> definitions() {
        return this.dictionary.getAllDefinitions().stream().filter(d -> this.isRoot((Definition)d) && !this.excluded((Definition)d));
    }

    private boolean isRoot(Definition definition) {
        if (definition instanceof TaskOrderDefinition) {
            return false;
        }
        if (definition instanceof NodeDefinition) {
            return true;
        }
        if (definition instanceof ProcessDefinition) {
            return true;
        }
        if (definition instanceof SourceDefinition) {
            return true;
        }
        return definition instanceof IndexDefinition;
    }

    private boolean excluded(Definition definition) {
        List<String> excludedList = this.modernization.excludedDefinitions();
        return excludedList.contains(definition.getName()) || excludedList.contains(definition.getCode());
    }
}

