/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.serializer;

import io.intino.goros.egeasy.m3.entity.TGVariant;
import io.intino.goros.egeasy.m3.library.LibraryStream;
import io.intino.goros.egeasy.m3.serializer.SerializedStream;
import io.intino.goros.egeasy.m3.serializer.SerializerStatus;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import java.io.IOException;
import java.time.ZonedDateTime;

public class SerializedInputStream
extends SerializedStream {
    private FastByteArrayInputStream stream;
    private Long fieldInitPos = -1L;
    private Long fieldSize = -1L;

    public SerializedInputStream(byte[] data) {
        this.stream = new FastByteArrayInputStream(data);
        this.streamSize = this.stream.length();
    }

    @Override
    public long getPosition() {
        return this.stream.position();
    }

    @Override
    public void setPosition(Long value) {
        this.stream.position(value);
    }

    @Override
    public void close() throws IOException {
        this.popPosition();
        this.getStackStatus().pop();
        this.stream.close();
    }

    public void openRead(long size) throws IOException, SerializedStream.ESerializedStreamException {
        if (size >= 0L) {
            this.streamSize = size;
        }
        if (this.streamSize <= 0L) {
            return;
        }
        this.pushPosition();
        SerializerStatus serializerStatus = new SerializerStatus();
        this.getStackStatus().push(serializerStatus);
        long posInit = this.getPosition();
        byte mark = LibraryStream.readByte(this.stream);
        if (mark != -6) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer la marca de comienzo.");
        }
        int fieldCount = LibraryStream.readInt(this.stream);
        serializerStatus.setFieldCount(fieldCount);
        long posBeginFields = this.getPosition();
        block7: while (this.streamSize > this.getPosition() - posInit && fieldCount != serializerStatus.getFieldNames().size()) {
            SerializedStream.FieldHeader fieldHeader = this.readFieldHeader();
            long posField = this.getPosition();
            serializerStatus.addField(fieldHeader.name, posField, fieldHeader.type);
            switch (fieldHeader.type) {
                case 2: {
                    this.preloadFieldVariant();
                    continue block7;
                }
                case 3: {
                    this.preloadFieldStream();
                    continue block7;
                }
                case 4: {
                    this.preloadFieldRegister();
                    continue block7;
                }
                case 5: {
                    this.preloadFieldVariantArray();
                    continue block7;
                }
                case 6: {
                    this.preloadFieldStreamArray();
                    continue block7;
                }
            }
        }
        if (fieldCount != serializerStatus.getFieldNames().size()) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. N\u00famero de campos incompleto.");
        }
        this.setPosition(posBeginFields);
    }

    private SerializedStream.FieldHeader readFieldHeader() throws IOException {
        String name = LibraryStream.readString(this.stream, false);
        int type = LibraryStream.readInt(this.stream);
        return new SerializedStream.FieldHeader(name, type);
    }

    private void preloadFieldVariant() throws IOException {
        LibraryStream.skipVariant(this.stream);
    }

    private void preloadFieldStream() throws IOException {
        LibraryStream.skipStreamEx(this.stream);
    }

    private void preloadFieldRegister() throws IOException {
        int count = LibraryStream.readInt(this.stream);
        for (int i = 0; i < count; ++i) {
            LibraryStream.skipVariant(this.stream);
        }
    }

    private void preloadFieldVariantArray() throws IOException {
        int count = LibraryStream.readInt(this.stream);
        for (int i = 0; i < count; ++i) {
            LibraryStream.skipVariant(this.stream);
        }
    }

    private void preloadFieldStreamArray() throws IOException {
        int count = LibraryStream.readInt(this.stream);
        for (int i = 0; i < count; ++i) {
            LibraryStream.skipStreamEx(this.stream);
        }
    }

    public boolean hasField(String name) {
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        return serializerStatus.indexOfField(name) >= 0;
    }

    public TGVariant readFieldVariant(String name) throws SerializedStream.ESerializedStreamException {
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        int idxField = serializerStatus.indexOfField(name);
        if (idxField < 0) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no existe.");
        }
        int fieldType = serializerStatus.getFieldTypes().get(idxField);
        if (2 != fieldType) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no es de tipo FIELD_VARIANT.");
        }
        this.setPosition(serializerStatus.getFieldPositions().get(idxField));
        try {
            return this.loadVariantValue();
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo FIELD_VARIANT.", e);
        }
    }

    public int readFieldStream(String name) throws SerializedStream.ESerializedStreamException {
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        int idxField = serializerStatus.indexOfField(name);
        if (idxField < 0) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no existe.");
        }
        int fieldType = serializerStatus.getFieldTypes().get(idxField);
        if (3 != fieldType) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no es de tipo FIELD_STREAM.");
        }
        this.setPosition(serializerStatus.getFieldPositions().get(idxField));
        try {
            this.fieldSize = this.loadStreamValue();
            this.fieldInitPos = this.stream.position();
            return this.fieldSize.intValue();
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo FIELD_STREAM.", e);
        }
    }

    public int readFieldRegister(String name) throws SerializedStream.ESerializedStreamException {
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        int idxField = serializerStatus.indexOfField(name);
        if (idxField < 0) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no existe.");
        }
        int fieldType = serializerStatus.getFieldTypes().get(idxField);
        if (4 != fieldType) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no es de tipo FIELD_REGISTER.");
        }
        this.setPosition(serializerStatus.getFieldPositions().get(idxField));
        try {
            this.fieldSize = this.loadRegisterValue();
            this.fieldInitPos = this.stream.position();
            return this.fieldSize.intValue();
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo FIELD_REGISTER.", e);
        }
    }

    public TGVariant[] readFieldArray(String name) throws SerializedStream.ESerializedStreamException {
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        int idxField = serializerStatus.indexOfField(name);
        if (idxField < 0) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no existe.");
        }
        int fieldType = serializerStatus.getFieldTypes().get(idxField);
        if (5 != fieldType) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no es de tipo FIELD_ARRAY.");
        }
        this.setPosition(serializerStatus.getFieldPositions().get(idxField));
        try {
            return this.loadArrayValue();
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo FIELD_ARRAY.", e);
        }
    }

    public int readFieldStreamArray(String name) throws SerializedStream.ESerializedStreamException {
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        int idxField = serializerStatus.indexOfField(name);
        if (idxField < 0) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no existe.");
        }
        int fieldType = serializerStatus.getFieldTypes().get(idxField);
        if (6 != fieldType) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no es de tipo FIELD_STREAM_ARRAY.");
        }
        this.setPosition(serializerStatus.getFieldPositions().get(idxField));
        try {
            int itemCount = this.loadStreamArrayValue();
            return itemCount;
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo FIELD_STREAM_ARRAY.", e);
        }
    }

    private TGVariant loadVariantValue() throws IOException {
        return LibraryStream.readVariant(this.stream);
    }

    private int loadStreamValue() throws IOException {
        return LibraryStream.readInt(this.stream);
    }

    private int loadRegisterValue() throws IOException {
        return LibraryStream.readInt(this.stream);
    }

    private TGVariant[] loadArrayValue() throws IOException {
        int size = LibraryStream.readInt(this.stream);
        TGVariant[] result = new TGVariant[size];
        for (int i = 0; i < size; ++i) {
            result[i] = LibraryStream.readVariant(this.stream);
        }
        return result;
    }

    private int loadStreamArrayValue() throws IOException {
        return LibraryStream.readInt(this.stream);
    }

    public int readStream(String name, int index) throws SerializedStream.ESerializedStreamException {
        int itemsCount;
        SerializerStatus serializerStatus = this.getStackStatus().peek();
        int idxField = serializerStatus.indexOfField(name);
        if (idxField < 0) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no existe.");
        }
        int fieldType = serializerStatus.getFieldTypes().get(idxField);
        if (fieldType != 6) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El campo " + name + " no es de tipo STREAM_ARRAY.");
        }
        this.setPosition(serializerStatus.getFieldPositions().get(idxField));
        try {
            itemsCount = LibraryStream.readInt(this.stream);
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo.", e);
        }
        if (index >= itemsCount) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. El indice buscado en el campo " + name + " est\u00e1 fuera de l\u00edmites.");
        }
        for (int i = 0; i < index; ++i) {
            try {
                LibraryStream.skipStreamEx(this.stream);
                continue;
            }
            catch (IOException e) {
                throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo.", e);
            }
        }
        try {
            this.fieldSize = LibraryStream.readInt(this.stream);
            this.fieldInitPos = this.stream.position();
            return this.fieldSize.intValue();
        }
        catch (IOException e) {
            throw new SerializedStream.ESerializedStreamException("Error de lectura. Error al leer el campo.", e);
        }
    }

    private boolean inBoundary() {
        if (this.fieldSize >= 0L) {
            return this.stream.position() - this.fieldInitPos < this.fieldSize;
        }
        return this.stream.position() < this.streamSize;
    }

    public boolean readBoolean() throws IOException {
        if (!this.inBoundary()) {
            return false;
        }
        return LibraryStream.readBoolean(this.stream);
    }

    public int readInt() throws IOException {
        if (!this.inBoundary()) {
            return 0;
        }
        return LibraryStream.readInt(this.stream);
    }

    public String readString(boolean wide) throws IOException {
        if (!this.inBoundary()) {
            return null;
        }
        return LibraryStream.readString(this.stream, wide);
    }

    public ZonedDateTime readDateTime() throws IOException {
        if (!this.inBoundary()) {
            return null;
        }
        return LibraryStream.readDateTime(this.stream);
    }

    public TGVariant readVariant() throws IOException {
        if (!this.inBoundary()) {
            return new TGVariant();
        }
        return LibraryStream.readVariant(this.stream);
    }

    public void skipStream(int size) throws IOException {
        if (!this.inBoundary()) {
            return;
        }
        LibraryStream.skipStream(this.stream, size);
    }
}

