/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.egeasy.renderers.definition.EntitySetItemRenderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.konos.FormWithFieldsTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SectionRenderer
extends EntitySetItemRenderer<Definition> {
    private DefinitionRendererFactory factory = new DefinitionRendererFactory();

    public SectionRenderer(TreeNodeResource dictionary, Modernization modernization, Definition definition) {
        super(dictionary, modernization, definition);
        DefinitionSet.add(definition.getDRC());
    }

    @Override
    public FrameBuilder buildFrame() throws Exception {
        FrameBuilder result = this.baseDefinitionFrame();
        result.add("content", this.contentFrame());
        return result;
    }

    public boolean isFirstSection() {
        List<Definition> definitions = this.parentSections();
        if (definitions.isEmpty()) {
            return false;
        }
        return definitions.get(0) == this.definition();
    }

    public List<Definition> parentSections() {
        if (this.parent() == null) {
            return Collections.emptyList();
        }
        List<Definition> definitions = DefinitionUtils.sortedUiComponentDefinitions(this.parent());
        int sectionType = Metamodel.getInstance().DTSection.getTypeValue();
        return definitions.stream().filter(d -> d.getTypeValue() == sectionType).collect(Collectors.toList());
    }

    @Override
    protected Template konosTemplate() {
        return new FormWithFieldsTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new io.intino.goros.modernizing.egeasy.renderers.templates.java.FormWithFieldsTemplate();
    }

    private FrameBuilder contentFrame() throws Exception {
        FrameBuilder result = this.baseFrame().add("content").add("section");
        Object definition = this.definition();
        result.add("parent", this.parent() != null ? this.nameOf(this.parent()) : null);
        result.add("name", this.nameOf((Definition)definition));
        result.add("label", this.labelOf((Definition)definition));
        result.add("drc", ((Definition)definition).getDRC());
        for (Definition childDefinition : DefinitionUtils.sortedUiComponentDefinitions(((Definition)definition).getDefinitions())) {
            Object renderer = ((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, childDefinition).root(this.root())).parent(this.parent());
            result.add("field", ((DefinitionRenderer)renderer).context(this.nameOf(this.parent())).buildFrame());
            if (childDefinition.getTypeValue() != Metamodel.getInstance().DTTable.getTypeValue()) continue;
            ((DefinitionRenderer)renderer).write();
        }
        result.add("show", this.showFrame());
        return result;
    }

    private FrameBuilder showFrame() {
        FrameBuilder result = new FrameBuilder("show");
        if (this.isFirstSection()) {
            result.add("opened");
        }
        result.add("name", this.nameOf((Definition)this.definition()));
        result.add("parent", this.parent() != null ? this.nameOf(this.parent()) : null);
        result.add("drc", ((Definition)this.definition()).getDRC());
        return result;
    }
}

