/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.producer;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.ListDefInstances;
import io.intino.goros.egeasy.m3.entity.TGEntity;
import io.intino.goros.egeasy.m3.entity.TGListComponents;
import io.intino.goros.egeasy.m3.entity.component.TGComponent;
import io.intino.goros.egeasy.m3.entity.component.TGForm;
import io.intino.goros.egeasy.m3.entity.component.TGSection;
import io.intino.goros.egeasy.m3.entity.field.TGFieldTable;
import io.intino.goros.egeasy.m3.entity.resource.TGResource;
import io.intino.goros.egeasy.m3.producer.FactoryEntity;

public class ProducerEntity {
    private static ProducerEntity instance = null;

    private ProducerEntity() {
    }

    public static synchronized ProducerEntity getInstance() {
        if (instance == null) {
            instance = new ProducerEntity();
        }
        return instance;
    }

    public TGEntity createEntity(Definition definition) {
        return this.doCreateEntity(definition);
    }

    public TGListComponents addRow(TGFieldTable fieldTable) {
        TGListComponents row = new TGListComponents();
        ListDefInstances defFields = fieldTable.getDefinition().getDefinitions();
        for (int i = 0; i < defFields.size(); ++i) {
            TGEntity item = this.doCreateEntity((Definition)defFields.get(i));
            if (item == null || !(item instanceof TGComponent)) continue;
            item.setDomain(fieldTable);
            row.getAComponents().add((TGComponent)item);
        }
        fieldTable.getARows().add(row);
        return row;
    }

    private TGEntity doCreateEntity(Definition definition) {
        if (definition == null) {
            return null;
        }
        TGEntity result = FactoryEntity.getInstance().createEntity(definition);
        if (result == null) {
            return null;
        }
        if (result instanceof TGResource) {
            this.createComponents(definition.getDefinitions(), ((TGResource)result).getComponents(), result);
        }
        if (result instanceof TGForm || result instanceof TGSection) {
            this.createComponents(definition.getDefinitions(), ((TGComponent)result).getComponents(), result);
        }
        return result;
    }

    private void createComponents(ListDefInstances definitions, TGListComponents components, TGEntity domain) {
        for (int i = 0; i < definitions.size(); ++i) {
            TGEntity entityComponent = this.doCreateEntity((Definition)definitions.get(i));
            if (entityComponent == null || !(entityComponent instanceof TGComponent)) continue;
            components.getAComponents().add((TGComponent)entityComponent);
            entityComponent.setDomain(domain);
        }
    }
}

