/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.model.CodeDescriptorRoomLocation;
import io.intino.goros.modernizing.egeasy.model.Constants;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import io.intino.itrules.FrameBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RendererHelper {
    private static final Integer MinNameSuffixSize = 10;
    private static final Map<String, String> definitionNamesMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Integer> assignedNamesMap = Collections.synchronizedMap(new HashMap());
    private static final Set<Character> Numbers = Set.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));

    public static FrameBuilder addSectionsTo(FrameBuilder frameBuilder, Definition definition, Map<String, String> roomCodes) {
        LinkedHashMap<String, List> sectionMap = new LinkedHashMap<String, List>();
        RendererHelper.locations(definition).stream().filter(Definition::isVisible).forEach(location -> RendererHelper.registerIn(sectionMap, location));
        ((HashMap)sectionMap).forEach((key, value) -> frameBuilder.add("section", RendererHelper.sectionFrameOf(key, value, roomCodes)));
        return frameBuilder;
    }

    public static String nameOf(Definition definition, Map<String, String> roomCodes) {
        if (DefinitionUtils.isRoomDefinition(definition).booleanValue()) {
            return RendererHelper.codeOf(definition, roomCodes);
        }
        return RendererHelper.nameOf(definition.getDRC(), definition.getName());
    }

    private static String codeOf(Definition definition, Map<String, String> roomCodes) {
        String name = definition.getName();
        return roomCodes.containsKey(name) ? roomCodes.get(name) : RendererHelper.nameOf(definition.getDRC(), name);
    }

    private static String nameOf(int DRC, String definition) {
        String key = DRC + definition;
        if (definitionNamesMap.containsKey(key)) {
            return definitionNamesMap.get(key);
        }
        Object name = RendererHelper.normalize(definition);
        Object object = name = ((String)name).contains(".") ? ((String)name).substring(((String)name).lastIndexOf(".") + 1) : name;
        if (((String)name).length() > MinNameSuffixSize) {
            name = RendererHelper.shortName(((String)name).substring(0, MinNameSuffixSize)) + ((String)name).substring(((String)name).length() - MinNameSuffixSize / 2);
        }
        if (!assignedNamesMap.containsKey(name)) {
            assignedNamesMap.put((String)name, 0);
        }
        Object result = name;
        if (assignedNamesMap.get(name) > 0) {
            result = (String)result + String.valueOf(assignedNamesMap.get(name));
        }
        assignedNamesMap.put((String)name, assignedNamesMap.get(name) + 1);
        definitionNamesMap.put(key, (String)result);
        return result;
    }

    private static String highlights(String value) {
        StringBuilder result = new StringBuilder();
        int offset = value.length() > 4 ? 4 : 0;
        for (int i = 0; i < value.length() - offset; ++i) {
            if (i % 2 != 0) continue;
            result.append(value.charAt(i));
        }
        return String.valueOf(result) + (offset > 0 ? value.substring(value.length() - offset) : "");
    }

    public static String shortNameOf(Definition definition, Map<String, String> roomCodes) {
        return RendererHelper.shortName(RendererHelper.nameOf(definition, roomCodes));
    }

    public static String shortNameOf(String name) {
        return RendererHelper.shortName(name);
    }

    public static String snakeCaseToCamelCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        Object result = "";
        for (String part : string.replace("_", "-").split("-")) {
            result = (String)result + String.valueOf(Character.toUpperCase(part.charAt(0))) + part.substring(1);
        }
        return result;
    }

    public static String shortName(String snakeName) {
        return Arrays.stream(snakeName.split("-")).map(RendererHelper::initials).collect(Collectors.joining("-"));
    }

    public static String initials(String name) {
        String initials = name.replaceAll("[a-z]", "");
        if (!initials.isEmpty()) {
            return initials;
        }
        return name.length() > 2 ? name.substring(0, 3) : name;
    }

    public static String labelOf(String label, String name) {
        return label != null && !label.isEmpty() ? label : name;
    }

    public static String normalize(String name) {
        if (name == null || ((String)name).isEmpty()) {
            return "";
        }
        if (((String)(name = ((String)name).replace(" ", "").replace(":", "").replace("|", "").replace("?", "").replace("\u00bf", "").replace(".", "").replace("*", "").replace("/", "-").replace(" ", "-").replace("_", "-").replace("--", "-").replace(",", "").replace(";", "").replace("\u00ba", "").replace("\u00aa", "").replace("\u00ab", "").replace("\u00bb", "").replace("\u00ac", "").replace("@", "").replace("#", "").replace("+", "").replace("=", "").replace("\\", "").replace("%", "").replace("\u20ac", "").replace("$", "").replace("(", "").replace(")", "").replace("!", "").replace("\u00a1", "").replace("\u00b7", "").replace("-", "").replace("^", "").replace("~", "").replace("<", "").replace(">", "").replace("&", "").replace("\"", "").replace("'", "").replace("{", "").replace("}", "").replace("\u2013", ""))).isEmpty()) {
            name = "a";
        }
        if (RendererHelper.isNumber(((String)name).charAt(0))) {
            name = "a" + (String)name;
        }
        return StringUtil.stripAccents(StringUtil.firstUpperCase(StringUtil.snakeCaseToCamelCase((String)name)));
    }

    private static boolean isNumber(char charAt) {
        return Numbers.contains(Character.valueOf(charAt));
    }

    public static List<Definition> locations(Definition definition) {
        return definition.getDefinitions().stream().filter(RendererHelper::isLocation).collect(Collectors.toList());
    }

    private static boolean isLocation(Definition definition) {
        return definition.getExtension() instanceof DefinitionExtensionLocation;
    }

    public static String placeOf(Definition definition) {
        return DefinitionUtils.getDefinitionAttributeValue(definition, "LUGAR");
    }

    public static String iconOf(List<Definition> locationList) {
        if (locationList == null) {
            return "Default";
        }
        for (Definition def : locationList) {
            String icon;
            Definition defLocated;
            String defLocatedName = def.getName();
            if (defLocatedName.startsWith(Constants.DEFINITION_LOCATION_LOCATION)) {
                defLocatedName = defLocatedName.substring(Constants.DEFINITION_LOCATION_LOCATION.length());
            }
            if ((defLocated = LibraryDefinitions.findDefinition(defLocatedName, Dictionary.getInstance().getDefinitions())) == null || (icon = (String)defLocated.getAttributes().findAttribute("ICONO").stream().findFirst().orElse(null)) == null || icon.isEmpty()) continue;
            return icon;
        }
        return "Default";
    }

    private static FrameBuilder sectionFrameOf(String section, List<Definition> locationList, Map<String, String> roomCodes) {
        FrameBuilder result = new FrameBuilder("section");
        result.add("name", section);
        result.add("icon", RendererHelper.iconFrame(locationList));
        locationList.forEach(l -> result.add("location", RendererHelper.locationFrameOf(l, roomCodes)));
        return result;
    }

    private static FrameBuilder iconFrame(List<Definition> locationList) {
        FrameBuilder result = new FrameBuilder("icon");
        String icon = RendererHelper.iconOf(locationList);
        if (!icon.equals("Default")) {
            result.add("external");
        }
        result.add("icon", icon);
        return result;
    }

    private static FrameBuilder locationFrameOf(Definition location, Map<String, String> roomCodes) {
        FrameBuilder result = new FrameBuilder("location");
        CodeDescriptorRoomLocation descriptorItem = new CodeDescriptorRoomLocation();
        String label = DefinitionUtils.getDefinitionAttributeValue(location, "ETIQUETA");
        Definition defLocated = ((DefinitionExtensionLocation)location.getExtension()).getDefinitionLocated();
        if (label == null || label.isEmpty()) {
            label = RendererHelper.getLabelForDefinitionPlaceName(location.getName());
        }
        result.add("name", RendererHelper.nameOf(location, roomCodes));
        result.add("drc", defLocated.getDRC());
        result.add("place", RendererHelper.placeOf(location));
        result.add("placeName", RendererHelper.normalize(RendererHelper.placeOf(location)));
        result.add("label", label);
        return result;
    }

    private static String getLabelForDefinitionPlaceName(String name) {
        if (!name.startsWith(Constants.DEFINITION_LOCATION_LOCATION)) {
            return name;
        }
        String result = name.substring(Constants.DEFINITION_LOCATION_LOCATION.length());
        int pos = result.indexOf("::");
        return pos > 0 ? result.substring(pos + 2) : result;
    }

    private static void registerIn(HashMap<String, List<Definition>> sectionMap, Definition location) {
        String place = RendererHelper.placeOf(location);
        if (!sectionMap.containsKey(place)) {
            sectionMap.put(place, new ArrayList());
        }
        sectionMap.get(place).add(location);
    }
}

