/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("model")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.model;\n\nimport io.intino.goros.egeasy.box.ui.model.Center;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.Location;\n\nimport java.util.Arrays;\nimport java.util.List;\nimport java.io.File;\n\npublic class Model {\n    private static File iconsDir;\n\n    public static void init(File iconsDir) {\n        Model.iconsDir = iconsDir;\n    }\n\n    public static Center center() {\n        return loadCenter();\n    }\n\n    public static Room room(String name) {\n        return center().roomList().stream().filter(o -> o.name().equals(name)).findFirst().orElse(null);\n    }\n\n    private static Center loadCenter() {\n        Center center = new Center(\"")).output(Outputs.placeholder("title", new String[0])).output(Outputs.literal("\");\n        ")).output(Outputs.placeholder("room", "add").multiple("\n")).output(Outputs.literal("\n        return center;\n    }\n\n    private static Room room(String name, int drc, String label) {\n        ")).output(Outputs.placeholder("room", "get").multiple("\n")).output(Outputs.literal("\n        return null;\n    }\n\n    ")).output(Outputs.placeholder("room", "method").multiple("\n")).output(Outputs.literal("\n\n    private static Section section(String label, java.net.URL icon, List<Location> locations) {\n        return new Section().label(label).locations(locations).icon(icon);\n    }\n\n    private static Location location(String name, String label, int drc) {\n        return new Location().name(name).label(label).drc(drc);\n    }\n\n    private static List<Location> locations(Location... locations) {\n        return Arrays.asList(locations);\n    }\n\n}\n")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("room"), (LogicalExpression)Predicates.trigger("add"))).output(Outputs.literal("center.add(room(\"")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("\", ")).output(Outputs.placeholder("drc", new String[0])).output(Outputs.literal(", \"")).output(Outputs.placeholder("label", new String[0])).output(Outputs.literal("\"));")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("room"), (LogicalExpression)Predicates.trigger("get"))).output(Outputs.literal("if (name.equals(\"")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("\")) return new Room().name(name).drc(drc).label(label).sectionList(")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("RoomSections());")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("room"), (LogicalExpression)Predicates.trigger("method"))).output(Outputs.literal("private static List<Section> ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("RoomSections() {\n    List<Section> result = new java.util.ArrayList<>();\n    result.add(section(\"Tareas\", io.intino.goros.egeasy.box.ui.DisplayHelper.iconUrlOf(Model.iconsDir + \"/Sistema/TaskTray.ico\"), locations(location(\"locales\", \"Tareas locales\", 22), location(\"mis-tareas\", \"Mis tareas\", 24), location(\"procesos\", \"Procesos\", 25), location(\"espera\", \"Tareas en espera\", 26), location(\"firma\", \"Tareas de firma\", 31))));\n    ")).output(Outputs.placeholder("section", new String[0]).multiple("\n")).output(Outputs.literal("\n    return result;\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("section")).output(Outputs.literal("result.add(section(\"")).output(Outputs.placeholder("name", new String[0])).output(Outputs.literal("\", ")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(", locations(")).output(Outputs.placeholder("location", new String[0]).multiple(", ")).output(Outputs.literal(")));")));
        rules.add(this.rule().condition(Predicates.allTypes("icon", "external")).output(Outputs.literal("io.intino.goros.egeasy.box.ui.DisplayHelper.iconUrlOf(Model.iconsDir + \"/")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(".ico\")")));
        rules.add(this.rule().condition(Predicates.allTypes("icon")).output(Outputs.literal("Model.class.getResource(\"/icons/")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(".ico\")")));
        rules.add(this.rule().condition(Predicates.allTypes("location")).output(Outputs.literal("location(\"")).output(Outputs.placeholder("name", "lowerCase")).output(Outputs.literal("\", \"")).output(Outputs.placeholder("label", new String[0])).output(Outputs.literal("\", ")).output(Outputs.placeholder("drc", new String[0])).output(Outputs.literal(")")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

