/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("location")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.DatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.RoomLocationContainer;\nimport io.intino.goros.egeasy.box.ui.datasources.")).output(Outputs.placeholder("Mock", new String[0])).output(Outputs.literal("EntitySetDatasource;\nimport io.intino.goros.egeasy.box.ui.datasources.EntitySetGridDatasource;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.component.TGComponent;\nimport io.intino.goros.egeasy.m3.entity.component.TGEntitySet;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.room.TGLocation;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\n\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("grid", "import"))).output(Outputs.literal("\n\nimport java.util.HashMap;\nimport java.util.List;\nimport java.io.ByteArrayInputStream;\nimport java.util.Collections;\nimport java.util.Map;\nimport java.util.function.Consumer;\n\npublic class ")).output(Outputs.placeholder("placeName", "firstUpperCase")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template extends Abstract")).output(Outputs.placeholder("placeName", "firstUpperCase")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> implements RoomLocationContainer {\n    private TGRoom room;\n    private String roomName;\n    private Section section;\n    private TGLocation location;\n    private String locationName;\n    private EntitySetItem selectedEntity;\n    private String selectedEntityView = null;\n    private boolean readonly = true;\n    private TGResource selectedResource;\n    private boolean selectedResourceReadonly = true;\n    private String selectedView;\n    ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("content", "declaration"))).output(Outputs.literal("\n\n    public ")).output(Outputs.placeholder("placeName", "firstUpperCase")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = room;\n        this.roomName = name;\n    }\n\n    public void section(Section section) {\n        this.section = section;\n    }\n\n    public void location(TGLocation location, String name) {\n        this.location = location;\n        this.locationName = name;\n    }\n\n    ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("content", new String[0]))).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("content"), (LogicalExpression)Predicates.trigger("declaration"))).output(Outputs.placeholder("view", "declaration").multiple("\n")));
        rules.add(this.rule().condition(Predicates.allTypes("content")).output(Outputs.literal("@Override\npublic void init() {\n    super.init();\n    ")).output(Outputs.placeholder("view", "init").multiple("\n")).output(Outputs.literal("\n    entitiesBlock.onShow(e -> refreshEntitiesBlock());\n}\n\n@Override\npublic void refresh() {\n    super.refresh();\n    if (location == null) return;\n    icon.value(")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(");\n    iconCopy.text(DisplayHelper.entityInfo(location.getResource()));\n    loadingBlock.hide();\n    if (viewSelector.selection().isEmpty() && (selectedView == null || selectedView.equals(\"default\"))) viewSelector.select(\"")).output(Outputs.placeholder("defaultView", "firstLowerCase")).output(Outputs.literal("\");\n    else if (!viewSelector.selection().isEmpty() || selectedView != null) viewSelector.select(selectedView);\n    else {\n        ")).output(Outputs.placeholder("view", "refreshCall").multiple("\n")).output(Outputs.literal("\n    }\n}\n\n")).output(Outputs.placeholder("view", "initMethod").multiple("\n")).output(Outputs.literal("\n")).output(Outputs.placeholder("view", "refreshMethod").multiple("\n")).output(Outputs.literal("\n")).output(Outputs.placeholder("view", "focusMethod").multiple("\n")).output(Outputs.literal("\n\n@Override\npublic void back() {\n    if (entitiesBlock.entitiesStamp != null && !entitiesBlock.entitiesStamp.dirty() && selectedEntity != null) box().provider(session()).endEditionResource(selectedEntity.rrc());\n    selectedEntity = null;\n    showLocationBlock();\n}\n\n@Override\npublic boolean checkDirty(Consumer<Boolean> saveListener) {\n    if (!entitiesBlock.isVisible()) return true;\n    if (!entitiesBlock.entitiesStamp.dirty()) {\n        entitiesBlock.entitiesStamp.endEdition();\n        return true;\n    }\n    entitiesBlock.entitiesStamp.openSaveDialog(e -> saveListener.accept(true));\n    return false;\n}\n\n@Override\npublic void open(int drc, int rrc, String view) {\n    selectedEntityView = view;\n    if (selectedEntity != null && selectedEntity.rrc() == rrc && selectedEntity.drc() == drc) {\n        entitiesBlock.entitiesStamp.selectView(selectedEntityView);\n        return;\n    }\n    selectedResourceReadonly = !box().provider(session()).isEditingResource(rrc);\n    open(EntitySetDatasource.itemOf(rrc, drc));\n}\n\nprivate void open(TGResource resource) {\n    open(DisplayHelper.entitySetItemOf(resource.getIdentifier()));\n}\n\nprivate void open(EntitySetItem entity) {\n    if (selectedEntity != null && selectedEntity.rrc() == entity.rrc()) return;\n    selectedEntity = entity;\n    showEntitiesBlock();\n}\n\nprivate void refreshEntitiesBlock() {\n    entitiesBlock.entitiesStamp.onRemove(e -> showLocationBlock());\n    entitiesBlock.entitiesStamp.backInfo(\"")).output(Outputs.placeholder("label", new String[0])).output(Outputs.literal("\", path -> path.replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", StringUtil.encode(section.label().toLowerCase())).replace(\":location\", StringUtil.encode(locationName.toLowerCase())), null);\n    entitiesBlock.entitiesStamp.room(room, roomName);\n    entitiesBlock.entitiesStamp.section(section.label().toLowerCase());\n    entitiesBlock.entitiesStamp.location(locationName.toLowerCase());\n    entitiesBlock.entitiesStamp.entity(selectedEntity);\n    entitiesBlock.entitiesStamp.readonly(selectedResourceReadonly);\n    entitiesBlock.entitiesStamp.view(selectedEntityView);\n    entitiesBlock.entitiesStamp.refresh();\n}\n\nprivate EntitySetItem locationItem() {\n    return DisplayHelper.entitySetItemOf(location.getResource());\n}\n\nprivate void showLocationBlock() {\n    locationBlock.show();\n    entitiesBlock.hide();\n    ")).output(Outputs.placeholder("view", "refreshCall").multiple("\n")).output(Outputs.literal("\n}\n\nprivate void showEntitiesBlock() {\n    locationBlock.hide();\n    entitiesBlock.show();\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("declaration"))).output(Outputs.placeholder("declarationJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("init"))).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.onInit(e -> init")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block());\n")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.onShow(e -> refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block());")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("initmethod"))).output(Outputs.literal("public void init")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block() {\n    EntitySetItem entity = locationItem();\n    ")).output(Outputs.placeholder("initJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.literal("public void refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block() {\n    EntitySetItem entity = locationItem();\n    if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null && ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.dirty()) {\n        ")).output(Outputs.placeholder("refreshComponentJavaContent", new String[0])).output(Outputs.literal("\n        return;\n    }\n    ")).output(Outputs.placeholder("refreshJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.literal("public void refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block() {\n    EntitySetItem entity = locationItem();\n    ")).output(Outputs.placeholder("refreshJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("focusmethod"))).output(Outputs.literal("public void focus")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block(TGFieldError error) {\n    int drc = error.getDrc();\n    ")).output(Outputs.placeholder("focusJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("focusmethod"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("refreshcall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.isVisible()) refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("focuscall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.isVisible()) focus")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block(error);")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("focuscall"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("dirtycall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null && ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.dirty()) return true;\n")).output(Outputs.placeholder("dirtyJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("dirtycall"))).output(Outputs.placeholder("dirtyJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("resetcall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.reset();\n")).output(Outputs.placeholder("resetJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("resetcall"))).output(Outputs.placeholder("resetJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("savetitlecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.setContainerTitle(value);")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "document"), (LogicalExpression)Predicates.trigger("savetitlecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp.setContainerTitle(value);")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("savecall"))).output(Outputs.literal("result = ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null ? ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.save() : ValidateResult.empty();\nvalidationResultBlock.hide();\nif (!result.success()) {\n    notifyUser(result.getMessage(), UserMessage.Type.Error);\n    return result;\n}\nif (!result.getValidateError().getMessage().isEmpty()) {\n    if (showAdviseDialog && result.getValidateError().isWarning()) {\n        adviseMessage = DisplayHelper.errorMessage(result);\n        adviseDialog.open();\n        showValidationErrors(result);\n        return result;\n    }\n    notifyUser(\"No se ha podido guardar\", UserMessage.Type.Warning);\n    showValidationErrors(result);\n    return result;\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "document"), (LogicalExpression)Predicates.trigger("savecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp.save();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("savecall"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("forcesavecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.forceSave();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "document"), (LogicalExpression)Predicates.trigger("forcesavecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp.save();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("forcesavecall"))));
        rules.add(this.rule().condition(Predicates.allTypes("icon", "defined")).output(Outputs.literal("io.intino.goros.egeasy.box.ui.DisplayHelper.iconUrlOf(box().egeConfiguration().iconsDir() + \"/")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(".ico\")")));
        rules.add(this.rule().condition(Predicates.allTypes("icon")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.model.Model.class.getResource(\"/icons/")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(".ico\")")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

