/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.model.MatrixColumn;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.egeasy.util.DefinitionUtils;
import io.intino.itrules.FrameBuilder;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class SetRenderer<D extends Definition>
extends DefinitionRenderer<D> {
    protected DefinitionRendererFactory factory = new DefinitionRendererFactory();
    private static final String DefaultWidth = "350px";
    private static final int DefaultHeight = 30;
    private static final int DefaultGroupHeight = 35;

    public SetRenderer(TreeNodeResource dictionary, Modernization modernization, D definition) {
        super(dictionary, modernization, definition);
    }

    protected void addSet(FrameBuilder result, DefInstance definition, Definition definitionLocated, Definition collectionDefinition) throws Exception {
        FrameBuilder setBuilder = this.baseFrame().add("set");
        Definition parent = this.parent();
        setBuilder.add("name", this.nameOf(definition));
        if (parent != null) {
            setBuilder.add("parent", this.shortNameOf(parent));
        }
        setBuilder.add("drc", definition.getDRC());
        setBuilder.add("code", definition.getName());
        setBuilder.add("label", this.labelOf(definition));
        setBuilder.add("place", this.placeOf(definition));
        setBuilder.add("icon", this.iconFrameOf(definitionLocated));
        setBuilder.add("placeName", this.normalize(this.placeOf(definition)));
        setBuilder.add("height", 35);
        this.addColumns(setBuilder, collectionDefinition);
        result.add("set", setBuilder);
    }

    protected void addColumns(FrameBuilder result, Definition setDefinition) throws Exception {
        List<MatrixColumn> columns = this.columns(setDefinition);
        String width = this.width(columns);
        int height = this.height(columns);
        columns.forEach(c -> {
            boolean isFirst;
            boolean bl = isFirst = c == columns.get(0);
            if (isFirst) {
                result.add("defaultColumn", this.columnFrameOf((MatrixColumn)c, true, width, height));
            }
            result.add("column", this.columnFrameOf((MatrixColumn)c, isFirst, width, height));
        });
    }

    protected List<MatrixColumn> columns(Definition setDefinition) throws Exception {
        List<MatrixColumn> collectionColumns = LibraryDefinitions.getEntitySetColumns(setDefinition);
        return collectionColumns.isEmpty() ? this.defaultColumns() : collectionColumns;
    }

    protected List<MatrixColumn> defaultColumns() {
        return List.of(new MatrixColumn("NAME", 256));
    }

    protected void addEntityTypes(Definition definition, FrameBuilder builder) {
        List<Definition> definitions = DefinitionUtils.entityTypesOf(definition, this.modernization.includeAbstractDefinitions(), false);
        definitions = definitions.stream().filter(DefinitionUtils::canCreateNew).collect(Collectors.toList());
        FrameBuilder result = this.baseFrame().add("add");
        result.add("name", this.nameOf((Definition)this.definition()));
        if (definitions.isEmpty()) {
            result.add("empty");
        } else if (definitions.size() > 1) {
            result.add("multiple");
        }
        definitions.forEach(d -> result.add("addOption", this.addOptionFrameOf((Definition)d)));
        if (!definitions.isEmpty()) {
            result.add("defaultAddOption", this.addOptionFrameOf(definitions.get(0)));
        }
        builder.add("add", result);
    }

    protected Definition definitionLocated(Definition definition) {
        return definition != null && definition.getExtension() != null ? ((DefinitionExtensionLocation)definition.getExtension()).getDefinitionLocated() : null;
    }

    protected void addRun(DefInstance definition, Definition definitionLocated, FrameBuilder builder) {
        List<Definition> definitions = io.intino.goros.egeasy.m3.utils.DefinitionUtils.newProcessDefinitions(null, definitionLocated);
        if (definitions.isEmpty()) {
            return;
        }
        FrameBuilder result = this.baseFrame().add("run");
        result.add("name", this.nameOf((Definition)this.definition()));
        result.add("visible", !definitions.isEmpty());
        result.add("parent", this.shortNameOf(this.parent()));
        result.add("placeName", this.normalize(this.placeOf(definition)));
        if (definitions.size() > 1) {
            result.add("multiple");
        }
        definitions.forEach(d -> result.add("runOption", this.runOptionFrameOf(definition, definitionLocated, (Definition)d)));
        if (!definitions.isEmpty()) {
            result.add("defaultRunOption", this.runOptionFrameOf(definition, definitionLocated, definitions.get(0)));
        }
        builder.add("runName", this.nameOf((Definition)this.definition()));
        builder.add("run", result);
    }

    protected void addAddress(FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("address");
        if (this.parentIsLocation()) {
            result.add("full");
        }
        builder.add("address", result);
    }

    private Object addOptionFrameOf(Definition definition) {
        FrameBuilder result = this.baseFrame().add("addOption");
        result.add("name", this.nameOf(definition));
        result.add("label", this.labelOf(definition));
        result.add("drc", definition.getDRC());
        return result;
    }

    private Object runOptionFrameOf(DefInstance definition, Definition definitionLocated, Definition childDefinition) {
        FrameBuilder result = this.baseFrame().add("runOption");
        result.add("parent", this.shortNameOf(this.parent()));
        result.add("definitionName", this.nameOf(definition));
        result.add("placeName", this.normalize(this.placeOf(definition)));
        result.add("name", this.nameOf(childDefinition));
        result.add("label", this.labelOf(childDefinition));
        result.add("drc", childDefinition.getDRC());
        return result;
    }

    private String width(List<MatrixColumn> columns) {
        int columnCount = columns.size();
        return columnCount > 3 ? DefaultWidth : null;
    }

    private int height(List<MatrixColumn> columns) {
        return 30;
    }

    private FrameBuilder columnFrameOf(MatrixColumn columnDefinition, boolean isLink, String width, int height) {
        FrameBuilder result = this.baseFrame().add("column").add(this.variantTypeOf(columnDefinition));
        Object definition = this.definition();
        String idSeed = UUID.randomUUID().toString().split("-")[0];
        String placeName = definition instanceof DefInstance ? this.normalize(this.placeOf((DefInstance)definition)) : null;
        this.addColumnTypes(isLink, result);
        result.add("location", this.nameOf((Definition)definition));
        result.add("shortLocation", this.shortNameOf((Definition)definition));
        result.add("name", this.normalize(columnDefinition.getTitle()));
        result.add("shortName", this.shortNameOf(columnDefinition.getTitle()));
        result.add("id", "a" + (idSeed.length() > 4 ? idSeed.substring(0, 4) : idSeed));
        result.add("parent", this.parent() != null ? this.shortNameOf(this.parent()) : null);
        result.add("placeName", placeName);
        result.add("label", columnDefinition.getTitle().equals("NAME") ? "Nombre" : columnDefinition.getTitle().replace("\"", ""));
        result.add("type", this.variantTypeOf((Definition)definition));
        result.add("height", height);
        result.add("columnType", this.columnType(columnDefinition));
        if (isLink && width != null) {
            result.add("width", width);
        }
        return result;
    }

    private void addColumnTypes(boolean isLink, FrameBuilder result) {
        if (!isLink) {
            return;
        }
        result.add("link");
        if (!this.parentIsLocation()) {
            return;
        }
        result.add("addressable");
    }

    private boolean parentIsLocation() {
        Definition parent = this.parent();
        return parent != null && parent.getExtension() != null && parent.getExtension() instanceof DefinitionExtensionLocation;
    }

    private FrameBuilder columnType(MatrixColumn column) {
        return new FrameBuilder("columnType", this.variantTypeOf(column));
    }
}

