/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RoomTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("room")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.Display;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\n\nimport io.intino.goros.egeasy.box.ProviderHelper;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.RoomSectionContainer;\nimport io.intino.goros.egeasy.box.ui.RoomLocationContainer;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\n\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates.TaskSetTemplate;\n\nimport java.util.function.Consumer;\n\npublic class ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template extends Abstract")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> implements RoomSectionContainer {\n    private Section selectedSection;\n    private BlockConditional current = null;\n    private static final int drc = ")).output(Outputs.placeholder("drc", new String[0])).output(Outputs.literal(";\n\n    public ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void back() {\n        current.children(RoomLocationContainer.class).forEach(c -> ((RoomLocationContainer)c).back());\n    }\n\n    @Override\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        return current.children(RoomLocationContainer.class).stream().anyMatch(c -> ((RoomLocationContainer)c).checkDirty(saveListener));\n    }\n\n    @Override\n    public void open(Section section, Location location) {\n        if (current != null) current.hide();\n        String findValue = DisplayHelper.normalize(section.label() + location.name()).toLowerCase();\n\n        Display displayFound = null;\n        for (Display display: children()) {\n            String name = DisplayHelper.normalize(section.label() + display.name()).toLowerCase();\n            if (name.equals(findValue)) displayFound = display;\n        }\n        current = (BlockConditional) children().stream().filter(c -> c.name().toLowerCase().equals(findValue)).findFirst().orElse(null);\n        if ((displayFound != null) && (current == null))\n            current = (BlockConditional) displayFound;\n\n        notFound.visible(current == null);\n        selectedSection = section;\n        DisplayHelper.showAndRefresh(current);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        if (current == null) return;\n        DisplayHelper.showAndRefresh(current);\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    @Override\n    public void open(Section section, Location location, int drc, int rrc, String view) {\n        if (current == null) return;\n        current.children(RoomLocationContainer.class).forEach(c -> ((RoomLocationContainer)c).open(drc, rrc, view));\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        locales.onShow(e -> refreshTaskSet(22, \"locales\", \"Tareas locales\", locales.localesStamp));\n        misTareas.onShow(e -> refreshTaskSet(24, \"mis-tareas\", \"Mis tareas\", misTareas.misTareasStamp));\n        procesos.onShow(e -> refreshTaskSet(25, \"procesos\", \"Procesos\", procesos.procesosStamp));\n        espera.onShow(e -> refreshTaskSet(26, \"espera\", \"Tareas en espera\", espera.esperaStamp));\n        firma.onShow(e -> refreshTaskSet(31, \"firma\", \"Tareas de firma\", firma.firmaStamp));\n        ")).output(Outputs.placeholder("section", "init").multiple("\n")).output(Outputs.literal("\n    }\n\n    private void refreshTaskSet(int rrc, String name, String label, TaskSetTemplate display) {\n        TGRoom room = ProviderHelper.room(drc, box().provider(session()));\n        display.label(label);\n        display.rrc(rrc);\n        display.room(room, \"")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("\");\n        display.taskSet(taskSet(rrc, room), name);\n    }\n\n    private TGTaskSet taskSet(int rrc, TGRoom room) {\n        if (room == null) return null;\n        if (rrc == 22) return room.getAllTasks();\n        if (rrc == 24) return room.getMyTasks();\n        if (rrc == 25) return room.getProcesses();\n        if (rrc == 26) return room.getWaitTasks();\n        if (rrc == 31) return room.getMySignatures();\n        return null;\n    }\n\n    private void refreshLocation(int locationDRC, String locationName) {\n        RoomLocationContainer locationContainer = container(locationDRC);\n        if (locationContainer == null) return;\n        TGRoom room = ProviderHelper.room(drc, box().provider(session()));\n        locationContainer.room(room, \"")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("\");\n        locationContainer.section(selectedSection);\n        locationContainer.location(ProviderHelper.location(room, locationDRC), locationName);\n    }\n\n    private RoomLocationContainer container(int locationDRC) {\n        ")).output(Outputs.placeholder("section", "stamp").multiple("\n")).output(Outputs.literal("\n        return null;\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("section"), (LogicalExpression)Predicates.trigger("init"))).output(Outputs.placeholder("location", "init").multiple("\n")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("location"), (LogicalExpression)Predicates.trigger("init"))).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal(".onShow(e -> refreshLocation(")).output(Outputs.placeholder("drc", new String[0])).output(Outputs.literal(", \"")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("\"));")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("section"), (LogicalExpression)Predicates.trigger("stamp"))).output(Outputs.placeholder("location", "stamp").multiple("\n")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("location"), (LogicalExpression)Predicates.trigger("stamp"))).output(Outputs.literal("if (locationDRC == ")).output(Outputs.placeholder("drc", new String[0])).output(Outputs.literal(") return ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal(".")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp;")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

