/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.generators;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.entity.resource.TGResource;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.model.Constants;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import java.util.List;

public class TreeDefinitionsGenerator {
    public TreeNodeResource createTreeResourcesDefinitions(Dictionary dictionary) {
        TreeNodeResource tree = new TreeNodeResource();
        TreeNodeResource treeNodeContainers = tree.addChildren(Constants.TREE_DEFINITIONS_NODE_CONTAINERS, null);
        TreeNodeResource treeNodeTasks = tree.addChildren(Constants.TREE_DEFINITIONS_NODE_TASKS, null);
        TreeNodeResource treeNodeRooms = tree.addChildren(Constants.TREE_DEFINITIONS_NODE_ROOMS, null);
        for (Definition definition : dictionary.getDefinitionTypes()) {
            if (DefinitionUtils.isContainerDefinition(definition).booleanValue()) {
                this.addDefResource(treeNodeContainers, definition);
                continue;
            }
            if (DefinitionUtils.isTaskDefinition(definition).booleanValue()) {
                this.addDefResource(treeNodeTasks, definition);
                continue;
            }
            if (!DefinitionUtils.isRoomDefinition(definition).booleanValue()) continue;
            this.addDefResource(treeNodeRooms, definition);
        }
        for (Definition definition : dictionary.getDefInstances()) {
            if (DefinitionUtils.isContainerDefinition(definition).booleanValue()) {
                this.addDefResource(treeNodeContainers, definition);
                continue;
            }
            if (DefinitionUtils.isTaskDefinition(definition).booleanValue()) {
                this.addDefResource(treeNodeTasks, definition);
                continue;
            }
            if (!DefinitionUtils.isRoomDefinition(definition).booleanValue()) continue;
            this.addDefResource(treeNodeRooms, definition);
        }
        return tree;
    }

    private TreeNodeResource createNodeResource(Definition definition) {
        TGResource res = new TGResource();
        res.setDefinition(definition);
        TreeNodeResource node = new TreeNodeResource();
        node.setResource(res);
        if (definition != null) {
            node.setLabel(definition.getName());
        }
        return node;
    }

    private String getDefinitionAttribute(Definition definition, String atribute) {
        List<String> attributes = definition.getAttributes().findAttribute(atribute);
        if (attributes.isEmpty()) {
            return "";
        }
        return attributes.get(0);
    }

    private TreeNodeResource findNodeModule(TreeNodeResource tree, String module) {
        TreeNodeResource node = tree.findChildren(module);
        if (node == null) {
            node = tree.addChildren(module, null);
        }
        return node;
    }

    private TreeNodeResource findNodeUnit(TreeNodeResource nodeModule, String unit) {
        String[] units;
        if (nodeModule == null) {
            return null;
        }
        TreeNodeResource parentNode = nodeModule;
        TreeNodeResource unitNode = null;
        for (String partialUnit : units = unit.split("\\\\")) {
            unitNode = parentNode.findChildren(partialUnit);
            if (unitNode == null) {
                unitNode = parentNode.addChildren(partialUnit, null);
            }
            parentNode = unitNode;
        }
        return unitNode;
    }

    private void addDefResource(TreeNodeResource tree, Definition definition) {
        TreeNodeResource nodeResourceDefinition = this.createNodeResource(definition);
        String module = this.getDefinitionAttribute(definition, "COMPILACION.MODULO");
        String unit = this.getDefinitionAttribute(definition, "COMPILACION.UNIDAD");
        TreeNodeResource nodeModule = this.findNodeModule(tree, module);
        TreeNodeResource nodeUnit = this.findNodeUnit(nodeModule, unit);
        nodeUnit.addChildren(nodeResourceDefinition);
    }
}

