/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.library;

import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.expressions.LibraryExpressions;
import io.intino.goros.egeasy.m3.model.MatrixColumn;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class LibraryDefinitions {
    public static Definition findDefinition(int drc, ArrayList<Definition> list) {
        return LibraryDefinitions.findDefinition(drc, list.toArray(new Definition[list.size()]));
    }

    public static Definition findDefinition(int drc, Definition[] list) {
        for (Definition definition : list) {
            if (definition.getDRC() != drc) continue;
            return definition;
        }
        return null;
    }

    public static Definition findDefinition(String name, ArrayList<Definition> list) {
        return LibraryDefinitions.findDefinition(name, list.toArray(new Definition[list.size()]));
    }

    public static Definition findDefinition(String name, Definition[] list) {
        for (Definition definition : list) {
            if (!definition.getName().equals(name)) continue;
            return definition;
        }
        return null;
    }

    public static Definition findDefinition(int drc, Definition domain, boolean findInParents) {
        Definition result = null;
        while (domain != null) {
            result = LibraryDefinitions.findDefinition(drc, domain.getDefinitions().toArray(new Definition[domain.getDefinitions().size()]));
            if (result != null) {
                return result;
            }
            if (findInParents) {
                domain = domain.getParent();
                continue;
            }
            domain = null;
        }
        return null;
    }

    public static Definition findDefinition(String name, Definition domain, boolean findInParents) {
        Definition result = null;
        while (domain != null) {
            result = LibraryDefinitions.findDefinition(name, domain.getDefinitions().toArray(new Definition[domain.getDefinitions().size()]));
            if (result != null) {
                return result;
            }
            if (findInParents) {
                domain = domain.getParent();
                continue;
            }
            domain = null;
        }
        return null;
    }

    public static List<Definition> findDefinitions(int[] DRCs, List<DefType> list) {
        List aDRCs = Arrays.stream(DRCs).boxed().collect(Collectors.toList());
        return list.stream().filter(definition -> aDRCs.indexOf(definition.getDRC()) >= 0).collect(Collectors.toList());
    }

    public static List<MatrixColumn> getEntitySetColumns(Definition definition) throws Exception {
        String linkValuesExpression = DefinitionUtils.getDefinitionAttributeValue(definition, "VINCULO.VALORES");
        List<MatrixColumn> matrixColumns = LibraryDefinitions.isLinkValuesExpresionSQL(linkValuesExpression) != false ? LibraryDefinitions.getEntitySetColumnsByExpression(definition, linkValuesExpression) : LibraryDefinitions.getEntitySetColumnsByDefinition(definition);
        return matrixColumns == null ? Collections.emptyList() : matrixColumns;
    }

    public static List<MatrixColumn> getInventoryColumns(Definition definition) throws Exception {
        String valuesExpression = DefinitionUtils.getDefinitionAttributeValue(definition, "VALOR");
        return LibraryExpressions.getColumnsBySQL(valuesExpression);
    }

    private static Boolean isLinkValuesExpresionSQL(String expression) {
        return expression != null && LibraryExpressions.isSqlExpression(expression) != false;
    }

    private static List<MatrixColumn> getEntitySetColumnsByDefinition(Definition definition) throws Exception {
        if (DefinitionUtils.isCollectionDefinition(definition).booleanValue()) {
            return LibraryExpressions.getEntitySetColumnsByCollection(definition);
        }
        if (DefinitionUtils.isCatalogDefinition(definition).booleanValue()) {
            return LibraryExpressions.getEntitySetColumnsByCatalog(definition);
        }
        return Collections.emptyList();
    }

    private static List<MatrixColumn> getEntitySetColumnsByExpression(Definition definition, String expression) throws Exception {
        String contentExpression = LibraryExpressions.getSqlExpression(expression);
        if (contentExpression == null) {
            return Collections.emptyList();
        }
        return LibraryExpressions.isExpressionSQL(contentExpression) ? LibraryExpressions.getColumnsBySQL(contentExpression) : LibraryDefinitions.getEntitySetColumnsByExpressionComponent(definition, contentExpression);
    }

    private static List<MatrixColumn> getEntitySetColumnsByExpressionComponent(Definition definition, String expression) throws Exception {
        String targetExpression = LibraryExpressions.getTargetExpressionFromLinkValues(expression);
        return targetExpression == null || targetExpression.isEmpty() ? Collections.emptyList() : LibraryExpressions.getEntitySetColumnsByTarget(definition, targetExpression);
    }

    public static boolean getAtActive(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("ACTIVO");
        if (attributeValues.isEmpty()) {
            return true;
        }
        return attributeValues.get(0).equals("S");
    }

    public static boolean getAtAutomaticEdition(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("EDICION_AUTOMATICA");
        if (attributeValues.isEmpty()) {
            return false;
        }
        return attributeValues.get(0).equals("S");
    }

    public static boolean getAtIsRoot(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("ES_RAIZ");
        if (attributeValues.isEmpty()) {
            return false;
        }
        return attributeValues.get(0).equals("S");
    }

    public static boolean getAtPlatinoSGRDEDocumentCertificateActive(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("PLATINO_SGRDE_FIRMA_COPIA.ACTIVO");
        if (attributeValues.isEmpty()) {
            return false;
        }
        return attributeValues.get(0).equals("S");
    }

    public static int[] getAtTargetTypes(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("DESTINO.DEFINICION");
        if (attributeValues.isEmpty()) {
            return null;
        }
        return attributeValues.stream().mapToInt(Integer::parseInt).toArray();
    }

    public static String getAtFieldSignature(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("CAMPO_FIRMA");
        if (attributeValues.isEmpty()) {
            return null;
        }
        return attributeValues.get(0);
    }

    public static String getAtFieldApproval(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("CAMPO_VISTO_BUENO");
        if (attributeValues.isEmpty()) {
            return null;
        }
        return attributeValues.get(0);
    }

    public static String getAtLabel(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("ETIQUETA");
        return !attributeValues.isEmpty() ? attributeValues.get(0) : null;
    }

    public static String getAtHelpFields(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("AYUDA_CAMPOS");
        return !attributeValues.isEmpty() ? attributeValues.get(0) : null;
    }

    public static boolean isEditionSuggestion(Definition definition) {
        return DefinitionUtils.getDefinitionAttributeValue(definition, "EDICION.MODO").equals("2");
    }

    public static boolean isEditionWithOptions(Definition definition) {
        String values = DefinitionUtils.getDefinitionAttributeValue(definition, "EDICION.VALORES");
        return values != null && !values.isEmpty();
    }

    public static boolean isEditionReference(Definition definition) {
        return DefinitionUtils.getDefinitionAttributeValue(definition, "EDICION.MODO").equals("3");
    }

    public static boolean isEditionCopy(Definition definition) {
        return DefinitionUtils.getDefinitionAttributeValue(definition, "EDICION.MODO").equals("4");
    }

    public static boolean isLabelEditable(Definition definition) {
        return DefinitionUtils.getDefinitionAttributeValue(definition, "NOMBRE").isEmpty();
    }
}

