/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FileServiceTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("fileservice", "getfileaction")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.actions;\n\nimport io.intino.alexandria.Resource;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.exceptions.BadRequest;\nimport io.intino.alexandria.exceptions.Forbidden;\nimport io.intino.alexandria.exceptions.NotFound;\nimport io.intino.goros.egeasy.provider.Provider;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.InputStream;\n\npublic class GetFileAction implements io.intino.alexandria.rest.RequestErrorHandler {\n    public String type;\n    public Integer rrc;\n    public Integer drc;\n    public Integer cdrc;\n    public Integer crow;\n    public String name;\n    public Integer id;\n    public Boolean signed;\n    public String session;\n    public ")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box;\n    public io.intino.alexandria.http.server.AlexandriaHttpContext context;\n\n    public io.intino.alexandria.Resource execute() throws BadRequest, Forbidden, NotFound {\n        Provider provider = box.provider(session);\n        if (provider == null) throw new Forbidden(\"You don't have access to this file\");\n        InputStream result;\n        if (type.equals(\"document\")) result = provider.openDocumentFile(loadContainer(rrc, drc), cdrc, signed).getContent();\n        else if (type.equals(\"inventory\")) result = provider.openInventoryFile(rrc, drc, cdrc, id);\n        else if (type.equals(\"classifier\")) result = provider.openClassifierFile(rrc, drc, cdrc, id);\n        else if (type.equals(\"svd\")) result = provider.openSVDFile(rrc, drc, id);\n        else if (isTable()) result = provider.openTableFile(id, signed);\n        else result = provider.openFieldFile(rrc, drc, cdrc, -1, signed);\n        return new Resource(name, result);\n    }\n\n    public void onMalformedRequest(Throwable e) throws AlexandriaException {\n        throw new BadRequest(\"Malformed request\");\n    }\n\n    private TGResource loadContainer(Integer rrc, Integer drc) {\n        TGResource result = box.edition(rrc);\n        return result != null ? result : box.provider(session).openResource(rrc, drc);\n    }\n\n    private boolean isTable() {\n        return crow != null && crow != -1;\n    }\n}")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

