/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.Renderer;
import io.intino.goros.modernizing.egeasy.renderers.RendererHelper;
import io.intino.goros.modernizing.egeasy.renderers.templates.java.ModelTemplate;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.util.List;

public class ModelRenderer
extends Renderer {
    private final List<Definition> roomList;

    public ModelRenderer(TreeNodeResource dictionary, Modernization modernization, List<Definition> roomList) {
        super(dictionary, modernization);
        this.roomList = roomList;
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        File file = new File(this.modernization.sourceUiDirectory() + File.separator + "model" + File.separator + "Model.java");
        this.writeFrame(file, new ModelTemplate().render(builder.toFrame()));
    }

    private FrameBuilder buildFrame() {
        FrameBuilder result = this.baseFrame();
        result.add("model");
        result.add("title", this.modernization.projectName());
        this.roomList.forEach(d -> result.add("room", this.frameOf((Definition)d)));
        return result;
    }

    private FrameBuilder frameOf(Definition definition) {
        FrameBuilder result = new FrameBuilder("room");
        result.add("name", this.nameOf(definition));
        result.add("drc", definition.getDRC());
        result.add("label", this.labelOf(definition));
        RendererHelper.addSectionsTo(result, definition, this.modernization.roomCodes());
        return result;
    }
}

