/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.definition.dictionary;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionException;
import io.intino.goros.egeasy.m3.definition.base.ListDefInstances;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import java.time.ZonedDateTime;
import java.util.ArrayList;

public class Dictionary {
    private static Dictionary instance;
    public static final int CODE_DICTIONARY_MONOLITHIC = 144;
    public static final int CODE_DICTIONARY_MODULE = 147;
    public static final int CODE_DEFINITION = 146;
    public static final int CODE_DEF_TYPE = 160;
    public static final int CODE_DEF_INSTANCE = 192;
    public static final int MASK_DEFINITION = 224;
    public static final int MASK_EXTENSION = 31;
    public static final int CODE_EXT_ACCESS = 201;
    public static final int CODE_EXT_COLUMN = 209;
    public static final int CODE_EXT_COMPETENCE = 202;
    public static final int CODE_EXT_CONDITION = 210;
    public static final int CODE_EXT_CONFIDENCIALITY_FIELD = 219;
    public static final int CODE_EXT_CONFIDENCIALITY_KEY = 218;
    public static final int CODE_EXT_CONFIDENCIALITY_ROLE = 220;
    public static final int CODE_EXT_CONTENT = 205;
    public static final int CODE_EXT_DIVISION = 216;
    public static final int CODE_EXT_EXTERNAL_VALUES_FILE = 204;
    public static final int CODE_EXT_EXTERNAL_VALUES_SENTENCE = 213;
    public static final int CODE_EXT_INCLUDE = 206;
    public static final int CODE_EXT_KEY = 214;
    public static final int CODE_EXT_LOCATION = 207;
    public static final int CODE_EXT_MARKER = 208;
    public static final int CODE_EXT_METADATA = 222;
    public static final int CODE_EXT_SEARCH = 215;
    public static final int CODE_EXT_SIGN = 211;
    public static final int CODE_EXT_STAMP = 217;
    public static final int CODE_EXT_VALUES = 203;
    public static final int MARK_INHERITED = -1;
    private boolean loaded = false;
    private String title;
    private String version;
    private ZonedDateTime creationDate;
    private int lastDRC;
    private String help;
    private ArrayList<Definition> definitions = new ArrayList();
    private ArrayList<DefType> definitionTypes = new ArrayList();
    private ArrayList<DefInstance> defInstances = new ArrayList();
    private ArrayList<Definition> internalDefinitions = new ArrayList();
    private ArrayList<Definition> externalDefinitions = new ArrayList();

    private Dictionary() {
    }

    public static synchronized Dictionary getInstance() {
        if (instance == null) {
            instance = new Dictionary();
        }
        return instance;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(ZonedDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public int getLastDRC() {
        return this.lastDRC;
    }

    public void setLastDRC(int lastDRC) {
        this.lastDRC = lastDRC;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public ArrayList<Definition> getDefinitions() {
        return this.definitions;
    }

    public ArrayList<DefType> getDefinitionTypes() {
        return this.definitionTypes;
    }

    public ArrayList<DefInstance> getDefInstances() {
        return this.defInstances;
    }

    public ArrayList<Definition> getInternalDefinitions() {
        return this.internalDefinitions;
    }

    public ArrayList<Definition> getExternalDefinitions() {
        return this.externalDefinitions;
    }

    public Definition createDefinition(Class classDefinition) throws DefinitionException {
        return this.createDefinition(classDefinition, null);
    }

    public Definition createDefinition(Class classDefinition, Definition domain) throws DefinitionException {
        try {
            Definition definition = (Definition)classDefinition.newInstance();
            this.internalDefinitions.add(definition);
            this.definitions.add(definition);
            if (definition instanceof DefType) {
                this.definitionTypes.add((DefType)definition);
            } else if (definition instanceof DefInstance && domain == null) {
                this.defInstances.add((DefInstance)definition);
            }
            return definition;
        }
        catch (Exception e) {
            throw new DefinitionException("Can't create definition", e);
        }
    }

    public void loadExternalDefinitions(Definition[] definitions) {
        for (Definition definition : definitions) {
            this.externalDefinitions.add(definition);
            this.definitions.add(definition);
            if (definition instanceof DefType) {
                this.definitionTypes.add((DefType)definition);
                continue;
            }
            if (!(definition instanceof DefInstance) || ((DefInstance)definition).getDomain() != null) continue;
            this.defInstances.add((DefInstance)definition);
        }
    }

    public void activeInheritance() {
        for (DefType baseDefinition : this.definitionTypes) {
            if (baseDefinition.getParent() != null) continue;
            this.activeInheritance(baseDefinition);
        }
    }

    private void activeInheritance(Definition definition) {
        for (Definition child : definition.getChildren()) {
            ListDefInstances definitionList = definition.getDefinitions();
            for (int i = definitionList.size() - 1; i >= 0; --i) {
                Definition memberParent = (Definition)definitionList.get(i);
                Definition memberChild = LibraryDefinitions.findDefinition(memberParent.getName(), child.getDefinitions().toArray(new Definition[0]));
                if (memberChild == null) {
                    child.getDefinitions().add(0, memberParent);
                    continue;
                }
                child.getDefinitions().remove(memberChild);
                child.getDefinitions().add(0, memberChild);
            }
            this.activeInheritance(child);
        }
    }

    public Definition findDefinition(int drc) {
        Definition def = LibraryDefinitions.findDefinition(drc, this.getDefinitionTypes().toArray(new Definition[this.getDefinitionTypes().size()]));
        if (def == null) {
            def = LibraryDefinitions.findDefinition(drc, this.getDefInstances().toArray(new Definition[this.getDefInstances().size()]));
        }
        return def;
    }
}

