/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternHelper {
    private static final Pattern TokenPattern = Pattern.compile("<([^>]*)>");
    private static final Pattern UpperCasePattern = Pattern.compile(">([^<]*)");
    private static final Map<Character, Character> UpperCases = Map.of(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('a'), Character.valueOf('n'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('l'), Character.valueOf('m'));

    public static String intinoPatternOf(String pattern) {
        String result = pattern.split(";")[0];
        result = PatternHelper.replaceTokens(result);
        result = PatternHelper.replaceUppercase(result);
        result = PatternHelper.replaceBars(result);
        return result;
    }

    private static String replaceTokens(String value) {
        Matcher matcher = TokenPattern.matcher(value);
        while (matcher.find()) {
            value = value.replace(matcher.group(0), PatternHelper.tokens(matcher.group(1)));
        }
        return value;
    }

    private static String replaceUppercase(String value) {
        Matcher matcher = UpperCasePattern.matcher(value);
        while (matcher.find()) {
            value = value.replace(matcher.group(0), PatternHelper.uppercase(matcher.group(1)));
        }
        return value.replace("<", "");
    }

    private static String replaceBars(String value) {
        return value.replace("\\", "\\\\");
    }

    private static String tokens(String value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            result.append("\\\\").append(value.charAt(i));
        }
        return result.toString();
    }

    private static String uppercase(String value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            result.append(UpperCases.containsKey(Character.valueOf(value.charAt(i))) ? UpperCases.get(Character.valueOf(value.charAt(i))).charValue() : value.charAt(i));
        }
        return result.toString();
    }
}

