/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.serializer;

import io.intino.goros.egeasy.m3.serializer.SerializerStatus;
import java.io.IOException;
import java.util.Stack;

public abstract class SerializedStream {
    protected static final byte MARK_START = -6;
    protected Stack<SerializerStatus> stackStatus = new Stack();
    protected Stack<Integer> stackFieldtype = new Stack();
    protected Stack<Long> stackPos = new Stack();
    protected long streamSize;

    public abstract long getPosition();

    public abstract void setPosition(Long var1);

    public abstract void close() throws IOException;

    public Stack<SerializerStatus> getStackStatus() {
        return this.stackStatus;
    }

    public Stack<Integer> getStackFieldtype() {
        return this.stackFieldtype;
    }

    public Stack<Long> getStackPos() {
        return this.stackPos;
    }

    public void pushPosition() {
        this.stackPos.push(this.getPosition());
    }

    public long popPosition() {
        return this.stackPos.pop();
    }

    public void addField(String name, int fieldType) {
        this.stackStatus.peek().addField(name, this.getPosition(), fieldType);
    }

    protected static class FieldHeader {
        public String name;
        public int type;

        public FieldHeader(String fieldName, int fieldType) {
            this.name = fieldName;
            this.type = fieldType;
        }
    }

    public static class ESerializedStreamException
    extends Exception {
        public ESerializedStreamException(String message) {
            super(message);
        }

        public ESerializedStreamException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

