/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.entity.field;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.entity.TGEntity;
import io.intino.goros.egeasy.m3.entity.TGListComponents;
import io.intino.goros.egeasy.m3.entity.component.TGComponent;
import io.intino.goros.egeasy.m3.entity.field.TGField;
import io.intino.goros.egeasy.m3.producer.FactoryEntity;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TGFieldTable
extends TGField {
    private List<TGListComponents> ARows = new ArrayList<TGListComponents>();

    public List<TGListComponents> getARows() {
        return this.ARows;
    }

    public int getColCount() {
        return this.getDefColumns().size();
    }

    private List<Definition> getDefColumns() {
        if (this.getDefinition() == null) {
            return null;
        }
        return this.getDefinition().getDefinitions().stream().filter(DefinitionUtils::isFieldDefinition).collect(Collectors.toList());
    }

    public TGListComponents addRow() {
        TGListComponents newRow = new TGListComponents();
        List<Definition> defFields = this.getDefColumns();
        for (Definition def : defFields) {
            TGEntity column = FactoryEntity.getInstance().createEntity(def);
            column.setDomain(this);
            if (!(column instanceof TGField)) continue;
            newRow.getAComponents().add((TGField)column);
        }
        this.ARows.add(newRow);
        return newRow;
    }

    @Override
    public void assignValue(TGComponent value) {
        if (!(value instanceof TGFieldTable)) {
            return;
        }
        TGFieldTable fieldTable = (TGFieldTable)value;
        if (fieldTable.getColCount() != this.getColCount()) {
            return;
        }
        this.getARows().clear();
        for (TGListComponents row : fieldTable.getARows()) {
            TGListComponents rowNew = this.addRow();
            rowNew.assignValue(row);
        }
    }
}

