/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.rules.conditions;

import io.intino.itrules.Rule;
import io.intino.itrules.TemplateEngine;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeCondition
implements Rule.Condition {
    private final Checker checker;
    private final Operator operator;
    private final String[] types;

    public TypeCondition(Operator operator, String ... types) {
        this.operator = operator;
        this.types = types;
        this.checker = types.length > 1 ? this.multiple(operator, this.setOf(types)) : this.single(types[0].toLowerCase());
    }

    public Operator operator() {
        return this.operator;
    }

    public String[] types() {
        return this.types;
    }

    private Checker multiple(Operator operator, Set<String> types) {
        return operator == Operator.Any ? this.createAnyChecker(types) : this.createAllChecker(types);
    }

    private Checker single(String type) {
        return trigger -> trigger.frame().is(type);
    }

    private Checker createAllChecker(Set<String> types) {
        return trigger -> types.stream().allMatch(t -> trigger.frame().is((String)t));
    }

    private Checker createAnyChecker(Set<String> types) {
        return trigger -> types.stream().anyMatch(t -> trigger.frame().is((String)t));
    }

    @Override
    public boolean check(TemplateEngine.Trigger trigger) {
        return this.checker.check(trigger);
    }

    private Set<String> setOf(String[] types) {
        return Arrays.stream(types).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public static enum Operator {
        All,
        Any;

    }

    static interface Checker {
        public boolean check(TemplateEngine.Trigger var1);
    }
}

