/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.entity;

import io.intino.goros.egeasy.m3.utils.DateUtils;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;

public class TGVariant {
    private Integer type;
    private Object value;

    public TGVariant() {
        this(0, null);
    }

    public TGVariant(Integer type, Object value) {
        this.type = type;
        this.value = type == 7 && value instanceof Instant ? DateUtils.instantToDouble((Instant)value) : (type == 6 && value instanceof BigDecimal ? this.bigDecimalToLong((BigDecimal)value) : (type == 3 && value instanceof Double ? Integer.valueOf(((Double)value).intValue()) : value));
    }

    public boolean isEqual(TGVariant value) {
        if (value == null) {
            return false;
        }
        if (this.type != value.getType()) {
            return false;
        }
        try {
            if (this.isString()) {
                return value.asString().equals(this.asString());
            }
            if (this.isInstant()) {
                return value.asInstant() == this.asInstant();
            }
            if (this.isBoolean()) {
                return value.asBoolean() == this.asBoolean();
            }
            if (this.isCurrency()) {
                return value.asCurrency() == this.asCurrency();
            }
            if (this.isInt()) {
                return value.asInt() == this.asInt();
            }
            if (this.isDouble()) {
                return value.asDouble() == this.asDouble();
            }
            if (this.isFloat()) {
                return value.asFloat() == this.asFloat();
            }
            if (this.isByte()) {
                return value.asByte() == this.asByte();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Integer getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isInt() {
        int type = this.getType();
        return type == 3;
    }

    public Integer asInt() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return 0;
            }
            case 3: {
                return (Integer)this.getValue();
            }
            case 5: {
                return ((Double)this.getValue()).intValue();
            }
            case 4: {
                return ((Double)this.getValue()).intValue();
            }
            case 256: {
                return Integer.parseInt((String)this.getValue());
            }
        }
        throw new EGVariant("Bad type");
    }

    public boolean isString() {
        int type = this.getType();
        return type == 256 || type == 8 || type == 16385;
    }

    public String asString() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return "";
            }
            case 8: 
            case 256: 
            case 16385: {
                return (String)this.getValue();
            }
        }
        throw new EGVariant("Bad type");
    }

    public boolean isFloat() {
        int type = this.getType();
        return type == 4;
    }

    public Float asFloat() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return Float.valueOf(0.0f);
            }
            case 4: {
                return (Float)this.getValue();
            }
        }
        throw new EGVariant("Bad type");
    }

    public boolean isDouble() {
        int type = this.getType();
        return type == 5;
    }

    public Double asDouble() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return 0.0;
            }
            case 4: 
            case 5: 
            case 7: {
                return (Double)this.getValue();
            }
        }
        throw new EGVariant("Bad type");
    }

    public Long asLong() throws EGVariant {
        switch (this.getType()) {
            case 6: {
                return (Long)this.getValue();
            }
        }
        throw new EGVariant("Bad type");
    }

    public BigDecimal asCurrency() throws EGVariant {
        switch (this.getType()) {
            case 6: {
                return this.longToBigDecimal((Long)this.value);
            }
        }
        throw new EGVariant("Bad type");
    }

    public boolean isCurrency() {
        int type = this.getType();
        return type == 6;
    }

    public boolean isBoolean() {
        int type = this.getType();
        return type == 11;
    }

    public boolean asBoolean() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return false;
            }
            case 11: {
                return (Boolean)this.getValue();
            }
        }
        throw new EGVariant("Bad type");
    }

    public boolean isByte() {
        int type = this.getType();
        return type == 17;
    }

    public byte asByte() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return 0;
            }
            case 17: {
                return (Byte)this.getValue();
            }
        }
        throw new EGVariant("Bad type");
    }

    public boolean isInstant() {
        int type = this.getType();
        return type == 7;
    }

    public Instant asInstant() throws EGVariant {
        switch (this.getType()) {
            case 0: {
                return null;
            }
            case 7: {
                Object value = this.getValue();
                if (value instanceof Double) {
                    return DateUtils.doubleToInstant((Double)value);
                }
                if (value instanceof ZonedDateTime) {
                    return ((ZonedDateTime)value).toInstant();
                }
                if (value instanceof Instant) {
                    return (Instant)value;
                }
                return null;
            }
        }
        throw new EGVariant("Bad type");
    }

    private BigDecimal longToBigDecimal(Long value) {
        BigDecimal bd = new BigDecimal(value);
        return bd.divide(new BigDecimal(10000));
    }

    private Long bigDecimalToLong(BigDecimal value) {
        value = value.multiply(new BigDecimal(10000));
        return value.longValue();
    }

    public void assignValue(TGVariant value) {
        this.value = value.getValue();
        this.type = value.getType();
    }

    public static class EGVariant
    extends Exception {
        public EGVariant(String cause) {
            super(cause);
        }
    }
}

