/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.expressions.LibraryExpressions;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.model.EntitySetColumn;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.egeasy.renderers.definition.EntitySetItemRenderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.konos.FormWithFieldsTemplate;
import io.intino.goros.modernizing.egeasy.util.PatternHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldRenderer
extends EntitySetItemRenderer<Definition> {
    private DefinitionRendererFactory factory = new DefinitionRendererFactory();
    private static final Map<String, Integer> Widths = Map.of("CODE", 10, "DESCRIPTION", 90);
    private static final Map<String, String> Titles = Map.of("NAME", "Nombre", "CODE", "C\u00f3digo", "DESCRIPTION", "Descripci\u00f3n");

    public FieldRenderer(TreeNodeResource dictionary, Modernization modernization, Definition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        builder.add("definition");
        this.writeTable(builder);
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder result = this.baseDefinitionFrame();
        result.add("type", this.fieldTypeOf((Definition)this.definition()));
        result.add("form", this.context());
        this.addAttributes(result);
        this.addToolbar(result);
        this.addStringProperties(result);
        this.addDateProperties(result);
        this.addLinkProperties(result);
        this.addCodeProperties(result);
        return result;
    }

    @Override
    protected FrameBuilder baseDefinitionFrame() {
        Object definition = this.definition();
        FrameBuilder result = super.baseFrame();
        result.add("field");
        result.add(this.typeOf((Definition)definition));
        result.add("parent", this.parent() != null ? this.nameOf(this.parent()) : null);
        result.add("name", this.nameOf((Definition)definition));
        result.add("shortName", this.shortNameOf((Definition)definition));
        result.add("drc", ((Definition)definition).getDRC());
        result.add("code", ((Definition)definition).getName());
        result.add("label", this.labelOf((Definition)definition));
        return result;
    }

    @Override
    protected Template konosTemplate() {
        return new FormWithFieldsTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new io.intino.goros.modernizing.egeasy.renderers.templates.java.FormWithFieldsTemplate();
    }

    private String typeOf(Definition definition) {
        if (this.isSelect(definition)) {
            return "select";
        }
        int type = definition.getTypeValue();
        Metamodel instance = Metamodel.getInstance();
        if (type == instance.DTInteger.getTypeValue()) {
            return "integer";
        }
        if (type == instance.DTDate.getTypeValue()) {
            return "date";
        }
        if (type == instance.DTTime.getTypeValue()) {
            return "date";
        }
        if (type == instance.DTDateTime.getTypeValue()) {
            return "date";
        }
        if (type == instance.DTSignature.getTypeValue()) {
            return "signature";
        }
        if (type == instance.DTImage.getTypeValue()) {
            return "image";
        }
        if (type == instance.DTCheckTable.getTypeValue()) {
            return "checktable";
        }
        if (type == instance.DTBoolean.getTypeValue()) {
            return "boolean";
        }
        if (type == instance.DTMemo.getTypeValue() && definition.getRoot() == Metamodel.getInstance().DTMemo) {
            return "memo";
        }
        if (type == instance.DTString.getTypeValue()) {
            return "string";
        }
        if (type == instance.DTCurrency.getTypeValue()) {
            return "currency";
        }
        if (type == instance.DTSingle.getTypeValue()) {
            return "single";
        }
        if (type == instance.DTTable.getTypeValue()) {
            return "table";
        }
        if (type == instance.DTReference.getTypeValue()) {
            return "reference";
        }
        if (type == instance.DTCode.getTypeValue()) {
            return "code";
        }
        if (type == instance.DTStamp.getTypeValue()) {
            return "stamp";
        }
        if (type == instance.DTLinkTable.getTypeValue()) {
            return "linktable";
        }
        if (type == instance.DTFile.getTypeValue()) {
            return "file";
        }
        if (type == instance.DTUrl.getTypeValue()) {
            return "url";
        }
        if (type == instance.DTApproval.getTypeValue()) {
            return "approval";
        }
        if (type == instance.DTDocumentCertificate.getTypeValue()) {
            return "documentcertificate";
        }
        if (type == instance.DTDocumentStamp.getTypeValue()) {
            return "documentstamp";
        }
        return "";
    }

    private boolean isSelect(Definition definition) {
        return this.containsAttribute(definition, "APARIENCIA.DESPLEGABLE".trim()) && !this.isCode(definition);
    }

    private boolean isCode(Definition definition) {
        return definition.getTypeValue() == Metamodel.getInstance().DTCode.getTypeValue();
    }

    private boolean containsAttribute(Definition definition, String name) {
        return this.attribute(definition, name) != null;
    }

    private String attribute(Definition definition, String name) {
        return definition.getAttributes().findAttribute(name).stream().findFirst().orElse(null);
    }

    private String fieldTypeOf(Definition definition) {
        int type = definition.getTypeValue();
        Metamodel instance = Metamodel.getInstance();
        if (type == instance.DTInteger.getTypeValue()) {
            return "Number";
        }
        if (type == instance.DTSingle.getTypeValue()) {
            return "Number";
        }
        if (type == instance.DTDate.getTypeValue()) {
            return "Date";
        }
        if (type == instance.DTTime.getTypeValue()) {
            return "Date";
        }
        if (type == instance.DTDateTime.getTypeValue()) {
            return "Date";
        }
        if (type == instance.DTSignature.getTypeValue()) {
            return "Signature";
        }
        if (type == instance.DTImage.getTypeValue()) {
            return "Image";
        }
        if (type == instance.DTBoolean.getTypeValue()) {
            return "Boolean";
        }
        if (type == instance.DTCurrency.getTypeValue()) {
            return "Number";
        }
        if (type == instance.DTFile.getTypeValue()) {
            return "File";
        }
        if (type == instance.DTTable.getTypeValue()) {
            return "Table";
        }
        return "Text";
    }

    private void addToolbar(FrameBuilder result) {
        boolean hasToolbar;
        boolean bl = hasToolbar = LibraryDefinitions.isEditionSuggestion(this.definition()) || LibraryDefinitions.isEditionWithOptions(this.definition());
        if (!hasToolbar) {
            return;
        }
        result.add("withToolbar");
        result.add("toolbar", this.toolbarFrame());
    }

    private FrameBuilder toolbarFrame() {
        FrameBuilder result = this.baseFrame().add("toolbar");
        result.add(this.typeOf((Definition)this.definition()));
        this.addSearchOperation(result);
        this.addSuggestOperation(result);
        this.addClearOperation(result);
        return result;
    }

    private void addClearOperation(FrameBuilder result) {
        if (!this.isSelect((Definition)this.definition())) {
            return;
        }
        result.add("operation", this.operationFrame().add("clear"));
    }

    private void addSearchOperation(FrameBuilder result) {
        if (!LibraryDefinitions.isEditionWithOptions(this.definition())) {
            return;
        }
        result.add("operation", this.operationFrame().add("search"));
    }

    private void addSuggestOperation(FrameBuilder result) {
        if (!LibraryDefinitions.isEditionSuggestion(this.definition())) {
            return;
        }
        result.add("operation", this.operationFrame().add("suggestion"));
    }

    private FrameBuilder operationFrame() {
        Object definition = this.definition();
        FrameBuilder result = this.baseFrame().add("operation");
        result.add("type", this.fieldTypeOf((Definition)this.definition()));
        if (this.forTable()) {
            result.add("forTable");
        }
        result.add(this.typeOf((Definition)definition));
        result.add("parent", this.parent() != null ? this.nameOf(this.parent()) : null);
        result.add("name", this.nameOf((Definition)definition));
        result.add("shortName", this.shortNameOf((Definition)definition));
        result.add("drc", ((Definition)definition).getDRC());
        result.add("code", ((Definition)definition).getName());
        result.add("label", this.labelOf((Definition)definition));
        result.add("form", this.context());
        return result;
    }

    private void addStringProperties(FrameBuilder builder) {
        Object definition = this.definition();
        int type = ((Definition)definition).getTypeValue();
        Metamodel instance = Metamodel.getInstance();
        if (type != instance.DTString.getTypeValue()) {
            return;
        }
        if (this.containsAttribute((Definition)definition, "EDICION.ASPECTO".trim())) {
            builder.add("mode", this.stringMode());
        }
        if (this.hasValidation((Definition)definition)) {
            builder.add("validation", this.stringValidationFrame());
        }
    }

    private boolean hasValidation(Definition definition) {
        return this.containsAttribute(definition, "EDICION.LONGITUD".trim()) || this.containsAttribute(definition, "EDICION.FORMATO".trim());
    }

    private String stringMode() {
        String value = this.attribute((Definition)this.definition(), "EDICION.ASPECTO".trim());
        if (value.equals("1") || value.equalsIgnoreCase("mayusculas")) {
            return "Uppercase";
        }
        if (value.equals("2") || value.equalsIgnoreCase("minusculas")) {
            return "Lowercase";
        }
        return null;
    }

    private FrameBuilder stringValidationFrame() {
        FrameBuilder result = new FrameBuilder("validation");
        Object definition = this.definition();
        result.add("parent", this.parent() != null ? this.nameOf(this.parent()) : null);
        result.add("name", this.nameOf((Definition)definition));
        result.add("shortName", this.shortNameOf((Definition)definition));
        result.add("drc", ((Definition)definition).getDRC());
        result.add("code", ((Definition)definition).getName());
        result.add("label", this.labelOf((Definition)definition));
        if (this.containsAttribute((Definition)definition, "EDICION.LONGITUD".trim())) {
            result.add("length", this.attribute((Definition)definition, "EDICION.LONGITUD".trim()));
        }
        if (this.containsAttribute((Definition)definition, "EDICION.FORMATO".trim())) {
            result.add("hasPattern");
            result.add("pattern", PatternHelper.intinoPatternOf(this.attribute((Definition)definition, "EDICION.FORMATO".trim())));
        }
        return result;
    }

    private void addDateProperties(FrameBuilder builder) {
        if (!Metamodel.isDate(((Definition)this.definition()).getTypeValue())) {
            return;
        }
        builder.add("pattern", this.pattern());
        if (this.isDateTime() || this.isTime()) {
            builder.add("timePicker", "true");
        }
    }

    private void addLinkProperties(FrameBuilder builder) {
        if (((Definition)this.definition()).getTypeValue() != Metamodel.getInstance().DTReference.getTypeValue()) {
            return;
        }
        List<EntitySetColumn> entitySetColumns = LibraryDefinitions.getEntitySetColumns(this.definition());
        if (entitySetColumns.isEmpty()) {
            entitySetColumns = this.defaultEntitySetColumns();
        }
        int columnsWidth = this.width(entitySetColumns);
        Definition root = this.root();
        builder.add("root", root != null ? this.nameOf(root) : "");
        for (int i = 0; i < entitySetColumns.size(); ++i) {
            EntitySetColumn column = entitySetColumns.get(i);
            builder.add("referenceColumn", this.frameOf(column, columnsWidth, i));
        }
    }

    private void addCodeProperties(FrameBuilder builder) {
        if (!this.isCode((Definition)this.definition())) {
            return;
        }
        List<EntitySetColumn> entitySetColumns = List.of(new EntitySetColumn("CODE", -1), new EntitySetColumn("DESCRIPTION", -1));
        Definition root = this.root();
        builder.add("root", root != null ? this.nameOf(root) : "");
        for (int i = 0; i < entitySetColumns.size(); ++i) {
            EntitySetColumn column = entitySetColumns.get(i);
            builder.add("referenceColumn", this.frameOf(column, Widths.get(column.getTitle()), i).add("forCode"));
        }
    }

    private int width(List<EntitySetColumn> columns) {
        return columns.isEmpty() ? 100 : 100 / columns.size();
    }

    private List<EntitySetColumn> defaultEntitySetColumns() {
        return List.of(new EntitySetColumn("NAME", -1));
    }

    private FrameBuilder frameOf(EntitySetColumn column, int columnsWith, int index) {
        FrameBuilder result = new FrameBuilder("referenceColumn");
        Definition root = this.root();
        Definition parent = this.parent();
        String title = column.getTitle();
        result.add("label", this.labelOf(title));
        result.add("code", LibraryExpressions.trimDoubleQuotes(column.getTitle()));
        result.add("name", this.normalize(column.getTitle()));
        result.add("shortName", this.shortNameOf(this.normalize(column.getTitle())));
        result.add("type", column.getType());
        result.add("parent", (root != null ? this.nameOf(root) : "") + (parent != null ? this.nameOf(parent) : ""));
        result.add("parentDrc", ((Definition)this.definition()).getDRC());
        result.add("width", columnsWith);
        result.add("index", index);
        return result;
    }

    private String labelOf(String title) {
        return Titles.getOrDefault(title, LibraryExpressions.trimDoubleQuotes(title));
    }

    private void addAttributes(FrameBuilder builder) {
        HashMap<String, ArrayList<String>> attributeMap = ((Definition)this.definition()).getAttributes().getAll();
        attributeMap.forEach((key, value) -> builder.add(this.normalize((String)key), !value.isEmpty() ? value.get(0) : null));
    }

    private String pattern() {
        Metamodel instance = Metamodel.getInstance();
        if (instance.DTDateTime.getTypeValue() == ((Definition)this.definition()).getTypeValue()) {
            return "DD/MM/YYYY HH:mm:ss";
        }
        if (instance.DTTime.getTypeValue() == ((Definition)this.definition()).getTypeValue()) {
            return "HH:mm:ss";
        }
        return "DD/MM/YYYY";
    }

    private void writeTable(FrameBuilder builder) {
        if (!this.isTable()) {
            return;
        }
        Object definition = this.definition();
        Definition root = this.root();
        Definition parent = this.parent();
        DefinitionUtils.visibleAndSortedDefinitions(definition).forEach(d -> builder.add("field", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, (Definition)d).root(root)).parent(parent)).forTable(true)).context("form").buildFrame().add("forTable").add("table", this.nameOf((Definition)definition))));
        this.writeFrame(new File(this.javaPackage() + this.nameOf(parent) + this.nameOf((Definition)definition) + "Template.java"), this.javaTemplate().render(builder.toFrame()));
        this.writeFrame(new File(this.konosPackage() + this.nameOf(parent) + this.nameOf((Definition)definition) + ".konos"), this.konosTemplate().render(builder.toFrame()));
    }

    private boolean isTable() {
        return Metamodel.getInstance().DTTable.getTypeValue() == ((Definition)this.definition()).getTypeValue();
    }

    private boolean isDateTime() {
        return Metamodel.getInstance().DTDateTime.getTypeValue() == ((Definition)this.definition()).getTypeValue();
    }

    private boolean isTime() {
        return Metamodel.getInstance().DTTime.getTypeValue() == ((Definition)this.definition()).getTypeValue();
    }
}

