/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.egeasy.m3.definition.base.ListDefInstances;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.egeasy.renderers.Formatters;
import io.intino.goros.modernizing.egeasy.renderers.definition.SetRenderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.java.LocationTemplate;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import io.intino.itrules.Engine;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.io.File;
import java.util.List;

public class LocationRenderer
extends SetRenderer<DefInstance> {
    public LocationRenderer(TreeNodeResource dictionary, Modernization modernization, DefInstance definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        super.write();
    }

    @Override
    public FrameBuilder buildFrame() {
        DefInstance definition = (DefInstance)this.definition();
        FrameBuilder result = this.baseDefinitionFrame();
        result.add("location");
        result.add("place", this.placeOf(definition));
        result.add("icon", this.iconFrameOf(this.definitionLocated()));
        result.add("placeName", this.normalize(this.placeOf(definition)));
        result.add("content", this.contentFrame());
        this.writeDefinitions();
        return result;
    }

    private void writeDefinitions() {
        ListDefInstances definitions = this.definitionLocated().getDefinitions();
        definitions.forEach(d -> this.factory.renderer(this.dictionary, this.modernization, (Definition)d).write());
    }

    private FrameBuilder contentFrame() {
        Object definition = this.definition();
        Definition definitionLocated = this.definitionLocated();
        FrameBuilder result = this.baseFrame().add("content");
        result.add("name", this.nameOf((Definition)definition));
        result.add("label", this.labelOf((Definition)definition));
        result.add("icon", this.iconFrameOf(definitionLocated));
        List<Definition> visibleDefinitions = DefinitionUtils.sortedUiComponentDefinitions(definitionLocated.getDefinitions());
        result.add("tabsVisible", visibleDefinitions.size() != 1);
        visibleDefinitions.forEach(d -> result.add("view", this.viewFrame((Definition)d)));
        if (!visibleDefinitions.isEmpty()) {
            result.add("defaultView", this.nameOf(visibleDefinitions.get(0)));
        }
        return result;
    }

    private FrameBuilder viewFrame(Definition definition) {
        Object parent = this.definition();
        FrameBuilder result = this.baseFrame().add("view");
        result.add("name", this.nameOf(definition));
        result.add("drc", definition.getDRC());
        result.add("label", this.labelOf(definition));
        if (definition.getTypeValue() == Metamodel.getInstance().DTCollection.getTypeValue()) {
            result.add("collection");
        }
        if (definition.getTypeValue() == Metamodel.getInstance().DTCatalog.getTypeValue()) {
            result.add("catalog");
        }
        if (definition.getTypeValue() == Metamodel.getInstance().DTForm.getTypeValue()) {
            result.add("form");
        }
        if (definition.getTypeValue() == Metamodel.getInstance().DTDocument.getTypeValue()) {
            result.add("document");
        }
        result.add("konosContent", ((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).konosContent());
        result.add("konosToolbarContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("toolbar")).konosContent());
        result.add("useKonosContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("use")).konosContent());
        result.add("dirtyJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("dirty")).javaContent());
        result.add("resetJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("reset")).javaContent());
        result.add("declarationJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("declaration")).javaContent());
        result.add("initJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("init")).javaContent());
        result.add("refreshComponentJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("refreshComponent")).javaContent());
        result.add("refreshJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("refresh")).javaContent());
        result.add("focusJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)parent)).types("focus")).javaContent());
        return result;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.egeasy.renderers.templates.konos.LocationTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new LocationTemplate();
    }

    @Override
    protected void writeJava(FrameBuilder builder) {
        DefInstance definition = (DefInstance)this.definition();
        File file = new File(this.javaPackage() + StringUtil.firstUpperCase(this.normalize(this.placeOf(definition))) + this.nameOf(definition) + "Template.java");
        this.writeFrame(file, new Engine(this.javaTemplate()).addAll(Formatters.all).render(builder.toFrame()));
    }

    @Override
    protected void writeKonos(FrameBuilder builder) {
        DefInstance definition = (DefInstance)this.definition();
        File file = new File(this.konosPackage() + StringUtil.firstUpperCase(this.normalize(this.placeOf(definition))) + this.nameOf(definition) + ".konos");
        this.writeFrame(file, new Engine(this.konosTemplate()).addAll(Formatters.all).render(builder.toFrame()));
    }

    private Definition definitionLocated() {
        return ((DefinitionExtensionLocation)((DefInstance)this.definition()).getExtension()).getDefinitionLocated();
    }

    private Definition collectionDefinition(Definition definition) {
        return definition.getDefinitions().stream().filter(d -> DefinitionUtils.isCollectionDefinition(d) != false || DefinitionUtils.isCatalogDefinition(d) != false).findFirst().orElse(null);
    }

    private void write(Definition definition) {
        this.factory.renderer(this.dictionary, this.modernization, definition).write();
    }
}

