/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.expressions;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.entity.TGTypeValue;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.model.MatrixColumn;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibraryExpressions {
    private static final Pattern MatrizSqlFunctionPattern = Pattern.compile("\\$MATRIZSQL\\(\\\"([^\\\"]*)\\\"\\)", 2);
    private static final Pattern SqlFunctionPattern = Pattern.compile("\\$SQL\\(\\\"([^\\\"]*)\\\"[^\\)]*\\)", 2);

    public static Boolean isSqlExpression(String expression) {
        return LibraryExpressions.isMatrixSqlFunction(expression) || LibraryExpressions.isSqlFunction(expression);
    }

    private static boolean isSqlFunction(String expression) {
        return expression.toUpperCase().startsWith("$SQL");
    }

    private static boolean isMatrixSqlFunction(String expression) {
        return expression.toUpperCase().startsWith("$MATRIZSQL");
    }

    public static boolean isExpressionSQL(String expression) {
        return expression.toUpperCase().startsWith("SELECT ");
    }

    public static String getSqlExpression(String expression) {
        String result = expression.replace("\"\"", "@@");
        if (LibraryExpressions.isMatrixSqlFunction(result)) {
            result = LibraryExpressions.getMatrixSqlFunction(result);
        }
        if (LibraryExpressions.isSqlFunction(result)) {
            result = LibraryExpressions.getSqlFunction(result);
        }
        return result.replace("@@", "\"");
    }

    private static String getMatrixSqlFunction(String expression) {
        return LibraryExpressions.patternGroupOf(expression, MatrizSqlFunctionPattern);
    }

    private static String getSqlFunction(String expression) {
        return LibraryExpressions.patternGroupOf(expression, SqlFunctionPattern);
    }

    private static String patternGroupOf(String expression, Pattern pattern) {
        Matcher matcher = pattern.matcher(expression);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(1);
    }

    private static int FindPosRBracket(String expression, int posBegin) {
        int currentPos;
        int openBrackets = 0;
        boolean found = false;
        boolean inQuote = false;
        int size = expression.length();
        for (currentPos = posBegin; !found && currentPos < size; ++currentPos) {
            char currentChar = expression.charAt(currentPos);
            if (currentChar == '(') {
                ++openBrackets;
                continue;
            }
            if (currentChar == ')') {
                if (inQuote) continue;
                found = --openBrackets < 0;
                continue;
            }
            if (currentChar != '\"') continue;
            inQuote = !inQuote;
        }
        return found ? currentPos : -1;
    }

    private static String getColumnTitle(String column) {
        int pos = column.toUpperCase().indexOf(" AS ");
        return pos < 0 ? LibraryExpressions.trimDoubleQuotes(column.trim()) : LibraryExpressions.trimDoubleQuotes(column.substring(pos + " AS ".length()));
    }

    public static String trimDoubleQuotes(String value) {
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private static String getNextColumn(String columns) {
        int currentPos;
        int numBracket = 0;
        boolean inQuote = false;
        boolean found = false;
        block6: for (currentPos = 1; !found && currentPos < columns.length(); ++currentPos) {
            char currentChar = columns.charAt(currentPos);
            switch (currentChar) {
                case '(': {
                    ++numBracket;
                    continue block6;
                }
                case ')': {
                    --numBracket;
                    continue block6;
                }
                case '\"': {
                    inQuote = !inQuote;
                    continue block6;
                }
                case ',': {
                    found = numBracket == 0 && !inQuote;
                }
            }
        }
        return found ? columns.substring(0, currentPos - 1) : columns;
    }

    private static String getColumnName(String columnExpression) {
        int pos = columnExpression.toUpperCase().lastIndexOf(" AS ");
        String alias = null;
        if (pos >= 0) {
            alias = columnExpression.substring(pos + " AS ".length()).trim();
        } else {
            pos = (columnExpression = columnExpression.trim()).toUpperCase().lastIndexOf(" " + " AS ".trim());
            if (pos >= 0) {
                alias = columnExpression.substring(0, pos);
            } else {
                pos = columnExpression.indexOf(" ");
                if (pos >= 0) {
                    alias = columnExpression.substring(pos + 1).trim();
                }
            }
        }
        String columnName = "";
        columnName = alias == null || alias.isEmpty() ? ((pos = columnExpression.lastIndexOf(".")) == 0 ? columnExpression : columnExpression.substring(pos + 1)) : LibraryExpressions.trimDoubleQuotes(alias);
        return columnName.trim();
    }

    private static String extractColumnValue(String sqlColumns, String sqlColumnValue) {
        return (sqlColumns = sqlColumns.substring(sqlColumnValue.length()).trim()).startsWith(",") ? sqlColumns.substring(1) : sqlColumns;
    }

    public static List<MatrixColumn> getColumnsBySQL(String sql) {
        return LibraryExpressions.getSQLColumns(sql, MatrixColumn::new);
    }

    private static <T> List<T> getSQLColumns(String sql, BiFunction<String, Integer, T> columnsConsumer) {
        String sqlColumnValue;
        String sqlUpper = (sql = sql.trim()).toUpperCase();
        if (!sqlUpper.startsWith("SELECT ")) {
            return Collections.emptyList();
        }
        int posFrom = sqlUpper.indexOf(" FROM ");
        if (posFrom == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> columns = new ArrayList<T>();
        String sqlColumns = sql.substring("SELECT ".length(), posFrom);
        while (!sqlColumns.isEmpty() && (sqlColumnValue = LibraryExpressions.getNextColumn(sqlColumns)) != null) {
            sqlColumns = LibraryExpressions.extractColumnValue(sqlColumns, sqlColumnValue);
            String sqlColumnName = LibraryExpressions.getColumnName(sqlColumnValue);
            if (LibraryExpressions.isDefaultEntitySetColumn(sqlColumnName)) continue;
            columns.add(columnsConsumer.apply(sqlColumnName, LibraryExpressions.typeOf(sqlColumnName)));
        }
        return columns;
    }

    private static Integer typeOf(String sqlColumnName) {
        if (sqlColumnName.toLowerCase().startsWith("fecha") || sqlColumnName.toLowerCase().startsWith("date")) {
            return 7;
        }
        return 256;
    }

    private static boolean isDefaultEntitySetColumn(String columnName) {
        return (columnName = columnName.toUpperCase()).equals("RRC") || columnName.equals("DRC") || columnName.equals("NAME") || columnName.equals("FILE_ID");
    }

    public static String getTargetExpressionFromLinkValues(String expression) {
        int posBegin = expression.toUpperCase().indexOf("$COLECCION");
        if (posBegin < 0) {
            posBegin = expression.toUpperCase().indexOf("$MATRIZ");
            if (posBegin < 0) {
                return null;
            }
            posBegin = posBegin + "$MATRIZ".length() + 1;
        } else {
            posBegin = posBegin + "$COLECCION".length() + 1;
        }
        int posEnd = LibraryExpressions.FindPosRBracket(expression, posBegin);
        return posEnd > 0 ? expression.substring(posBegin, posEnd - 1) : null;
    }

    public static List<MatrixColumn> getEntitySetColumnsByTarget(Definition definition, String target) {
        Definition defComponent = null;
        if (LibraryExpressions.isReferencered(target)) {
            String source = LibraryExpressions.getSourceReference(target);
            String componentTarget = LibraryExpressions.getTargetReference(target);
            Definition definition2 = defComponent = LibraryExpressions.isDomainExpression(source) ? LibraryExpressions.getDomainDefinition(definition) : LibraryExpressions.findDefinitionComponent(definition, source);
            if (defComponent != null) {
                defComponent = LibraryExpressions.getTargetDefinition(defComponent, componentTarget);
            }
        } else {
            defComponent = LibraryExpressions.findDefinitionComponent(definition, target);
            if (defComponent == null) {
                String source = LibraryExpressions.getSource(target);
                String componentTarget = LibraryExpressions.getTarget(target);
                Definition defSystemObject = LibraryExpressions.findDefinitionSystemObject(source);
                if (defSystemObject != null) {
                    defComponent = LibraryExpressions.findDefinitionComponent(defSystemObject, componentTarget);
                }
            }
        }
        if (DefinitionUtils.isCollectionDefinition(defComponent).booleanValue()) {
            return LibraryExpressions.getEntitySetColumnsByCollection(defComponent);
        }
        if (DefinitionUtils.isCatalogDefinition(defComponent).booleanValue()) {
            return LibraryExpressions.getEntitySetColumnsByCatalog(defComponent);
        }
        return Collections.emptyList();
    }

    private static boolean isReferencered(String expression) {
        return expression.indexOf("->") > 0;
    }

    private static String getSourceReference(String expression) {
        int pos = expression.indexOf("->");
        return pos > 0 ? expression.substring(0, pos).trim() : null;
    }

    private static String getTargetReference(String expression) {
        int pos = expression.indexOf("->");
        return pos > 0 ? expression.substring(pos + "->".length()).trim() : null;
    }

    private static Definition findDefinitionComponent(Definition definition, String expression) {
        return LibraryDefinitions.findDefinition(expression, definition, true);
    }

    private static String getSource(String expression) {
        int pos = expression.indexOf(".");
        return pos > 0 ? expression.substring(0, pos - 1).trim() : null;
    }

    private static String getTarget(String expression) {
        int pos = expression.indexOf(".");
        return pos > 0 ? expression.substring(pos + ".".length()).trim() : null;
    }

    private static boolean isDomainExpression(String expression) {
        return LibraryExpressions.trimSquares(expression).toUpperCase().equals("&DOMINIO");
    }

    private static Definition getDomainDefinition(Definition definition) {
        Definition defContainer = LibraryExpressions.getDefContainerByDomain(definition);
        return defContainer == null ? null : LibraryExpressions.getDefinitionByAttributeCollection(defContainer);
    }

    private static Definition getDefContainerByDomain(Definition definition) {
        if (DefinitionUtils.isContainerDefinition(definition).booleanValue()) {
            return definition;
        }
        return definition instanceof DefInstance ? LibraryExpressions.getDefContainerByDomain(((DefInstance)definition).getDomain()) : null;
    }

    private static Definition getDefinitionByAttributeCollection(Definition defContainer) {
        String refCollection = defContainer.getAttributes().findAttribute("REFERENCIAS.COLECCION").stream().findFirst().orElse(null);
        int drc = refCollection != null ? Integer.parseInt(refCollection) : -1;
        return drc > 0 ? LibraryDefinitions.findDefinition(drc, Dictionary.getInstance().getDefinitions()) : null;
    }

    private static Definition findDefinitionSystemObject(String definitionName) {
        Definition defSystemObject = LibraryDefinitions.findDefinition(definitionName, Dictionary.getInstance().getDefinitions());
        return DefinitionUtils.isContainerDefinition(defSystemObject) != false ? (Definition)defSystemObject.getDefinitions().stream().filter(v -> DefinitionUtils.isCollectionDefinition(v) != false || DefinitionUtils.isCatalogDefinition(v) != false).findFirst().orElse(null) : null;
    }

    public static List<MatrixColumn> getEntitySetColumnsByCollection(Definition defComponent) {
        ArrayList<MatrixColumn> columns = new ArrayList<MatrixColumn>();
        for (Definition def : defComponent.getDefinitions()) {
            if (!DefinitionUtils.isColumnDefinition(def).booleanValue() || !def.isVisible() || !LibraryExpressions.isMainTableColumn(defComponent, def)) continue;
            String ColumnTypeValue = def.getAttributes().findAttribute("COLUMNA_BD.TIPO").stream().findFirst().orElse(null);
            int columnType = ColumnTypeValue != null ? Integer.parseInt(ColumnTypeValue) : TGTypeValue.tvUnknown;
            MatrixColumn matrixColumn = new MatrixColumn(def.getName(), LibraryExpressions.getCollectionColumnTypeValue(columnType));
            columns.add(matrixColumn);
        }
        return columns;
    }

    private static boolean isMainTableColumn(Definition collectionDefinition, Definition columnDefinition) {
        String tableName = collectionDefinition.getAttributes().findAttribute("NOMBRE_TABLA").stream().findFirst().orElse(null);
        String columnName = columnDefinition.getAttributes().findAttribute("COLUMNA_BD.NOMBRE").stream().findFirst().orElse(null);
        if (tableName == null || columnName == null || !columnName.contains(".")) {
            return true;
        }
        String prefix = columnName.substring(0, columnName.indexOf("."));
        return tableName.equalsIgnoreCase(prefix);
    }

    public static List<MatrixColumn> getEntitySetColumnsByCatalog(Definition defComponent) {
        String sql = defComponent.getAttributes().findAttribute("SENTENCIA").stream().findFirst().orElse(null);
        return sql == null || sql.isEmpty() ? null : LibraryExpressions.getColumnsBySQL(sql);
    }

    private static Definition getTargetDefinition(Definition defReference, String target) {
        if (DefinitionUtils.isFieldReferenceDefinition(defReference).booleanValue()) {
            int drcReferenced = LibraryExpressions.getReferencedDefinition(defReference);
            return drcReferenced < 0 ? null : LibraryDefinitions.findDefinition(drcReferenced, Dictionary.getInstance().getDefinitions());
        }
        if (DefinitionUtils.isContainerDefinition(defReference).booleanValue()) {
            return LibraryDefinitions.findDefinition(target, defReference, true);
        }
        if (DefinitionUtils.isCollectionDefinition(defReference).booleanValue()) {
            String definitionLabel;
            return (target = LibraryExpressions.trimSquares(target)).equals(definitionLabel = (String)defReference.getAttributes().findAttribute("ETIQUETA").stream().findFirst().orElse(null)) ? defReference : null;
        }
        return null;
    }

    private static int getReferencedDefinition(Definition defReference) {
        String linkDefinition = DefinitionUtils.getDefinitionAttributeValue(defReference, "VINCULO.DEFINICION");
        return linkDefinition != null ? Integer.parseInt(linkDefinition) : -1;
    }

    public static String trimSquares(String expression) {
        if (expression == null) {
            return null;
        }
        if (expression.startsWith("[")) {
            expression = expression.substring(1);
        }
        if (expression.endsWith("]")) {
            expression = expression.substring(0, expression.length() - 1);
        }
        return expression;
    }

    private static Integer getCollectionColumnTypeValue(int TypeValue) {
        if (TypeValue == TGTypeValue.tvString) {
            return 256;
        }
        if (TypeValue == TGTypeValue.tvDate) {
            return 7;
        }
        if (TypeValue == TGTypeValue.tvDateTime) {
            return 7;
        }
        if (TypeValue == TGTypeValue.tvReal) {
            return 5;
        }
        if (TypeValue == TGTypeValue.tvBoolean) {
            return 11;
        }
        if (TypeValue == TGTypeValue.tvInteger) {
            return 3;
        }
        if (TypeValue == TGTypeValue.tvCurrency) {
            return 6;
        }
        return 256;
    }
}

