/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.solverentity;

import io.intino.goros.egeasy.m3.entity.TGEntity;
import io.intino.goros.egeasy.m3.entity.resource.TGResource;
import io.intino.goros.egeasy.m3.library.LibraryEntity;
import io.intino.goros.egeasy.m3.solverentity.SolverEntityNexus;
import io.intino.goros.egeasy.m3.solverentity.SolverEntityPath;

public class SolverEntity {
    public static String TOKEN_THIS = "THIS";

    private static String normalizeIdentifier(String identifier) {
        if (identifier == null || identifier.equals("")) {
            return identifier;
        }
        if (identifier.startsWith("[") && !identifier.endsWith("]")) {
            return identifier.substring(2, identifier.length() - 1);
        }
        if (!identifier.startsWith("[") && identifier.endsWith("]")) {
            return identifier.substring(1, identifier.length() - 1);
        }
        return identifier;
    }

    private static SolverEntityPath getNextIdentifier(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        SolverEntityPath entityPath = new SolverEntityPath();
        entityPath.setPath(path);
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        int posEnd = 0;
        if (path.startsWith("[") && (posEnd = path.indexOf("]")) == 0) {
            posEnd = path.length() + 1;
        }
        if (posEnd == 0) {
            int posDot = path.indexOf(".");
            int posReference = path.indexOf("->");
            posEnd = posDot == 0 && posReference == 0 ? path.length() + 1 : (posReference == 0 ? posDot : (posDot == 0 ? posReference : (posDot < posReference ? posDot : posReference)));
            entityPath.setIdentifier(SolverEntity.normalizeIdentifier(path.substring(0, --posEnd)));
            entityPath.setRemainPath(path.substring(posEnd + 1));
        } else {
            entityPath.setIdentifier(path.substring(1, posEnd));
            entityPath.setRemainPath(path.substring(posEnd + 1));
        }
        return entityPath;
    }

    private static SolverEntityNexus getNextNexus(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        if (path.startsWith(".")) {
            return new SolverEntityNexus(path, ".", path.substring(1));
        }
        if (path.substring(0, 2).equals("->")) {
            return new SolverEntityNexus(path, "->", path.substring(2));
        }
        return null;
    }

    private static boolean isNexusDot(SolverEntityNexus nexus) {
        return nexus.getNexus().equals(".");
    }

    private static boolean isEmptyPath(String path) {
        return path == null || path.trim().equals("");
    }

    public static TGEntity findEntityByPath(TGResource resource, String path) {
        SolverEntityPath entityPath = SolverEntity.getNextIdentifier(path);
        if (entityPath == null) {
            return null;
        }
        if (entityPath.getIdentifier().equals(TOKEN_THIS) && (entityPath = SolverEntity.getNextIdentifier(path)) == null) {
            return null;
        }
        path = entityPath.getRemainPath();
        TGEntity entity = LibraryEntity.findEntity((TGEntity)resource, entityPath.getIdentifier());
        while (entity != null) {
            SolverEntityNexus nexus = SolverEntity.getNextNexus(path);
            if (nexus == null) {
                return null;
            }
            entityPath = SolverEntity.getNextIdentifier(nexus.getRemainPath());
            path = entityPath.getRemainPath();
            if (!SolverEntity.isNexusDot(nexus)) {
                return null;
            }
            entity = LibraryEntity.findEntity((TGEntity)resource, entityPath.getIdentifier());
            if (!SolverEntity.isEmptyPath(path)) continue;
            return entity;
        }
        return null;
    }
}

