/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.formatters;

import io.intino.itrules.Formatter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateFormatters {
    public static Map<String, Formatter> get(Locale locale) {
        HashMap<String, Formatter> map = DateFormatters.map();
        map.put("Year", DateFormatters.year(locale));
        map.put("YearMonth", DateFormatters.yearMonth(locale));
        map.put("YearMonthDay", DateFormatters.yearMonthDay(locale));
        map.put("YearMonthDayTime", DateFormatters.yearMonthDayTime(locale));
        map.put("ShortDate", DateFormatters.shortDate(locale));
        map.put("FullDate", DateFormatters.fullDate(locale));
        map.put("CompactDate", DateFormatters.compactDate(locale));
        map.put("AmericanCompactDate", DateFormatters.americanCompactDate(locale));
        map.put("AmericanDate", DateFormatters.americanDate(locale));
        map.put("DayOfWeek", DateFormatters.dayOfWeek(locale));
        map.put("Time", DateFormatters.time(locale));
        return map;
    }

    private static HashMap<String, Formatter> map() {
        return new HashMap<String, Formatter>(){

            @Override
            public Formatter put(String key, Formatter value) {
                return super.put(key.toLowerCase(), value);
            }
        };
    }

    private static Formatter year(Locale locale) {
        return value -> DateFormatters.format(value, "yyyy", locale);
    }

    private static Formatter yearMonth(Locale locale) {
        return value -> DateFormatters.format(value, "yyyyMM", locale);
    }

    private static Formatter yearMonthDay(Locale locale) {
        return value -> DateFormatters.format(value, "yyyyMMdd", locale);
    }

    private static Formatter yearMonthDayTime(Locale locale) {
        return value -> DateFormatters.format(value, "yyyyMMddhhmmss", locale);
    }

    private static Formatter shortDate(Locale locale) {
        return value -> DateFormatters.format(value, "dd/MM/yyyy", locale);
    }

    private static Formatter americanCompactDate(Locale locale) {
        return value -> DateFormatters.format(value, "MMM, dd yyyy", locale);
    }

    private static Formatter americanDate(Locale locale) {
        return value -> DateFormatters.format(value, "MMMM, dd yyyy", locale);
    }

    private static Formatter fullDate(Locale locale) {
        return value -> DateFormatters.format(value, "EEEE, dd MMMM yyyy", locale);
    }

    private static Formatter compactDate(Locale locale) {
        return value -> DateFormatters.format(value, "EEE, dd MMM yyyy", locale);
    }

    private static Formatter dayOfWeek(Locale locale) {
        return value -> DateFormatters.format(value, "EEEE", locale);
    }

    private static Formatter time(Locale locale) {
        return value -> DateFormatters.format(value, "HH:mm", locale);
    }

    private static Object format(Object value, String pattern, Locale locale) {
        return value instanceof Temporal ? DateFormatters.format((Temporal)value, pattern, locale) : value;
    }

    private static String format(Temporal value, String pattern, Locale locale) {
        return DateTimeFormatter.ofPattern(pattern).withLocale(locale).withZone(DateFormatters.zoneOf(value)).format(value);
    }

    private static ZoneId zoneOf(Temporal value) {
        return value instanceof ZonedDateTime ? ((ZonedDateTime)value).getZone() : ZoneId.systemDefault();
    }
}

