/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.util;

import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import java.util.HashMap;

public class RegistryGenerator {
    private static RegistryGenerator instance;
    private static String PACKAGE_BASE_RESOURCE;
    private static String PACKAGE_BASE_ROOM;
    private static String PACKAGE_BASE_TASK;
    private static String PACKAGE_BASE_COMPONENTS;
    private static String PACKAGE_BASE_DOCUMENTS;
    private static String PACKAGE_BASE_FIELD;
    private HashMap<Integer, String> generatedClasses = new HashMap();
    private HashMap<String, String> generatedClassesPackages = new HashMap();

    private RegistryGenerator() {
    }

    public static synchronized RegistryGenerator getInstance() {
        if (instance == null) {
            instance = new RegistryGenerator();
            instance.loadCoreClasses();
        }
        return instance;
    }

    public void register(Integer DRC, String className, String classPackage) {
        if (!this.generatedClasses.containsKey(DRC)) {
            this.generatedClasses.put(DRC, className);
        }
        if (!this.generatedClassesPackages.containsKey(className)) {
            this.generatedClassesPackages.put(className, classPackage);
        }
    }

    public String getClass(Integer DRC) {
        return this.generatedClasses.containsKey(DRC) ? this.generatedClasses.get(DRC) : null;
    }

    public String getClassPackage(String className) {
        return this.generatedClassesPackages.containsKey(className) ? this.generatedClassesPackages.get(className) : "";
    }

    private void loadCoreClasses() {
        Metamodel metamodel = Metamodel.getInstance();
        this.register(metamodel.DTContainer.getDRC(), "TGContainer", PACKAGE_BASE_RESOURCE);
        this.register(metamodel.DTRoom.getDRC(), "TGRoom", PACKAGE_BASE_ROOM);
        this.register(metamodel.DTEnumeration.getDRC(), "TGEnumeration", PACKAGE_BASE_RESOURCE);
        this.register(metamodel.DTRole.getDRC(), "TGRole", PACKAGE_BASE_RESOURCE);
        this.register(metamodel.DTTask.getDRC(), "TGTask", PACKAGE_BASE_TASK);
        this.register(metamodel.DTUser.getDRC(), "TGUser", PACKAGE_BASE_RESOURCE);
        this.register(metamodel.DTEntitySet.getDRC(), "TGEntitySet", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTCollection.getDRC(), "TGCollection", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTDocument.getDRC(), "TGDocument", PACKAGE_BASE_DOCUMENTS);
        this.register(metamodel.DTForm.getDRC(), "TGForm", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTSection.getDRC(), "TGSection", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTClassifier.getDRC(), "TGClassifier", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTCatalog.getDRC(), "TGCatalog", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTTaskSet.getDRC(), "TGTaskSet", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTVariable.getDRC(), "TGVariable", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTInventory.getDRC(), "TGInventory", PACKAGE_BASE_COMPONENTS);
        this.register(metamodel.DTLocations.getDRC(), "TGLocation", PACKAGE_BASE_ROOM);
        this.register(metamodel.DTInteger.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTDate.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTTime.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTSignature.getDRC(), "TGFieldSignature", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTImage.getDRC(), "TGFieldImage", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTCheckTable.getDRC(), "TGFieldCheckTable", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTBoolean.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTMemo.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTCurrency.getDRC(), "TGFieldCurrency", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTSingle.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTString.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTTable.getDRC(), "TGFieldTable", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTReference.getDRC(), "TGFieldReference", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTStamp.getDRC(), "TGFieldStamp", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTCode.getDRC(), "TGFieldCode", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTFile.getDRC(), "TGFieldFile", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTUrl.getDRC(), "TGFieldUrl", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTDateTime.getDRC(), "TGFieldSimple", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTApproval.getDRC(), "TGFieldApproval", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTDocumentCertificate.getDRC(), "TGFieldDocumentCertificate", PACKAGE_BASE_FIELD);
        this.register(metamodel.DTDocumentStamp.getDRC(), "TGFieldDocumentStamp", PACKAGE_BASE_FIELD);
    }

    static {
        PACKAGE_BASE_RESOURCE = "org.egeasy.core.entity.resource.";
        PACKAGE_BASE_ROOM = "org.egeasy.core.entity.room.";
        PACKAGE_BASE_TASK = "org.egeasy.core.entity.task.";
        PACKAGE_BASE_COMPONENTS = "org.egeasy.core.entity.component.";
        PACKAGE_BASE_DOCUMENTS = "org.egeasy.core.entity.document.";
        PACKAGE_BASE_FIELD = "org.egeasy.core.entity.field.";
    }
}

