/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class UITemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.allTypes("ui", "sessionLost"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class SessionLostTemplate extends AbstractSessionLostTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n\n    public SessionLostTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        box().onProviderSessionLost(session(), e -> notifySessionLost());\n        reload.onExecute(e -> logout());\n    }\n\n    private void notifySessionLost() {\n        session().logout();\n        dialog.open();\n    }\n\n    private void logout() {\n        session().logout();\n        notifier.redirect();\n    }\n}")), this.rule().condition(this.allTypes("ui", "routedispatcher"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays;\n\nimport io.intino.alexandria.ui.Soul;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.AuthenticateTemplate;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.EntitiesTemplate;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.RoomTemplate;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.AbstractRouteDispatcher;\n\npublic class RouteDispatcher extends AbstractRouteDispatcher {\n\n    @Override\n    public void dispatchHome(Soul soul) {\n    }\n\n    @Override\n    public void dispatchLogin(Soul soul) {\n    }\n\n    @Override\n    public void dispatchRoom(Soul soul, String name) {\n        soul.display(RoomTemplate.class).open(name);\n    }\n\n    @Override\n    public void dispatchLocation(Soul soul, String room, String section, String location) {\n        soul.display(RoomTemplate.class).open(room, section, location);\n    }\n\n    @Override\n    public void dispatchLocationEntity(Soul soul, String room, String section, String location, String rrc, String drc, String view) {\n        soul.display(RoomTemplate.class).open(room, section, location, drc, rrc, view);\n    }\n\n    @Override\n    public void dispatchEntity(Soul soul, String rrc, String drc, String context) {\n        soul.currentLayer(RoomTemplate.class).openEntity(drc, rrc, context);\n    }\n\n    @Override\n    public void dispatchPermissions(Soul soul) {\n    }\n\n    @Override\n    public void dispatchToken(Soul soul, String token) {\n        soul.currentLayer(AuthenticateTemplate.class).token(token);\n    }\n}")), this.rule().condition(this.allTypes("ui", "center"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.goros.egeasy.box.ui.model.Center;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Files;\n\npublic class CenterTemplate extends AbstractCenterTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Center center;\n\n    public CenterTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public Center center() {\n        return center;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n\n        if (user() == null) {\n            session().browser().add(\"callback\", session().browser().requestUrl());\n            notifier.redirect(session().browser().baseUrl() + \"/login\");\n            return;\n        }\n\n        if (box().authService() != null && box().provider(session()).sessionInfo() == null) {\n            TGSessionInfo sessionInfo = box().provider(session()).loginCAS(io.intino.goros.egeasy.provider.Provider.webToken(), username());\n            if (sessionInfo == null || sessionInfo.getSessionID() == null || sessionInfo.getSessionID().isEmpty()) {\n                notifier.redirect(session().browser().baseUrl() + \"/permissions\");\n                return;\n            }\n        }\n\n        if (!roomsIndex().exists()) {\n            if (Model.center().roomList().size() > 0 && isLocal()) redirectToFirstRoom();\n            else redirectToMenuApp();\n            return;\n        }\n\n        refresh();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshHeader();\n        refreshBlocks();\n        refreshRooms();\n    }\n\n    private void refreshHeader() {\n        headerStamp.room(null);\n        headerStamp.refresh();\n    }\n\n    private void refreshBlocks() {\n        loadingBlock.hide();\n        mainBlock.show();\n    }\n\n    private void refreshRooms() {\n        File indexFile = roomsIndex();\n        if (indexFile.exists()) refreshRoomsFromIndex(indexFile);\n        else refreshRoomsFromCenter();\n    }\n\n    private void refreshRoomsFromCenter() {\n        Center center = Model.center();\n        center.roomList().forEach(room -> fill(room, rooms.add()));\n    }\n\n    private void refreshRoomsFromIndex(File indexFile) {\n        try {\n            if (!indexFile.exists()) return;\n            Files.readAllLines(indexFile.toPath()).forEach(l -> fill(l, rooms.add()));\n        } catch (IOException e) {\n            Logger.error(e);\n        }\n    }\n\n    private void fill(Room room, RoomOptionTemplate view) {\n        view.room(room.label(), room.name(), RoomOptionTemplate.Mode.InternalLink);\n        view.refresh();\n    }\n\n    private void fill(String line, RoomOptionTemplate view) {\n        view.room(line.split(\"\\t\")[0], line.split(\"\\t\")[1], RoomOptionTemplate.Mode.ExternalLink);\n        view.refresh();\n    }\n\n    private File roomsIndex() {\n        return new File(box().configuration().home() + \"/rooms-directory.tsv\");\n    }\n\n    private boolean isLocal() {\n        return box().configuration().url().contains(\"http://localhost\");\n    }\n\n    private void redirectToFirstRoom() {\n        notifier.redirect(session().browser().baseUrl() + \"/rm/\" + Model.center().roomList().get(0).name());\n    }\n\n    private void redirectToMenuApp() {\n        String url = box().configuration().url();\n        url = url != null && url.endsWith(\"/\") ? url.substring(0, url.length()-1) : url;\n        url = url != null && url.lastIndexOf(\"/\") != -1 ? url.substring(0, url.lastIndexOf(\"/\")) : null;\n        notifier.redirect(url != null && !url.equals(\"http:/\") && !url.equals(\"https:/\") ? url : session().browser().baseUrl());\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "header"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\n\nimport java.util.LinkedHashMap;\nimport java.util.List;\nimport java.util.Map;\n\npublic class HeaderTemplate extends AbstractHeaderTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Map<String, String> variables = new LinkedHashMap<>();\n\n    public HeaderTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public HeaderTemplate room(Room room) {\n        this.room = room;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        if (box().authService() != null) user.logoutUrl(box().authService().logoutUrl());\n        user.onBeforeLogout(event -> {\n            if (box().authService() != null) box().authService().logout(null);\n            box().provider(session()).logout();\n        });\n        rooms.onExecute(e -> notifier.redirect(centerUrl()));\n        addEnvironmentVariable.onExecute(e -> addEnvironmentVariable());\n        environmentVariablesDialog.onOpen(e -> refreshEnvironmentVariablesDialog());\n        saveEnvironmentVariables.onExecute(e -> saveEnvironmentVariables());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        rooms.visible(room != null);\n        roomsSeparator.visible(room != null);\n        subtitle.value(room != null ? room.label() : \"Inicio\");\n    }\n\n    private void addEnvironmentVariable() {\n        long count = variables.keySet().stream().filter(v -> v.startsWith(\"Variable \")).count();\n        variables.put(\"Variable \" + (count+1), \"\");\n        refreshEnvironmentVariables();\n    }\n\n    private void refreshEnvironmentVariablesDialog() {\n        variables = new LinkedHashMap<>(box().provider(session()).loadUserVariables());\n        loadingEnvironmentVariables.visible(true);\n        environmentVariablesBlock.visible(false);\n        refreshEnvironmentVariables();\n        loadingEnvironmentVariables.visible(false);\n        environmentVariablesBlock.visible(true);\n    }\n\n    private void refreshEnvironmentVariables() {\n        environmentVariables.clear();\n        variables.forEach((key, value) -> fill(key, value, environmentVariables.add()));\n    }\n\n    private void fill(String variable, String value, EnvironmentVariableTemplate display) {\n        display.variable(variable, value);\n        display.onChange((key, v) -> {\n            if (!variable.equals(key)) variables.remove(variable);\n            variables.put(key, v);\n        });\n        display.onRemove(key -> {\n            variables.remove(key);\n            refreshEnvironmentVariables();\n        });\n        display.refresh();\n    }\n\n    private void saveEnvironmentVariables() {\n        environmentVariablesDialog.close();\n        boolean saved = box().provider(session()).saveUserVariables(variables);\n        if (saved) notifyUser(\"Se han actualizado las variables de entorno\", UserMessage.Type.Success);\n        else notifyUser(\"No se han podido actualizar las variables de entorno\", UserMessage.Type.Error);\n    }\n\n    private String centerUrl() {\n        String url = box().configuration().url();\n        url = url != null && url.endsWith(\"/\") ? url.substring(0, url.length()-1) : url;\n        url = url != null && url.lastIndexOf(\"/\") != -1 ? url.substring(0, url.lastIndexOf(\"/\")) : null;\n        return url != null && !url.equals(\"http:/\") && !url.equals(\"https:/\") ? url : session().browser().baseUrl();\n    }\n}")), this.rule().condition(this.allTypes("ui", "environmentVariable"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.BiConsumer;\nimport java.util.function.Consumer;\n\npublic class EnvironmentVariableTemplate extends AbstractEnvironmentVariableTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String _name;\n    private String _value;\n    private BiConsumer<String, String> changeListener;\n    private Consumer<String> removeListener;\n\n    public EnvironmentVariableTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void variable(String name, String value) {\n        this._name = name;\n        this._value = value;\n    }\n\n    public void onChange(BiConsumer<String, String> listener) {\n        this.changeListener = listener;\n    }\n\n    public void onRemove(Consumer<String> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        name.onChange(e -> changeListener.accept(e.value(), value.value()));\n        value.onChange(e -> changeListener.accept(name.value(), e.value()));\n        remove.onExecute(e -> removeListener.accept(name.value()));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        name.value(_name);\n        value.value(_value);\n    }\n}")), this.rule().condition(this.allTypes("ui", "roomOption"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class RoomOptionTemplate extends AbstractRoomOptionTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String label;\n    private String link;\n    private Mode mode;\n\n    public RoomOptionTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public enum Mode { ExternalLink, InternalLink }\n    public RoomOptionTemplate room(String label, String link, Mode mode) {\n        this.label = label;\n        this.link = link;\n        this.mode = mode;\n        return this;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshSite();\n        refreshPage();\n    }\n\n    private void refreshSite() {\n        site.visible(mode == Mode.ExternalLink);\n        if (mode != Mode.ExternalLink) return;\n        site.title(label);\n        site.site(link);\n    }\n\n    private void refreshPage() {\n        page.visible(mode == Mode.InternalLink);\n        if (mode != Mode.InternalLink) return;\n        page.title(label);\n        page.path(\"/rm/\" + link);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "roomSection"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.net.URL;\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class RoomSectionTemplate extends AbstractRoomSectionTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Section section;\n    private Consumer<String> selectLocationListener;\n\n    public RoomSectionTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public RoomSectionTemplate room(Room room) {\n        this.room = room;\n        return this;\n    }\n\n    public RoomSectionTemplate section(Section section) {\n        this.section = section;\n        return this;\n    }\n\n    public RoomSectionTemplate onSelectLocation(Consumer<String> listener) {\n        this.selectLocationListener = listener;\n        return this;\n    }\n\n    public void showItems() {\n        itemsBlock.visible(true);\n    }\n\n    public void hideItems() {\n        itemsBlock.visible(false);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        label.value(section.label());\n        icon.value(iconUrl());\n        refreshLocations();\n    }\n\n    private void refreshLocations() {\n        List<Location> locations = section.locations();\n        refreshFirstLocation(locations);\n        section.locations().forEach(location -> fill(location, items.add()));\n    }\n\n    private void refreshFirstLocation(List<Location> locations) {\n        Location firstLocation = !locations.isEmpty() ? locations.get(0) : null;\n        if (firstLocation == null) return;\n        labelLink.address(path -> path.replace(\":name\", StringUtil.encode(room.name())).replace(\":section\", StringUtil.encode(section.label())).replace(\":location\", StringUtil.encode(firstLocation.name())));\n    }\n\n    private URL iconUrl() {\n        return section.icon();\n    }\n\n    private void fill(Location location, RoomSectionItemTemplate view) {\n        view.room(room);\n        view.section(section);\n        view.location(location);\n        view.onSelect(e -> selectLocationListener.accept(location.label()));\n        view.refresh();\n    }\n}")), this.rule().condition(this.allTypes("ui", "roomSectionItem"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class RoomSectionItemTemplate extends AbstractRoomSectionItemTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Section section;\n    private Location location;\n    private Consumer<Location> selectListener;\n\n    public RoomSectionItemTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public RoomSectionItemTemplate room(Room room) {\n        this.room = room;\n        return this;\n    }\n\n    public RoomSectionItemTemplate section(Section section) {\n        this.section = section;\n        return this;\n    }\n\n    public RoomSectionItemTemplate location(Location location) {\n        this.location = location;\n        return this;\n    }\n\n    public RoomSectionItemTemplate onSelect(Consumer<Location> listener) {\n        selectListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        label.onExecute(e -> selectListener.accept(location));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        label.address(path -> path.replace(\":name\", StringUtil.encode(room.name())).replace(\":section\", StringUtil.encode(section.label().toLowerCase())).replace(\":location\", StringUtil.encode(location.name().toLowerCase())));\n        label.title(location.label());\n    }\n}")), this.rule().condition(this.allTypes("ui", "authenticate"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.commands.ege.EgeCommands;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class AuthenticateTemplate extends AbstractAuthenticateTemplate<")).output(this.mark("boxName", "firstUperCase")).output(this.literal("Box> {\n    private String token;\n\n    public AuthenticateTemplate(")).output(this.mark("boxName", "firstUperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void token(String token) {\n        this.token = token;\n        refresh();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        logoutButton.onExecute(e -> {\n            session().logout();\n            box().provider(session()).logout();\n            if (box().authService() != null) box().authService().logout(null);\n            String redirectUrl = box().authService() != null ? box().authService().logoutUrl() : session().browser().requestUrl();\n            notifier.redirect(redirectUrl);\n        });\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n\n        username.value(username() != null ? \"Sesi\u00f3n iniciada en el Gobierno de Canarias como \" + username() : null);\n        logoutButton.visible(user() != null);\n\n        if (!box().commands(EgeCommands.class).isValid(box().provider(session()), token)) {\n            loadingLayer.visible(false);\n            successBlock.visible(false);\n            failureBlock.visible(true);\n            failureMessage.value(\"Token inv\u00e1lido\");\n            closeBlock.visible(true);\n            return;\n        }\n\n        if (user() == null) {\n            session().browser().add(\"callback\", session().browser().requestUrl());\n            notifier.redirect(session().browser().baseUrl() + \"/login\");\n            return;\n        }\n\n        successBlock.visible(false);\n        failureBlock.visible(false);\n        closeBlock.visible(false);\n\n        TGSessionInfo session = box().commands(EgeCommands.class).notifyLogin(box().provider(session()), user(), token);\n        boolean logged = session != null && session.getSessionID() != null && !session.getSessionID().isEmpty();\n        loadingLayer.visible(false);\n        successBlock.visible(logged);\n        if (logged) successMessage.value(\"Sesi\u00f3n iniciada correctamente con el usuario \" + username());\n        failureBlock.visible(!logged);\n        if (!logged) failureMessage.value(session != null ? session.getErrorMessage() : \"Se ha producido un error al iniciar la sesi\u00f3n en ")).output(this.mark("title", new String[0])).output(this.literal("\");\n        closeBlock.visible(true);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "login"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.services.push.User;\nimport org.apache.commons.io.IOUtils;\n\nimport io.intino.goros.egeasy.box.ui.model.Center;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\n\nimport java.io.IOException;\nimport java.nio.charset.StandardCharsets;\nimport java.util.Timer;\nimport java.util.TimerTask;\n\npublic class LoginTemplate extends AbstractLoginTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String selectedUsername;\n    private String selectedPassword;\n    private Timer loginTimer = null;\n\n    private static final String Styles = \"<style>table { border-spacing: 0; margin-bottom: 20px; width: 80%; } th, td { padding: 5px; text-align: center } th { background: #145b9f; color: white } .e { background: #f1f1f1; } .r { text-align: right; }</style>\";\n\n    public LoginTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        Center center = Model.center();\n        title.value(center.label());\n        loginButton.onExecute(e -> login());\n        initIntro(center);\n        initUsernameField();\n        initPasswordField();\n    }\n\n    private void initIntro(Center center) {\n        introPage.content(introContent(center));\n        introPage.refresh();\n    }\n\n    private String introContent(Center center) {\n        try {\n            String content = Styles + IOUtils.toString(LoginTemplate.class.getResourceAsStream(\"/home.html\"), StandardCharsets.UTF_8);\n            return content.replace(\"{label}\", center.label());\n        } catch (IOException e) {\n            Logger.error(e);\n            return \"\";\n        }\n    }\n\n    private void login() {\n        if (loginTimer != null) loginTimer.cancel();\n        loginTimer = new Timer();\n        loginTimer.schedule(new TimerTask() {\n            @Override\n            public void run() {\n                error.value(\"\");\n\n                if (selectedUsername == null) {\n                    error.value(\"Indique un nombre de usuario v\u00e1lido\");\n                    return;\n                }\n\n                if (selectedPassword == null) {\n                    error.value(\"Indique una contrase\u00f1a v\u00e1lida\");\n                    return;\n                }\n\n                try {\n                    loginButton.title(\"Iniciando sesi\u00f3n...\");\n                    loginButton.readonly(true);\n                    TGSessionInfo session = box().provider(session()).loginLDAP(selectedUsername, selectedPassword);\n                    if (session == null) {\n                        error.value(\"Error al iniciar sesi\u00f3n. Compruebe su nombre de usuario y/o contrase\u00f1a.\");\n                        loginButton.title(\"Iniciar sesi\u00f3n\");\n                        loginButton.readonly(false);\n                        return;\n                    }\n                    session().user(new User().username(selectedUsername).fullName(session.getFullName()));\n                    redirect();\n                } catch (Exception e) {\n                    error.value(\"Error al iniciar sesi\u00f3n. Contacte con el administrador\");\n                    loginButton.title(\"Iniciar sesi\u00f3n\");\n                    loginButton.readonly(false);\n                }\n\n            }\n        }, 100);\n    }\n\n    private void initUsernameField() {\n        username.onChange(event -> selectedUsername = event.value());\n        username.onEnterPress(event -> {\n            selectedUsername = event.value();\n            login();\n        });\n    }\n\n    private void initPasswordField() {\n        password.onChange(event -> selectedPassword = event.value());\n        password.onEnterPress(event -> {\n            selectedPassword = event.value();\n            login();\n        });\n    }\n\n    private void redirect() {\n        String callback = session().browser().preference(\"callback\");\n        notifier.redirect(callback != null ? callback : session().browser().baseUrl());\n        session().browser().add(\"callback\", null);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "entities"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.EntitySetItemContainer;\nimport io.intino.goros.egeasy.box.ui.datasources.EntitySetDatasource;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.Set;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class EntitiesTemplate extends AbstractEntitiesTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements EntitySetItemContainer {\n    private TGRoom room;\n    private String roomName;\n    private String section;\n    private String location;\n    private TGResource entity;\n    private String backTitle;\n    private Function<String, String> backAddressResolver;\n    private Consumer<EntitySetItem> backListener;\n    private Consumer<EntitySetItem> removeListener;\n    private boolean readonly = true;\n    private String view = null;\n\n    public static final Set<Integer> Entities = Set.of(")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "drcDeclaration").multiple(","))).output(this.literal(");\n\n    public EntitiesTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void backInfo(String title, Function<String, String> addressResolver, Consumer<EntitySetItem> listener) {\n        this.backTitle = title;\n        this.backAddressResolver = addressResolver;\n        this.backListener = listener;\n    }\n\n    @Override\n    public void onRemove(Consumer<EntitySetItem> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void onDirty(Consumer<Boolean> listener) {\n    }\n\n    @Override\n    public void room(TGRoom room, String roomName) {\n        this.room = room;\n        this.roomName = roomName;\n    }\n\n    @Override\n    public void section(String section) {\n        this.section = section;\n    }\n\n    @Override\n    public void location(String location) {\n        this.location = location;\n    }\n\n    @Override\n    public EntitySetItem entity() {\n        return entity != null ? EntitySetDatasource.itemOf(entity) : null;\n    }\n\n    @Override\n    public void entity(EntitySetItem entity) {\n        if (this.entity != null && this.entity.getERC() == entity.rrc() && this.entity.getDRC() == entity.drc()) return;\n        this.entity = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    }\n\n    public void entity(TGResource entity) {\n        this.entity = entity;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void selectView(String view) {\n        this.view = view;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "selectView").multiple("\n"))).output(this.literal("\n    }\n\n    public void view(String view) {\n        this.view = view;\n    }\n\n    public void open(TGResource entity) {\n        this.entity = entity;\n        refresh();\n    }\n\n    public boolean dirty() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return false;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "dirty").multiple("\n"))).output(this.literal("\n        return false;\n    }\n\n    public void openSaveDialog(Consumer<Boolean> listener) {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "openSaveDialog").multiple("\n"))).output(this.literal("\n    }\n\n    public io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult silentSave() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return null;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "silentSave").multiple("\n"))).output(this.literal("\n        return ValidateResult.empty();\n    }\n\n    public io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult save() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return null;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "save").multiple("\n"))).output(this.literal("\n        return ValidateResult.empty();\n    }\n\n    public void forceSave() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "forceSave").multiple("\n"))).output(this.literal("\n    }\n\n    public void showValidationErrors(ValidateResult errors) {\n        int drc = entity != null ? entity.getDRC() : -1;\n        if (drc == -1) return;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "validateErrors").multiple("\n"))).output(this.literal("\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "init").multiple("\n"))).output(this.literal("\n        task.onShow(e -> {\n            task.taskStamp.clear();\n            TaskTemplate template = task.taskStamp.add();\n            template.task((TGTask) entity);\n            template.refresh();\n        });\n    }\n\n    @Override\n    public void refresh() {\n        int drc = entity != null ? entity.getDRC() : -1;\n        notFound.hide();\n        task.hide();\n        if (drc == -1) {\n            notFound.show();\n            return;\n        }\n        refreshEntity(drc);\n    }\n\n    private void hideEntities() {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "hide").multiple("\n"))).output(this.literal("\n    }\n\n    private void refreshEntity(int drc) {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("entity", "refresh").multiple("\n"))).output(this.literal("\n        hideEntities();\n        if (!task.isVisible()) task.show();\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "room"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.Display;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\n\nimport io.intino.alexandria.ui.services.push.User;\nimport io.intino.goros.egeasy.box.ui.EntitySetItemContainer;\nimport io.intino.goros.egeasy.box.ui.model.Room;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.box.ui.RoomSectionContainer;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.TaskTemplate;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.HashMap;\nimport java.util.function.Consumer;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.stream.Collectors;\n\npublic class RoomTemplate extends AbstractRoomTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Room room;\n    private Section selectedSection;\n    private Location location;\n    private TGResource entity;\n    private TGResource addedProcess;\n    private List<TaskSetItem> availableTaskSet;\n    private TaskSetItem selectedTask;\n    private BlockConditional current = null;\n    private boolean readonly = true;\n    private Object context;\n    private Consumer<EntitySetItem> removeListener;\n    private Consumer<Boolean> finishProcessListener;\n    private User finishEditionSender;\n    private EntitySetItem finishEditionEntity;\n    private Consumer<Boolean> finishEditionCallback;\n\n    public RoomTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n\n        if (user() == null) {\n            session().browser().add(\"callback\", session().browser().requestUrl());\n            notifier.redirect(session().browser().baseUrl() + \"/login\");\n            return;\n        }\n\n        if (box().authService() != null && box().provider(session()).sessionInfo() == null) {\n            TGSessionInfo sessionInfo = box().provider(session()).loginCAS(io.intino.goros.egeasy.provider.Provider.webToken(), username());\n            if (sessionInfo == null || sessionInfo.getSessionID() == null || sessionInfo.getSessionID().isEmpty()) {\n                notifier.redirect(session().browser().baseUrl() + \"/permissions\");\n                return;\n            }\n        }\n\n        initDrawer();\n        entityLayerTrigger.onOpen(e -> fillLayer(e.layer()));\n        selectTask.onExecute(e -> startTask());\n        taskSelector.onSelect(e -> selectTask.readonly(e.selection().isEmpty()));\n        taskSelectorDialog.onOpen(e -> refreshTaskSelectorDialog());\n        contextBlock.onShow(e -> refreshTaskContext());\n        taskStarterStamp.onStarted(e -> refreshTaskStarted());\n        finishEditionDialog.onOpen(e -> refreshFinishEditionDialog());\n        acceptFinishEdition.onExecute(e -> acceptFinishEdition());\n        rejectFinishEdition.onExecute(e -> rejectFinishEdition());\n    }\n\n    public void open(String name) {\n        room = Model.room(name);\n        if (user() == null) return;\n        if (room == null || io.intino.goros.egeasy.box.ProviderHelper.room(room.drc(), box().provider(session())) == null) {\n            notifier.redirect(session().browser().baseUrl() + \"/permissions\");\n            return;\n        }\n        refresh();\n    }\n\n    public void open(String room, String section, String location) {\n        open(room, section, location, true);\n    }\n\n    public boolean isEmbedded() {\n        return soul().currentLayer() != null;\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    public void open(String room, String section, String location, String drc, String rrc, String view) {\n        if (this.location == null || !location.equals(this.location.name())) open(room, section, location, false);\n        if (current == null) return;\n        current.children().stream().filter(c -> c instanceof RoomSectionContainer).forEach(c -> ((RoomSectionContainer)c).open(selectedSection, this.location, Integer.parseInt(drc), Integer.parseInt(rrc), view));\n    }\n\n    public void openEntity(String drc, String rrc, String context) {\n        this.room = null;\n        this.selectedSection = null;\n        this.location = null;\n        this.entity = box().provider(session()).openResource(java.lang.Integer.parseInt(rrc), java.lang.Integer.parseInt(drc));\n        this.context = load(context);\n        this.removeListener = removeListener != null ? removeListener : e -> notifier.redirect();\n        refresh();\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onRemove(Consumer<EntitySetItem> listener) {\n        this.removeListener = listener;\n    }\n\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        if (!entities.dirty()) {\n            if (entity != null) box().provider(session()).endEditionResource(entity.getERC());\n            return true;\n        }\n        entities.openSaveDialog(saveListener);\n        return false;\n    }\n\n    private static final Map<String, Map<Integer, String>> processMap = new HashMap<>() {{\n        ")).output(this.mark("room", "processes").multiple("\n")).output(this.literal("\n    }};\n    private void initDrawer() {\n        drawer.open();\n        drawer.onToggle(this::toggleSections);\n        addProcess.onExecute(e -> addProcess(e.option()));\n    }\n\n    public void addProcess(String label, Integer drc, Integer sourceErc, Consumer<Boolean> listener) {\n        finishProcessListener = listener;\n        if (drc == null || drc == -1) {\n            notifyUser(\"No se ha podido crear el proceso\", UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(String.format(\"Creando proceso '%s'\", label.toLowerCase()), UserMessage.Type.Loading);\n        addedProcess = box().provider(session()).createProcess(drc, sourceErc != null ? sourceErc : io.intino.goros.egeasy.m3.constant.Constants.kNullERC);\n        if (addedProcess == null) {\n            notifyUser(\"No se ha podido crear el proceso\", UserMessage.Type.Error);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(addedProcess.getERC());\n        availableTaskSet = set != null ? TaskSetDatasource.itemsOf(set) : Collections.emptyList();\n        notifyUser(\"Proceso creado\", UserMessage.Type.Success);\n        if (availableTaskSet.isEmpty()) {\n            TGTask addedTask = (TGTask) addedProcess;\n            entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(addedTask.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(((TGTask) addedProcess).getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(addedTask));\n            entityLayerTrigger.openLayer();\n            return;\n        }\n        if (availableTaskSet.size() == 1) {\n            startTask(availableTaskSet.get(0));\n            return;\n        }\n        taskSelectorDialog.open();\n    }\n\n    private void addProcess(String option) {\n        addProcess(option, DisplayHelper.processDRCOf(processMap.get(room.name()), option), null, null);\n    }\n\n    private void startTask() {\n        List<String> selection = taskSelector.selection();\n        if (selection.isEmpty()) {\n            notifyUser(\"Debe seleccionar una tarea\", UserMessage.Type.Warning);\n            return;\n        }\n        String selected = selection.get(0);\n        startTask(availableTaskSet.stream().filter(t -> t.name().equals(selected)).findFirst().orElse(null));\n    }\n\n    private void startTask(TaskSetItem task) {\n        if (task == null) {\n            notifyUser(\"No se ha podido abrir la tarea\", UserMessage.Type.Error);\n            return;\n        }\n        selectedTask = task;\n        taskStarterStamp.task((TGTask) box().provider(session()).openResource(selectedTask.rrc(), selectedTask.drc()));\n        taskStarterStamp.start();\n    }\n\n    private void refreshTaskStarted() {\n        TGTask task = (TGTask) box().provider(session()).openResource(selectedTask.rrc(), selectedTask.drc());\n        entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(selectedTask));\n        entityLayerTrigger.openLayer();\n    }\n\n    private void refreshTaskSelectorDialog() {\n        taskSelector.clear();\n        taskSelector.addAll(availableTaskSet.stream().map(TaskSetItem::name).collect(Collectors.toList()));\n    }\n\n    private void fillLayer(Layer<?, ?> layer) {\n        EntitySetItem entity = selectedTask.relatedObject();\n        RoomTemplate template = new RoomTemplate(box());\n        template.readonly(false);\n        layer.title(entity.name());\n        layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n        layer.onClose(e -> {\n            if (finishProcessListener != null) finishProcessListener.accept(true);\n        });\n        layer.template(template);\n    }\n\n    private void toggleSections(ToggleEvent event) {\n        if (event.state() == ToggleEvent.State.On) showSections();\n        else hideSections();\n    }\n\n    private void showSections() {\n        addProcess.visible(true);\n        developedBy.visible(true);\n        headerBlock.show();\n        sections.children().forEach(child -> ((RoomSectionTemplate) child).showItems());\n    }\n\n    private void hideSections() {\n        addProcess.visible(false);\n        developedBy.visible(false);\n        headerBlock.hide();\n        sections.children().forEach(child -> ((RoomSectionTemplate)child).hideItems());\n    }\n\n    private Object load(String context) {\n        if (StringUtil.isTask(context)) return box().provider(session()).openResource(StringUtil.erc(context), StringUtil.drc(context));\n        return null;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshDrawer();\n        refreshLayers();\n        refreshRoom();\n        io.intino.alexandria.ui.utils.DelayerUtil.execute(this, d -> refreshContext(), 0);\n        refreshEntity();\n    }\n\n    private void refreshDrawer() {\n        List<String> options = room != null ? new ArrayList<>(processMap.getOrDefault(room.name(), new HashMap<>()).values()) : Collections.emptyList();\n        addProcess.options(options);\n        addProcess.visible(!options.isEmpty());\n        toolbar.visible(!options.isEmpty());\n    }\n\n    private void refreshRoom() {\n        if (room == null) return;\n        refreshHeader();\n        if (sections.children().isEmpty()) room.sectionList().forEach(s -> fill(s, sections.add()));\n        if (selectedSection != null) open(selectedSection, location);\n        else openFirstSection();\n    }\n\n    private void refreshContext() {\n        contextBlock.visible(context != null);\n    }\n\n    private void refreshTaskContext() {\n        if (!(context instanceof TGTask)) return;\n        taskStamp.clear();\n        TaskTemplate template = taskStamp.add();\n        template.task((TGTask) context);\n        template.onBeforeFinish(c -> entities.silentSave());\n        template.onBeforeContinueWithWarnings(c -> entities.forceSave());\n        template.onValidationErrors(errors -> entities.showValidationErrors(errors));\n        template.mode(TaskTemplate.Mode.Summary);\n        template.refresh();\n    }\n\n    private void refreshEntity() {\n        boolean readonly = this.readonly && (entity == null || !box().provider(session()).isEditingResource(entity.getERC()));\n        entities.onRemove(removeListener);\n        entities.readonly(readonly && context == null);\n        entities.open(entity);\n    }\n\n    private void refreshHeader() {\n        headerStamp.room(room);\n        headerStamp.refresh();\n    }\n\n    private void refreshLayers() {\n        boolean existsRoom = room != null && habitacion() != null;\n        notFoundBlock.visible(!existsRoom && entity == null);\n        mainBlock.visible(existsRoom);\n        loadingBlock.visible(false);\n        entitiesBlock.visible(entity != null);\n    }\n\n    private void fill(Section section, RoomSectionTemplate view) {\n        view.room(room);\n        view.section(section);\n        //view.onSelectLocation(location -> open(section, location));\n        view.refresh();\n    }\n\n    private void openFirstSection() {\n        if (room.sectionList().size() <= 0) return;\n        Section section = room.sectionList().get(0);\n        Location location = section.locations().get(0);\n        open(section, location);\n    }\n\n    private boolean checkRoomSectionDirty(String room, String section, String location) {\n        if (current == null) return true;\n        return current.children().stream().filter(c -> c instanceof RoomSectionContainer).anyMatch(c -> ((RoomSectionContainer) c).checkDirty(e -> open(room, section, location, true)));\n    }\n\n    private void open(String room, String section, String location, boolean checkDirty) {\n        if (checkDirty && !checkRoomSectionDirty(room, section, location)) return;\n        if (this.room != null && this.room.name().equals(StringUtil.decode(room)) && equalsSection(StringUtil.decode(section)) && this.location != null && this.location.name().equals(StringUtil.decode(location))) {\n            if (current != null) current.children().stream().filter(c -> c instanceof RoomSectionContainer).forEach(c -> ((RoomSectionContainer)c).back());\n            return;\n        }\n        this.room = Model.room(StringUtil.decode(room));\n        this.selectedSection = sectionOf(StringUtil.decode(section));\n        this.location = this.selectedSection.location(StringUtil.decode(location));\n        this.entity = null;\n        if (user() == null) return;\n        refresh();\n    }\n\n    private void open(Section section, String location) {\n        open(section, section.location(location));\n    }\n\n    private void open(Section section, Location location) {\n        if (current != null) current.hide();\n        current = (BlockConditional<?,?>) habitacion();\n        notFoundBlock.visible(current == null);\n        if (current != null) {\n            current.show();\n            current.children().stream().filter(c -> c instanceof RoomSectionContainer).forEach(c -> ((RoomSectionContainer)c).open(section, location));\n        }\n    }\n\n    private Display habitacion() {\n        return habitaciones.children().stream().filter(h -> h.name().toLowerCase().equals(room.name())).findFirst().orElse(null);\n    }\n\n    private Section sectionOf(String section) {\n        return room.sectionList().stream().filter(s -> s.label().equalsIgnoreCase(section) || DisplayHelper.normalize(s.label()).toLowerCase().equalsIgnoreCase(section)).findFirst().orElse(null);\n    }\n\n    private boolean equalsSection(String key) {\n        return selectedSection != null && (selectedSection.label().equalsIgnoreCase(key) || DisplayHelper.normalize(selectedSection.label()).toLowerCase().equalsIgnoreCase(key));\n    }\n\n    public void requestEdition(EntitySetItem entity, User sender, Consumer<Boolean> callback) {\n        this.finishEditionSender = sender;\n        this.finishEditionEntity = entity;\n        this.finishEditionCallback = callback;\n        finishEditionDialog.open();\n    }\n\n    private void refreshFinishEditionDialog() {\n        finishEditionMessage.value(String.format(\"%s solicita la edici\u00f3n de %s. \u00bfDesea liberar el elemento?\", finishEditionSender.fullName(), finishEditionEntity.name()));\n    }\n\n    private void acceptFinishEdition() {\n        finishEditionDialog.close();\n        if (finishEditionCallback == null) return;\n        box().provider(session()).endEditionResource(finishEditionEntity.rrc());\n        endEditionMode();\n        releaseRelatedTasks();\n        finishEditionCallback.accept(true);\n    }\n\n    private void endEditionMode() {\n        List<Display> displays = soul().getAll().stream().filter(d -> d instanceof EntitySetItemContainer && ((EntitySetItemContainer)d).entity() != null && ((EntitySetItemContainer)d).entity().rrc() == finishEditionEntity.rrc()).distinct().collect(Collectors.toList());\n        displays.forEach(this::endEditionMode);\n    }\n\n    private void endEditionMode(Display<?, ?> display) {\n        ((EntitySetItemContainer) display).readonly(true);\n        display.refresh();\n    }\n\n    private void releaseRelatedTasks() {\n        List<RoomTemplate> displays = soul().displays(RoomTemplate.class).stream().distinct().collect(Collectors.toList());\n        displays.forEach(this::releaseRelatedTasks);\n    }\n\n    private void releaseRelatedTasks(RoomTemplate room) {\n        if (!(room.context instanceof TGTask)) return;\n        TGTask task = (TGTask) room.context;\n        if (task.getTargetIdentifier() == null || task.getTargetIdentifier().getERC() != finishEditionEntity.rrc())\n            return;\n        box().provider(session()).stopWorkingTask(task.getERC(), task.getDRC());\n        room.context = box().provider(session()).openResource(task.getERC(), task.getDRC());\n        room.refreshTaskContext();\n    }\n\n    private void rejectFinishEdition() {\n        finishEditionDialog.close();\n        if (finishEditionCallback == null) return;\n        finishEditionCallback.accept(false);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "fileFieldEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.File;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class FileFieldEditor extends AbstractFileFieldEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String title;\n    private Consumer<Object> changeListener;\n    private boolean readonly = true;\n    private Field field;\n    private File value;\n\n    public FileFieldEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public FileFieldEditor title(String title) {\n        this.title = title;\n        return this;\n    }\n\n    public FileFieldEditor field(Field field) {\n        this.field = field;\n        return this;\n    }\n\n    public FileFieldEditor value(File value) {\n        this.value = value;\n        return this;\n    }\n\n    public FileFieldEditor readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public FileFieldEditor focus() {\n        if (localFileBlock.isVisible()) localFileBlock.localFile.focus();\n        if (ndeBlock.isVisible()) ndeBlock.nde.focus();\n        return this;\n    }\n\n    public FileFieldEditor onChange(Consumer<Object> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        initEditionBlock();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshReadonlyBlock();\n        refreshEditionBlock();\n    }\n\n    private void refreshReadonlyBlock() {\n        titleReadonly.value(this.title);\n        readonlyBlock.visible(readonly);\n        file.value(value);\n        file.readonly(true);\n    }\n\n    private void refreshEditionBlock() {\n        titleEdition.value(this.title);\n        editionBlock.visible(!readonly);\n        editionBlock.originSelector.select(\"fromLocalFile\");\n    }\n\n    private void initEditionBlock() {\n        localFileBlock.onInit(e -> initLocalFileBlock());\n        localFileBlock.onShow(e -> refreshLocalFileBlock());\n        ndeBlock.onInit(e -> initNdeBlock());\n        ndeBlock.onShow(e -> refreshNdeBlock());\n    }\n\n    private void initLocalFileBlock() {\n        localFileBlock.localFile.onChange(e -> changeListener.accept(e.value()));\n    }\n\n    private void refreshLocalFileBlock() {\n        localFileBlock.localFile.value(value);\n    }\n\n    private void initNdeBlock() {\n        ndeBlock.nde.onChange(e -> changeListener.accept(e.value()));\n    }\n\n    private void refreshNdeBlock() {\n        io.intino.goros.egeasy.m3.file.File value = this.field.asFile();\n        ndeBlock.nde.value(value != null ? value.getPlatinoNDE() : null);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "signFieldEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.SignDocument.BeforeSignChecker;\nimport io.intino.alexandria.ui.displays.events.AddItemEvent;\nimport io.intino.alexandria.ui.services.push.User;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.UserListDatasource;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport io.intino.goros.egeasy.box.ui.model.Signature;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.rows.CandidateSelectorListRow;\n\nimport java.io.InputStream;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class SignFieldEditor extends AbstractSignFieldEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String _title;\n    private Field field;\n    private List<User> candidateList;\n    private Consumer<Signature> changeListener;\n    private Consumer<String> signListener;\n    private boolean readonly = true;\n    private boolean allowSign = true;\n    private Function<Field, InputStream> documentProvider;\n    private BeforeSignChecker beforeSignChecker;\n\n    public SignFieldEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public SignFieldEditor title(String title) {\n        this._title = title;\n        return this;\n    }\n\n    public SignFieldEditor field(Field field) {\n        this.field = field;\n        return this;\n    }\n\n    public SignFieldEditor beforeSignChecker(BeforeSignChecker checker) {\n        this.beforeSignChecker = checker;\n        return this;\n    }\n\n    public SignFieldEditor documentProvider(Function<Field, InputStream> documentProvider) {\n        this.documentProvider = documentProvider;\n        return this;\n    }\n\n    public SignFieldEditor readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public SignFieldEditor focus() {\n        candidateSelector.focus();\n        return this;\n    }\n\n    public SignFieldEditor candidates(List<User> candidateList) {\n        this.candidateList = candidateList;\n        return this;\n    }\n\n    public SignFieldEditor onChange(Consumer<Signature> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    public SignFieldEditor onSign(Consumer<String> listener) {\n        this.signListener = listener;\n        return this;\n    }\n\n    public SignFieldEditor allowSign(boolean value) {\n        this.allowSign = value;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        candidateSelector.onSelect(e -> updateCandidate(e.selection()));\n        candidateSelector.valueProvider(user -> user instanceof String ? (String)user : ((User)user).fullName());\n        candidateSelector.candidateSelectorList.onAddItem(this::refreshUserListItem);\n        sign.beforeSignChecker(beforeSignChecker);\n        sign.onSign(e -> signListener.accept(e.signature()));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(this._title);\n        Signature signature = field != null ? field.asSignature() : null;\n        refreshSignedBlock(signature);\n        refreshNotSignedBlock(signature);\n    }\n\n    private void refreshSignedBlock(Signature signature) {\n        boolean signed = isSigned(signature);\n        signedBlock.visible(signed);\n        if (!signed) return;\n        signer.value(signature.signer());\n        signDate.value(signature.signDate());\n    }\n\n    private void refreshNotSignedBlock(Signature signature) {\n        boolean signed = isSigned(signature);\n        String id = signature != null ? signature.id() : null;\n        notSignedBlock.visible(signature == null || !signature.isSigned());\n        if (signed) return;\n        candidateSelector.candidateSelectorList.source(new UserListDatasource(box().provider(session()), session(), candidateList));\n        if (signature != null && signature.candidate() != null) candidateSelector.selection(labelOf(signature.candidate()));\n        else candidateSelector.selection(new ArrayList<>());\n        candidateSelector.readonly(readonly || field.readonly());\n        refreshSignButton(signature);\n    }\n\n    private void refreshSignButton(Signature signature) {\n        String id = signature != null ? signature.id() : null;\n        User candidate = signature != null ? signature.candidate() : null;\n        if (id != null) sign.documentProvider(() -> documentProvider.apply(field));\n        sign.readonly(readonly || field.readonly());\n        sign.visible(false/*allowSign && id != null && candidate != null && DisplayHelper.canSign(candidate, session())*/);\n    }\n\n    private String labelOf(User user) {\n        return user.fullName() + \" (\" + user.username() + \")\";\n    }\n\n    private boolean isSigned(Signature signature) {\n        return signature != null && signature.isSigned();\n    }\n\n    private void updateCandidate(List<User> selection) {\n        Signature signature = field.asSignature();\n        refreshSignButton(signature);\n        if (signature == null) return;\n        signature.candidate(!selection.isEmpty() ? selection.get(0) : null);\n        changeListener.accept(signature);\n    }\n\n    private void refreshUserListItem(AddItemEvent event) {\n        User user = event.item();\n        CandidateSelectorListRow row = event.component();\n        row.candidateSelectorListFullNameView.fullName.value(user.fullName());\n        row.candidateSelectorListUsernameView.username.value(user.username());\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "checkTableFieldEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.editable.Editable;\nimport io.intino.alexandria.ui.displays.events.ChangeEvent;\nimport io.intino.alexandria.ui.displays.events.ChangeListener;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;\nimport io.intino.goros.egeasy.box.ui.datasources.CheckTableDatasource;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport io.intino.goros.egeasy.m3.entity.component.TGForm;\nimport io.intino.goros.egeasy.m3.entity.field.TGCheckItem;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class CheckTableFieldEditor extends AbstractCheckTableFieldEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements Editable<DisplayNotifier, ")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String _title;\n    private TGForm form;\n    private Field field;\n    private CheckTableDatasource source;\n    private boolean readonly;\n    private ChangeListener changeListener;\n    private Consumer<Field> suggestListener;\n\n    public CheckTableFieldEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void title(String title) {\n        this._title = title;\n    }\n\n    public void form(TGForm form) {\n        this.form = form;\n        reloadSource();\n    }\n\n    public void field(Field field) {\n        this.field = field;\n        reloadSource();\n    }\n\n    @Override\n    public boolean readonly() {\n        return readonly;\n    }\n\n    public CheckTableFieldEditor readonly(boolean readonly) {\n        this.readonly = readonly;\n        refresh();\n        return this;\n    }\n\n    @Override\n    public CheckTableFieldEditor onChange(ChangeListener listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    public CheckTableFieldEditor onSuggest(Consumer<Field> listener) {\n        this.suggestListener = listener;\n        return this;\n    }\n\n    @Override\n    public void reload() {\n        refresh();\n    }\n\n    @Override\n    public CheckTableFieldEditor focus() {\n        optionField.focus();\n        return this;\n    }\n\n    public boolean dirty() {\n        return source.dirty();\n    }\n\n    public void reset() {\n        source.reset();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        optionField.onEnterPress(e -> {\n            String value = e.value();\n            if (value != null && !value.isEmpty()) addOption();\n        });\n        optionField.onChange(e -> addOption.visible(e.value() != null && !((String)e.value()).isEmpty()));\n        suggest.onExecute(e -> suggestListener.accept(field));\n        addOption.onExecute(e -> addOption());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(_title);\n        List<TGCheckItem> items = source.items();\n        optionField.readonly(readonly);\n        addOption.readonly(readonly);\n        suggest.visible(suggestListener != null);\n        if (suggest.visible()) suggest.readonly(readonly);\n        options.clear();\n        items.forEach(i -> fill(i, options.add()));\n    }\n\n    private void fill(TGCheckItem checkItem, CheckTableFieldItemEditor display) {\n        display.check(checkItem);\n        display.readonly(readonly);\n        display.onChange(e -> changeListener.accept(new ChangeEvent(this, field.asCheckTable())));\n        display.onRemove(e -> {\n            source.remove(checkItem);\n            changeListener.accept(new ChangeEvent(this, field.asCheckTable()));\n            refresh();\n        });\n        display.refresh();\n    }\n\n    private void reloadSource() {\n        if (form == null || field == null) return;\n        source = new CheckTableDatasource(box().provider(session()), session(), form, field.asCheckTable());\n    }\n\n    private void addOption() {\n        TGCheckItem item = new TGCheckItem();\n        item.setChecked(true);\n        item.setSubject(optionField.value());\n        source.add(item);\n        changeListener.accept(new ChangeEvent(this, field.asCheckTable()));\n        optionField.value(null);\n        refresh();\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "checkTableFieldItemEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.m3.entity.field.TGCheckItem;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class CheckTableFieldItemEditor extends AbstractCheckTableFieldItemEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private TGCheckItem check;\n    private Consumer<TGCheckItem> changeListener;\n    private Consumer<TGCheckItem> removeListener;\n    private boolean readonly;\n\n    public CheckTableFieldItemEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void check(TGCheckItem check) {\n        this.check = check;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onChange(Consumer<TGCheckItem> listener) {\n        this.changeListener = listener;\n    }\n\n    public void onRemove(Consumer<TGCheckItem> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        optionSelector.onSelect(e -> updateChecked(e.selection()));\n        removeOption.onExecute(e -> removeListener.accept(check));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        optionSelector.readonly(readonly);\n        removeOption.readonly(readonly);\n        optionSelector.clear();\n        optionSelector.add(check.getSubject());\n        optionSelector.selection(check.isChecked() ? List.of(check.getSubject()) : Collections.emptyList());\n    }\n\n    private void updateChecked(List<String> selection) {\n        check.setChecked(!selection.isEmpty());\n        changeListener.accept(check);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "containerDocument"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.MimeTypes;\nimport io.intino.alexandria.Resource;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.File;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.alexandria.ui.spark.UIFile;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.CreateFileFromTemplateResult;\nimport io.intino.goros.egeasy.m3.entity.component.TGComponent;\nimport io.intino.goros.egeasy.m3.entity.document.TGDocument;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.io.ByteArrayInputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.util.UUID;\n\npublic class ContainerDocumentTemplate extends AbstractContainerDocumentTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private TGResource container;\n    private TGComponent component;\n    private boolean readonly = true;\n    private boolean dirty = false;\n    private final String defaultFilename;\n\n    public ContainerDocumentTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n        defaultFilename = UUID.randomUUID() + \".odt\";\n    }\n\n    public ContainerDocumentTemplate container(TGResource container) {\n        this.container = container;\n        return this;\n    }\n\n    public ContainerDocumentTemplate component(TGComponent component) {\n        this.component = component;\n        return this;\n    }\n\n    public ContainerDocumentTemplate readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public boolean dirty() {\n        return this.dirty;\n    }\n\n    public void setContainerTitle(String value) {\n        container.setName(value);\n        dirty = true;\n    }\n\n    public void save() {\n        if (!dirty) return;\n        box().provider(session()).saveResource(container, false);\n        dirty = false;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        editDocumentWizard.onDownload(v -> downloadDocument());\n        editDocumentWizard.onSave(this::replaceDocument);\n        editDocumentWizard.triggerLabel(\"Editar documento\");\n        editDocumentWizard.mode(DocumentWizard.Mode.Icon);\n        addDocumentWizard.onDownload(v -> downloadDocument());\n        addDocumentWizard.onSave(this::replaceDocument);\n        addDocumentWizard.triggerLabel(\"")).output(this.expression(new Rule.Output[0]).output(this.literal("a\u00f1adir"))).output(this.literal("\");\n        addDocumentWizard.mode(DocumentWizard.Mode.Link);\n        createDocumentFromTemplate.onExecute(e -> restoreTemplate());\n        restoreTemplate.onExecute(e -> restoreTemplate());\n        openWorkDocument.onExecute(e -> openWorkDocument());\n        certifyCopy.beforeSignChecker(() -> true);\n        certifyCopy.onSign(e -> certifyCopy(e.signature()));\n        signatureBoxSwitch.state(ToggleEvent.State.On);\n        signatureBoxSwitch.onToggle(e -> refreshPreview(file()));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        File file = file();\n        editDocumentWizard.readonly(readonly || !LibraryDocuments.isEditableDocument((TGContainer) container));\n        editDocumentWizard.triggerLabel(editDocumentWizard.readonly() ? \"Descargar\" : \"Editar documento\");\n        editDocumentWizard.visible(file != null);\n        editDocumentWizard.refresh();\n        addDocumentWizard.readonly(readonly || !LibraryDocuments.isEditableDocument((TGContainer) container));\n        addDocumentWizard.triggerLabel(addDocumentWizard.readonly() ? \"descargar\" : \"a\u00f1adir\");\n        addDocumentWizard.visible(file != null);\n        addDocumentWizard.refresh();\n        createDocumentFromTemplate.readonly(readonly || !LibraryDocuments.canCreateFromTemplate((TGContainer) container));\n        openWorkDocument.readonly(component == null || !LibraryDocuments.isOpenableWorkDocument((TGContainer) container));\n        restoreTemplate.readonly(!DisplayHelper.isOdt((TGDocument) component));\n        certifyCopy.document(file != null ? file.value() : null);\n        certifyCopy.readonly(!LibraryDocuments.canSaveEE03Signature((TGContainer) container));\n        toggleDocumentDialog();\n        refreshPreview(file);\n    }\n\n    private void toggleDocumentDialog() {\n        if (readonly && editDocumentWizard.isVisible()) editDocumentWizard.close();\n        else if (!readonly && !editDocumentWizard.isVisible()) editDocumentWizard.open();\n    }\n\n    private UIFile downloadDocument() {\n        return new UIFile() {\n            @Override\n            public String label() {\n                return filename();\n            }\n\n            @Override\n            public InputStream content() {\n                try {\n                    return box().provider(session()).openDocumentFile(container, component.getDRC(), signatureBoxSwitch.state() == ToggleEvent.State.On);\n                } catch (Exception e) {\n                    return new ByteArrayInputStream(new byte[0]);\n                }\n            }\n        };\n    }\n\n    private void replaceDocument(Resource document) {\n        try {\n            box().provider(session()).saveDocumentFile(container.getERC(), container.getDRC(), component.getDRC(), document.name(), document.stream());\n            refreshPreview(file());\n        } catch (IOException e) {\n            Logger.error(e);\n        }\n    }\n\n    private void refreshPreview(File file) {\n        loadingBlock.visible(true);\n        previewBlock.visible(false);\n        noPreviewBlock.visible(false);\n        preview.value(file);\n        loadingBlock.visible(false);\n        previewBlock.visible(file != null);\n        noPreviewBlock.visible(file == null);\n    }\n\n    private File file() {\n        TGDocument document = (TGDocument) component;\n        if (document == null) return null;\n        String filename = filename();\n        int fileId = document.getIdFile();\n        return new File().filename(filename).value(FileHelper.urlOf(container.getERC(), container.getDRC(), component.getDRC(), -1, fileId, io.intino.goros.egeasy.m3.file.File.Type.Document, filename, signatureBoxSwitch.state() == ToggleEvent.State.On, session())).mimeType(MimeTypes.contentTypeOf(DisplayHelper.extensionOf(filename)));\n    }\n\n    private String filename() {\n        String filename = ((TGDocument)component).getFileName();\n        return filename != null && !filename.isEmpty() ? filename : defaultFilename;\n    }\n\n    private void restoreTemplate() {\n        notifyUser(\"Restaurando plantilla. Por favor, espere...\", UserMessage.Type.Loading);\n        CreateFileFromTemplateResult result = box().provider(session()).createFileFromTemplate(container.getERC(), container.getDRC(), component.getDRC());\n        if (!result.isSuccess()) {\n            notifyUser(\"No se pudo restaurar la plantilla\", UserMessage.Type.Error);\n            return;\n        }\n        updateDocument(result);\n        notifyUser(\"Plantilla restaurada\", UserMessage.Type.Success);\n        refresh();\n    }\n\n    private void updateDocument(CreateFileFromTemplateResult result) {\n        TGDocument document = (TGDocument) component;\n        document.setFileName(result.getFilename());\n        document.setIdFile(result.getFileId());\n        dirty = true;\n    }\n\n    private UIFile openWorkDocument() {\n        InputStream inputStream = box().provider(session()).openWorkDocumentFile(container.getERC(), container.getDRC(), component.getDRC());\n        return DisplayHelper.uiFileOf(component.getERC() + \".odt\", inputStream);\n    }\n\n    private void certifyCopy(String signature) {\n        if (!box().provider(session()).saveDocumentCopyEE03(container.getERC(), container.getDRC(), component.getDRC(), signature)) {\n            notifyUser(\"No se ha podido certificar la copia aut\u00e9ntica\", UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(\"Copia aut\u00e9ntica certificada\", UserMessage.Type.Success);\n        refreshPreview(file());\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "documentWizard"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.Resource;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.spark.UIFile;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class DocumentWizard extends AbstractDocumentWizard<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String triggerLabel;\n    private Mode mode;\n    private boolean readonly;\n    private Resource newDocumentResource = null;\n    private Consumer<Resource> saveListener;\n    private Function<Boolean, UIFile> downloadListener;\n\n    public enum Mode { Icon, Link, Button }\n\n    public DocumentWizard(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void triggerLabel(String label) {\n        this.triggerLabel = label;\n    }\n\n    public void mode(Mode mode) {\n        this.mode = mode;\n    }\n\n    public boolean readonly() {\n        return readonly;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onDownload(Function<Boolean, UIFile> listener) {\n        this.downloadListener = listener;\n    }\n\n    public void onSave(Consumer<Resource> listener) {\n        this.saveListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        uploadDialog.onOpen(e -> {\n            save.readonly(true);\n            newDocumentResource = null;\n        });\n        downloadIconTrigger.onExecute( e-> downloadDocument());\n        downloadLinkTrigger.onExecute( e-> downloadDocument());\n        downloadButtonTrigger.onExecute( e-> downloadDocument());\n        newDocument.onChange(e -> updateNewDocument(e.value()));\n        save.onExecute(e -> save());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        iconTrigger.visible(mode == Mode.Icon && !readonly);\n        if (iconTrigger.isVisible()) iconTrigger.title(triggerLabel);\n        linkTrigger.visible(mode == Mode.Link && !readonly);\n        if (linkTrigger.isVisible()) linkTrigger.title(triggerLabel);\n        buttonTrigger.visible(mode == Mode.Button && !readonly);\n        if (buttonTrigger.isVisible()) buttonTrigger.title(triggerLabel);\n        downloadIconTrigger.visible(mode == Mode.Icon);\n        if (downloadIconTrigger.isVisible()) downloadIconTrigger.title(triggerLabel);\n        downloadLinkTrigger.visible(mode == Mode.Link);\n        if (downloadLinkTrigger.isVisible()) downloadLinkTrigger.title(triggerLabel);\n        downloadButtonTrigger.visible(mode == Mode.Button);\n        if (downloadButtonTrigger.isVisible()) downloadButtonTrigger.title(triggerLabel);\n    }\n\n    @Override\n    public boolean isVisible() {\n        return uploadDialog.isVisible();\n    }\n\n    public void open() {\n        uploadDialog.open();\n    }\n\n    public void close() {\n        uploadDialog.close();\n    }\n\n    private UIFile downloadDocument() {\n        if (!readonly && !uploadDialog.isVisible()) open();\n        return downloadListener.apply(true);\n    }\n\n    private void updateNewDocument(Resource value) {\n        this.newDocumentResource = value;\n        save.readonly(false);\n    }\n\n    private void save() {\n        uploadDialog.close();\n        saveListener.accept(newDocumentResource);\n        uploadDialog.notifyUser(translate(\"Document saved successfully\"), UserMessage.Type.Success);\n    }\n\n}")), this.rule().condition(this.allTypes("entity", "task"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal(".onShow(e -> {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.entity(entity);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.readonly(readonly);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n});")), this.rule().condition(this.type("entity"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal(".onShow(e -> {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onRemove(removeListener);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onDirty(dirty -> canClose(!dirty));\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.backInfo(backTitle, backAddressResolver, backListener);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.room(room, roomName);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.section(section);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.location(location);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.entity(EntitySetDatasource.itemOf(entity));\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.view(view);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.readonly(readonly);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n});")), this.rule().condition(this.allTypes("ui", "permissions"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class PermissionsTemplate extends AbstractPermissionsTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n\n    public PermissionsTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        homeLink.onExecute(e -> notifier.redirect(centerUrl()));\n        logoutButton.onExecute(e -> {\n            session().logout();\n            if (box().authService() != null) box().authService().logout(null);\n            box().provider(session()).logout();\n            notifier.redirect(box().authService() != null ? box().authService().logoutUrl() : session().browser().baseUrl() + \"/login\");\n        });\n        refresh();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        TGSessionInfo sessionInfo = box().provider(session()).loginCAS(io.intino.goros.egeasy.provider.Provider.webToken(), username());\n        description.value(sessionInfo.getErrorMessage());\n    }\n\n    private String centerUrl() {\n        String url = box().configuration().url();\n        url = url != null && url.endsWith(\"/\") ? url.substring(0, url.length()-1) : url;\n        url = url != null && url.lastIndexOf(\"/\") != -1 ? url.substring(0, url.lastIndexOf(\"/\")) : null;\n        return url != null && !url.equals(\"http:/\") && !url.equals(\"https:/\") ? url : session().browser().baseUrl();\n    }\n}")), this.rule().condition(this.allTypes("ui", "setFilterListEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class SetFilterListEditor extends AbstractSetFilterListEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private List<GridColumn<?>> columns;\n    private Map<String, SetFilter> filters = new HashMap<>();\n    private Consumer<SetFilter> addListener;\n    private Consumer<SetFilter> removeListener;\n    private Consumer<SetFilter> filterListener;\n    private SetFilter selectedFilter;\n\n    private static final String NoFilters = \"Todos los elementos\";\n    private static final String AddFilter = \"Filtrar elementos...\";\n    private static final String EditFilters = \"Editar filtros...\";\n\n    public SetFilterListEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public SetFilterListEditor taskColumns(List<GridColumn<TaskSetItem>> columns) {\n        return columns(columns.stream().map(c -> (GridColumn<?>)c).collect(Collectors.toList()));\n    }\n\n    public SetFilterListEditor entityColumns(List<GridColumn<EntitySetItem>> columns) {\n        return columns(columns.stream().map(c -> (GridColumn<?>)c).collect(Collectors.toList()));\n    }\n\n    public SetFilterListEditor columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n        filterEditor.columns(columns);\n        return this;\n    }\n\n    public SetFilterListEditor filters(Map<String, SetFilter> filters) {\n        this.filters = filters;\n        return this;\n    }\n\n    public SetFilterListEditor onAdd(Consumer<SetFilter> listener) {\n        this.addListener = listener;\n        return this;\n    }\n\n    public SetFilterListEditor onRemove(Consumer<SetFilter> listener) {\n        this.removeListener = listener;\n        return this;\n    }\n\n    public SetFilterListEditor onFilter(Consumer<SetFilter> listener) {\n        this.filterListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        filterSelector.onSelect(this::filter);\n        initAddFilterDialog();\n        initEditFiltersDialog();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshFilterSelector();\n    }\n\n    private void initAddFilterDialog() {\n        addFilter.onExecute(e -> addFilter());\n        addFilterDialog.onOpen(e -> refreshAddFilterDialog());\n    }\n\n    private void refreshAddFilterDialog() {\n        SetFilter filter = new SetFilter().title(\"Sin nombre\");\n        filterEditor.filter(filter);\n        filterEditor.refresh();\n    }\n\n    private void initEditFiltersDialog() {\n        editFiltersDialog.onOpen(e -> refreshEditFiltersDialog());\n        editFiltersDialog.onClose(e -> refreshFilterSelector());\n    }\n\n    private void refreshEditFiltersDialog() {\n        refreshFilterList();\n    }\n\n    private void refreshFilterSelector() {\n        filterSelector.clear();\n        filterSelector.add(NoFilters);\n        filterSelector.addAll(filters.keySet().toArray(new String[0]));\n        filterSelector.add(AddFilter);\n        if (!filters.isEmpty()) filterSelector.add(EditFilters);\n        if (selectedFilter != null) filterSelector.selection(selectedFilter.title());\n        else filterSelector.selection(NoFilters);\n    }\n\n    private void refreshFilterList() {\n        filterList.clear();\n        filters.values().forEach(f -> fill(f, filterList.add()));\n    }\n\n    private void fill(SetFilter filter, SetFilterItem display) {\n        display.columns(columns);\n        display.filter(filter);\n        display.onChange(f -> saveFilter(filter, f));\n        display.onRemove(f -> removeFilter(filter));\n        display.refresh();\n    }\n\n    private void saveFilter(SetFilter filter, SetFilter newFilter) {\n        addListener.accept(newFilter);\n        filters.put(newFilter.title(), newFilter);\n        if (filter.title().equals(newFilter.title())) return;\n        removeFilter(filter);\n        refreshFilterSelector();\n    }\n\n    private void addFilter() {\n        SetFilter filter = filterEditor.filter();\n        if (filter == null || filter.title() == null || filter.title().isEmpty()) {\n            notifyUser(\"Indique un nombre para el filtro\", UserMessage.Type.Warning);\n            return;\n        }\n        if (!filter.valid()) {\n            notifyUser(\"Indique una expresi\u00f3n v\u00e1lida\", UserMessage.Type.Warning);\n            return;\n        }\n        addFilterDialog.close();\n        addListener.accept(filter);\n        filters.put(filter.title(), filter);\n        filter(filter);\n        refreshFilterSelector();\n    }\n\n    private void removeFilter(SetFilter filter) {\n        removeListener.accept(filter);\n        filters.remove(filter.title());\n        if (selectedFilter != null && filter.title().equals(selectedFilter.title())) filter((String) null);\n        refreshFilterList();\n    }\n\n    private void filter(SelectionEvent e) {\n        List<String> selection = e.selection();\n        String filterName = !selection.isEmpty() ? selection.get(0) : null;\n        if (AddFilter.equals(filterName)) addFilterDialog.open();\n        else if (EditFilters.equals(filterName)) editFiltersDialog.open();\n        else if (NoFilters.equals(filterName)) doNotFilter();\n        else filter(filterName);\n    }\n\n    private void filter(String filterName) {\n        filter(filterName != null ? filterOf(filterName) : null);\n    }\n\n    private void filter(SetFilter filter) {\n        selectedFilter = filter;\n        filterListener.accept(filter);\n    }\n\n    private void doNotFilter() {\n        filter((String) null);\n    }\n\n    private SetFilter filterOf(String filter) {\n        return filters.getOrDefault(filter, null);\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "setFilterItem"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class SetFilterItem extends AbstractSetFilterItem<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private List<GridColumn<?>> columns;\n    private SetFilter filter;\n    private Consumer<SetFilter> changeListener;\n    private Consumer<SetFilter> removeListener;\n\n    public SetFilterItem(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n    }\n\n    public SetFilterItem filter(SetFilter filter) {\n        this.filter = filter;\n        return this;\n    }\n\n    public SetFilterItem onChange(Consumer<SetFilter> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    public SetFilterItem onRemove(Consumer<SetFilter> listener) {\n        this.removeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        remove.onExecute(e -> removeListener.accept(filter));\n        editFilterDialog.onOpen(e -> refreshEditFilterDialog());\n        saveFilter.onExecute(e -> saveFilter());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        name.value(filter.title());\n        expression.value(filter.expression());\n    }\n\n    private void refreshEditFilterDialog() {\n        editFilterDialog.title(\"Editar \" + filter.title());\n        filterEditor.columns(columns);\n        filterEditor.filter(new SetFilter().title(filter.title()).expression(filter.expression()));\n        filterEditor.refresh();\n    }\n\n    private void saveFilter() {\n        filter = filterEditor.filter();\n        if (filter == null || filter.title() == null || filter.title().isEmpty()) {\n            notifyUser(\"Indique un nombre para el filtro\", UserMessage.Type.Warning);\n            return;\n        }\n        if (!filter.valid()) {\n            notifyUser(\"Indique una expresi\u00f3n v\u00e1lida\", UserMessage.Type.Warning);\n            return;\n        }\n        refresh();\n        editFilterDialog.close();\n        changeListener.accept(filter);\n    }\n\n}")), this.rule().condition(this.type("setFilterEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.model.Sentence;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.List;\n\npublic class SetFilterEditor extends AbstractSetFilterEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private SetFilter filter;\n    private List<GridColumn<?>> columns;\n\n    public SetFilterEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public SetFilterEditor columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n        return this;\n    }\n\n    public SetFilter filter() {\n        if (!simpleEditor.isVisible() || !filter.isAdvanced()) return filter;\n        filter.expression(simpleEditor.simpleSentenceEditor.sentence().toString());\n        return filter;\n    }\n\n    public SetFilterEditor filter(SetFilter filter) {\n        this.filter = filter;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        title.onChange(e -> filter.title(e.value()));\n        title.onEnterPress(e -> filter.title(e.value()));\n        simpleEditor.onInit(e -> initSimpleEditor());\n        simpleEditor.onShow(e -> refreshSimpleEditor());\n        advancedEditor.onInit(e -> initAdvancedEditor());\n        advancedEditor.onShow(e -> refreshAdvancedEditor());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(filter.title());\n        if (filter.isAdvanced()) filterTypeSelector.select(\"advancedOption\");\n        else filterTypeSelector.select(\"simpleOption\");\n    }\n\n    private void initSimpleEditor() {\n        simpleSentenceEditor.onChange(this::updateExpressionFromSimple);\n    }\n\n    private void refreshSimpleEditor() {\n        simpleSentenceEditor.sentence(filter.simpleSentence());\n        simpleSentenceEditor.columns(columns);\n        simpleSentenceEditor.refresh();\n    }\n\n    private void initAdvancedEditor() {\n        advancedEditor.expression.onChange(e -> updateExpressionFromAdvanced());\n        advancedEditor.expression.onEnterPress(e -> updateExpressionFromAdvanced());\n        advancedSentenceEditor.onChange(sentence -> insertSentence.readonly(sentence == null));\n        insertSentence.onExecute(e -> addSentence());\n    }\n\n    private void refreshAdvancedEditor() {\n        advancedEditor.expression.value(filter.expression());\n        advancedSentenceEditor.sentence(null);\n        advancedSentenceEditor.columns(columns);\n        advancedSentenceEditor.refresh();\n    }\n\n    private void updateExpressionFromSimple(Sentence sentence) {\n        filter.expression(sentence != null ? sentence.toString() : null);\n    }\n\n    private void updateExpressionFromAdvanced() {\n        String value = advancedEditor.expression.value();\n        if (value == null || value.isEmpty()) value = null;\n        filter.expression(value);\n    }\n\n    private void addSentence() {\n        Sentence sentence = advancedSentenceEditor.sentence();\n        String expression = filter.expression();\n        if (expression != null && !expression.isEmpty()) expression += \" Y \";\n        filter.expression((expression != null ? expression : \"\") + sentence.toString());\n        refreshAdvancedEditor();\n    }\n\n}")), this.rule().condition(this.type("setFilterSentenceEditor"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.model.Sentence;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.Arrays;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class SetFilterSentenceEditor extends AbstractSetFilterSentenceEditor<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Sentence sentence;\n    private List<GridColumn<?>> columns;\n    private Consumer<Sentence> changeListener;\n\n    public SetFilterSentenceEditor(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public Sentence sentence() {\n        return sentence;\n    }\n\n    public SetFilterSentenceEditor sentence(Sentence sentence) {\n        this.sentence = sentence;\n        return this;\n    }\n\n    public SetFilterSentenceEditor columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n        columnSelector.clear();\n        columnSelector.addAll(columns.stream().map(GridColumn::label).collect(Collectors.toList()));\n        columnSelector.selection(Collections.emptyList());\n        return this;\n    }\n\n    public SetFilterSentenceEditor onChange(Consumer<Sentence> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        columnSelector.onSelect(e -> notifyChange());\n        operatorSelector.addAll(Arrays.stream(Sentence.Operator.values()).map(Sentence.Operator::label).collect(Collectors.toList()));\n        operatorSelector.onSelect(e -> notifyChange());\n        valueField.onChange(e -> notifyChange());\n        valueField.onEnterPress(e -> notifyChange());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        if (sentence != null) columnSelector.selection(sentence.column());\n        else columnSelector.selection();\n        if (sentence != null) operatorSelector.selection(sentence.operator().label());\n        else operatorSelector.selection(Sentence.Operator.Contains.label());\n        valueField.value(sentence != null ? sentence.value() : null);\n    }\n\n    private void notifyChange() {\n        boolean empty = columnSelector.selection().isEmpty() || operatorSelector.selection().isEmpty();\n        updateSentence(!empty ? new Sentence(column().label(), operator(), value()) : null);\n    }\n\n    private void updateSentence(Sentence sentence) {\n        this.sentence = sentence;\n        if (changeListener != null) changeListener.accept(sentence);\n    }\n\n    private GridColumn<?> column() {\n        String column = columnSelector.selection().get(0);\n        return columns.stream().filter(c -> c.name().equals(column) || c.label().equals(column)).findFirst().orElse(null);\n    }\n\n    private Sentence.Operator operator() {\n        return Sentence.Operator.from(operatorSelector.selection().get(0));\n    }\n\n    private String value() {\n        String value = valueField.value();\n        return value != null ? value : \"\";\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "exportWizard"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.spark.UIFile;\nimport io.intino.alexandria.ui.utils.DelayerUtil;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.EntitysetExportMode;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ExportFilesResult;\nimport io.intino.goros.egeasy.m3.entity.TGEntity;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.util.function.Function;\n\npublic class ExportWizard extends AbstractExportWizard<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String filename;\n    private TGEntity entity;\n    private Mode mode;\n    private Operation operation;\n    private Function<String, ExportFilesResult> exportFileListener;\n    private Function<EntitysetExportMode, InputStream> exportSetListener;\n    private boolean readonly;\n    private UIFile file;\n\n    public enum Mode { Set, File }\n    public enum Operation { Set, File }\n\n    private static final String ExportSetTypeOption = \"csvSemicolonOption\";\n\n    public ExportWizard(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void filename(String filename) {\n        this.filename = filename;\n    }\n\n    public void entity(TGEntity entity) {\n        this.entity = entity;\n    }\n\n    public void mode(Mode mode) {\n        this.mode = mode;\n        refresh();\n    }\n\n    public void onExportFile(Function<String, ExportFilesResult> listener) {\n        this.exportFileListener = listener;\n    }\n\n    public void onExportSet(Function<EntitysetExportMode, InputStream> listener) {\n        this.exportSetListener = listener;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        exportListTrigger.onOpen(e -> refreshExportDialog(Operation.Set));\n        exportContentTrigger.onOpen(e -> {\n            refreshExportDialog(Operation.File);\n            export();\n        });\n        export.onExecute(e -> export());\n        download.onExecute(e -> download());\n        exportDialog.onOpen(e -> refreshExportDialog());\n        exportSetTypeSelector.onSelect(e -> clearDownload());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        exportListTrigger.readonly(mode != Mode.Set);\n        exportContentTrigger.readonly(mode != Mode.File);\n    }\n\n    private void refreshExportDialog(Operation operation) {\n        this.operation = operation;\n        refreshExportDialog();\n    }\n\n    private void refreshExportDialog() {\n        if (operation == null) return;\n        clearDownload();\n        exportSetTypeSelector.visible(operation == Operation.Set);\n        exportSetTypeSelector.selection(ExportSetTypeOption);\n        export.readonly(readonly);\n    }\n\n    private void export() {\n        export.title(\"Exportando...\");\n        export.readonly(true);\n        showGeneratingFile();\n        DelayerUtil.execute(this, e -> {\n            file = operation == Operation.File ? exportFile() : exportSet();\n            showFileGenerated();\n            export.title(\"Volver a exportar\");\n            export.readonly(false);\n        });\n    }\n\n    private UIFile download() {\n        try {\n            file.content().reset();\n            return file;\n        } catch (IOException e) {\n            Logger.error(e);\n            return file;\n        }\n    }\n\n    private void clearDownload() {\n        file = null;\n        generatingBlock.visible(false);\n        generatedBlock.visible(false);\n        errorBlock.visible(false);\n        closeTrigger.title(\"Cerrar\");\n    }\n\n    private void showGeneratingFile() {\n        generatingBlock.visible(true);\n        generatedBlock.visible(false);\n        errorBlock.visible(false);\n        closeTrigger.title(\"Cancelar\");\n    }\n\n    private void showFileGenerated() {\n        generatingBlock.visible(false);\n        generatedBlock.visible(file != null);\n        errorBlock.visible(file == null);\n        closeTrigger.title(\"Cerrar\");\n    }\n\n    private UIFile exportFile() {\n        ExportFilesResult result = exportFileListener.apply(filename + exportFileExtension());\n        if (result == null || result.getFileCount() == 0) return null;\n        return DisplayHelper.uiFileOf(filename + exportFileExtension(), result.getContent());\n    }\n\n    private UIFile exportSet() {\n        String selectedType = !exportSetTypeSelector.selection().isEmpty() ? exportSetTypeSelector.selection().get(0) : ExportSetTypeOption;\n        InputStream result = exportSetListener.apply(exportMode(selectedType));\n        return result != null ? DisplayHelper.uiFileOf(filename + exportSetExtension(), result) : null;\n    }\n\n    private EntitysetExportMode exportMode(String selectedType) {\n        if (selectedType.equals(\"csvSemicolonOption\")) return EntitysetExportMode.SEMICOLON_SEPARATED;\n        if (selectedType.equals(\"csvCommaOption\")) return EntitysetExportMode.COMMA_SEPARATED;\n        return null;\n    }\n\n    private String exportFileExtension() {\n        if (entity instanceof TGTaskSet) return \".pdf\";\n        return \".zip\";\n    }\n\n    private String exportSetExtension() {\n        return \".csv\";\n    }\n}")), this.rule().condition(this.allTypes("ui", "validationResult"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.driver.driversystem.server.model.TGFieldError;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class ValidationResultTemplate extends AbstractValidationResultTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private ValidateResult result;\n    private Consumer<TGFieldError> selectListener;\n\n    public ValidationResultTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void result(ValidateResult result) {\n        this.result = result;\n    }\n\n    public void onSelect(Consumer<TGFieldError> listener) {\n        this.selectListener = listener;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        errors.clear();\n        if (result.getValidateError() == null) return;\n        result.getValidateError().getFieldErrors().forEach(e -> fill(e, errors.add()));\n    }\n\n    private void fill(TGFieldError error, FieldResultErrorTemplate display) {\n        display.error(error);\n        display.onSelect(e -> selectListener.accept(error));\n        display.refresh();\n    }\n}")), this.rule().condition(this.allTypes("ui", "validationResultError"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.utils.Formatters;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.TGFieldError;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class FieldResultErrorTemplate extends AbstractFieldResultErrorTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private TGFieldError error;\n    private Consumer<TGFieldError> selectListener;\n\n    public FieldResultErrorTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void error(TGFieldError error) {\n        this.error = error;\n    }\n\n    public void onSelect(Consumer<TGFieldError> listener) {\n        this.selectListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        target.onExecute(e -> selectListener.accept(error));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        warningIcon.visible(error.getType() == TGFieldError.ValidateErrorType.Warning);\n        errorIcon.visible(error.getType() == TGFieldError.ValidateErrorType.Error);\n        target.title(error.getErrorname() + \". \" + Formatters.firstUpperCase(error.getMessage()));\n    }\n}")), this.rule().condition(this.allTypes("entity", "task"), this.trigger("refresh")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && view != null && view.equals(\"form\")) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".show(); return; }")), this.rule().condition(this.type("entity"), this.trigger("refresh")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(") { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".show(); return; }")), this.rule().condition(this.type("entity"), this.trigger("hide")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".hide(); }")), this.rule().condition(this.type("entity"), this.trigger("dirty")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.dirty(); }")), this.rule().condition(this.type("entity"), this.trigger("selectview")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.selectView(view);")), this.rule().condition(this.type("entity"), this.trigger("drcdeclaration")).output(this.mark("drc", new String[0])), this.rule().condition(this.type("entity"), this.trigger("opensavedialog")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.openSaveDialog(listener); return; }")), this.rule().condition(this.type("entity"), this.trigger("save")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible() && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.dirty()) { return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.save(); }")), this.rule().condition(this.type("entity"), this.trigger("silentsave")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible() && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.dirty()) { return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.silentSave(); }")), this.rule().condition(this.type("entity"), this.trigger("forcesave")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.forceSave(); }")), this.rule().condition(this.type("entity"), this.trigger("validateerrors")).output(this.literal("if (drc == ")).output(this.mark("drc", new String[0])).output(this.literal(" && ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".isVisible()) { ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.showValidationErrors(errors); return; }")), this.rule().condition(this.type("room"), this.trigger("processes")).output(this.literal("put(\"")).output(this.mark("name", "lowerCase")).output(this.literal("\", new HashMap<>() {{ ")).output(this.mark("process", new String[0]).multiple(" ")).output(this.literal(" }});")), this.rule().condition(this.type("process"), new Rule.Condition[0]).output(this.literal("put(")).output(this.mark("drc", new String[0])).output(this.literal(", \"")).output(this.mark("label", new String[0])).output(this.literal("\");")));
    }
}

