/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class BoxTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.type("box"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.services.AuthService;\nimport io.intino.alexandria.ui.services.auth.Space;\nimport io.intino.alexandria.ui.services.push.UISession;\nimport io.intino.amidas.accessor.alexandria.core.AmidasCasAccessor;\nimport io.intino.goros.egeasy.box.EgeConfiguration;\nimport io.intino.goros.egeasy.m3.definition.base.DefinitionException;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.provider.Provider;\nimport io.intino.goros.egeasy.box.ui.commands.Commands;\nimport io.intino.goros.egeasy.box.ui.commands.CommandsFactory;\nimport org.apache.commons.collections4.map.LRUMap;\n\nimport java.io.IOException;\nimport java.net.URL;\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Consumer;\n\npublic class ")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box extends AbstractBox {\n\tprivate CommandsFactory commandsFactory;\n\tprivate AmidasCasAccessor authService;\n    private EgeConfiguration egeConfiguration;\n    private final Map<String, Provider> providerMap = new HashMap<>();\n    private final Map<String, Consumer<String>> sessionLostListenersMap = new HashMap<>();\n    private final LRUMap<Integer, TGResource> editionsMap = new LRUMap<>();\n\n    public ")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box(String[] args) {\n        super(args);\n    }\n\n    public ")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Configuration configuration) {\n        super(configuration);\n    }\n\n    public void beforeStart() {\n        try {\n            commandsFactory = new CommandsFactory(this);\n            egeConfiguration = EgeConfiguration.fromFile(configuration.egeConfigurationFile());\n            ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.model.Model.init(egeConfiguration.iconsDir());\n            Provider.initialize(configuration.egeConfigurationFile().getAbsolutePath());\n        } catch (IOException | DefinitionException e) {\n            Logger.error(e);\n        }\n    }\n\n    public void afterStart() {\n    }\n\n    public void beforeStop() {\n    }\n\n    public void afterStop() {\n    }\n\n    public Provider provider(String session) {\n        return providerMap.getOrDefault(session, null);\n    }\n\n    public Provider provider(UISession session) {\n        registerProvider(session);\n        return providerMap.get(session.id());\n    }\n\n    public ")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box onProviderSessionLost(UISession session, Consumer<String> listener) {\n        sessionLostListenersMap.put(session.id(), listener);\n        return this;\n    }\n\n    public <F extends Commands> F commands(Class<F> clazz) {\n    \treturn commandsFactory.command(clazz);\n\t}\n\n\tpublic EgeConfiguration egeConfiguration() {\n\t    return egeConfiguration;\n\t}\n\n    public AmidasCasAccessor authService() {\n        return authService;\n    }\n\n    protected AuthService authService(java.net.URL authServiceUrl) {\n        try {\n            authService = authServiceUrl != null ? new AmidasCasAccessor(new Space(new URL(configuration.url())).name(\"cas-app\"), authServiceUrl) : null;\n            return authService;\n        } catch (java.net.MalformedURLException e) {\n            Logger.error(e);\n            return null;\n        }\n    }\n\n    private void registerProvider(UISession session) {\n        if (providerMap.containsKey(session.id())) return;\n        Provider provider = new Provider();\n        session.whenLogout(e -> unRegister(session));\n        provider.onInvalidSession(s -> notifySessionLost(session, s));\n        providerMap.put(session.id(), provider);\n    }\n\n    private void notifySessionLost(UISession session, String providerSessionId) {\n        if (!sessionLostListenersMap.containsKey(session.id())) return;\n        sessionLostListenersMap.get(session.id()).accept(providerSessionId);\n    }\n\n    private void unRegister(UISession session) {\n        if (!providerMap.containsKey(session.id())) return;\n        providerMap.remove(session.id());\n    }\n\n    public void registerEdition(TGResource container) {\n        editionsMap.put(container.getERC(), container);\n    }\n\n    public void unRegisterEdition(int erc) {\n        editionsMap.remove(erc);\n    }\n\n    public TGResource edition(int erc) {\n        return editionsMap.getOrDefault(erc, null);\n    }\n\n}")));
    }
}

