/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.library;

import io.intino.goros.egeasy.m3.entity.field.TGField;
import io.intino.goros.egeasy.m3.entity.field.TGFieldSignature;
import io.intino.goros.egeasy.m3.entity.field.TGFieldStamp;
import io.intino.goros.egeasy.m3.entity.resource.TGContainer;
import io.intino.goros.egeasy.m3.entity.resource.TGResource;
import io.intino.goros.egeasy.m3.library.LibraryEntity;

public class LibraryResource {
    public static boolean canDeleteResource(TGResource resource) {
        return resource instanceof TGContainer ? LibraryResource.canDeleteContainer((TGContainer)resource) : false;
    }

    private static boolean isLockedByfield(TGField field) {
        if (field instanceof TGFieldSignature) {
            TGFieldSignature fieldSignature = (TGFieldSignature)field;
            return fieldSignature.getSignatory() != null && !fieldSignature.getSignatory().isEmpty();
        }
        if (field instanceof TGFieldStamp) {
            TGFieldStamp fieldStamp = (TGFieldStamp)field;
            return fieldStamp.getValue() != null && !fieldStamp.getValue().isEmpty();
        }
        return false;
    }

    public static boolean canDeleteContainer(TGContainer container) {
        if (container == null) {
            return false;
        }
        if (container.getStatus().isProtect() || container.getStatus().isLocked()) {
            return false;
        }
        return LibraryEntity.getFields(container).stream().filter(f -> LibraryResource.isLockedByfield(f)).findFirst().orElse(null) == null;
    }
}

