/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.xml;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class Node {
    private org.w3c.dom.Node node;

    public Node(org.w3c.dom.Node node) {
        this.node = node;
    }

    public org.w3c.dom.Node get() {
        return this.node;
    }

    public String getNodeName() {
        return this.node.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.node.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.node.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.node.getNodeType();
    }

    public Node getParentNode() {
        return this.nodeOf(this.node.getParentNode());
    }

    public List<Node> getChildNodes() {
        return this.toList(this.node.getChildNodes());
    }

    public List<Node> getChildren() {
        return this.getChildNodes().stream().filter(n -> !(n.get() instanceof Text)).collect(Collectors.toList());
    }

    public Node getFirstChild() {
        return this.getChildNodes().get(0);
    }

    public Node getLastChild() {
        List<Node> childNodes = this.getChildNodes();
        return childNodes.get(childNodes.size() - 1);
    }

    public Node getPreviousSibling() {
        return this.nodeOf(this.node.getPreviousSibling());
    }

    public Node getNextSibling() {
        return this.nodeOf(this.node.getNextSibling());
    }

    public NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.nodeOf(this.node.insertBefore(newChild.get(), refChild.get()));
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.nodeOf(this.node.replaceChild(newChild.get(), oldChild.get()));
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.nodeOf(this.node.removeChild(oldChild.get()));
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.nodeOf(this.node.appendChild(newChild.get()));
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.nodeOf(this.node.cloneNode(deep));
    }

    public void normalize() {
        this.node.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.node.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.node.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    public boolean hasAttributes() {
        return this.node.hasAttributes();
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return this.node.compareDocumentPosition(other.get());
    }

    public String getTextContent() throws DOMException {
        return this.node.getTextContent();
    }

    public void setTextContent(String textContent) throws DOMException {
        this.node.setTextContent(textContent);
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        return this.node.isSameNode(other);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.node.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.node.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.node.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        return this.node.isEqualNode(arg);
    }

    public Object getFeature(String feature, String version) {
        return this.node.getFeature(feature, version);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.node.setUserData(key, data, handler);
    }

    public Object getUserData(String key) {
        return this.node.getUserData(key);
    }

    public Node child(String type) {
        return this.getChildNodes().stream().filter(child -> child.getNodeName().equalsIgnoreCase(type)).findFirst().orElse(null);
    }

    public List<Node> children(String type) {
        return this.getChildNodes().stream().filter(child -> child.getNodeName().equalsIgnoreCase(type)).collect(Collectors.toList());
    }

    private List<Node> toList(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).map(Node::new).collect(Collectors.toList());
    }

    private Node nodeOf(org.w3c.dom.Node importNode) {
        return new Node(importNode);
    }
}

