/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.xml;

import io.intino.alexandria.xml.Node;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class Document {
    private org.w3c.dom.Document document;

    public Document(org.w3c.dom.Document document) {
        this.document = document;
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public List<Node> getElementsByTagName(String tagname) {
        return this.toList(this.document.getElementsByTagName(tagname));
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.nodeOf(this.document.importNode(importedNode.get(), deep));
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public List<Node> getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.toList(this.document.getElementsByTagNameNS(namespaceURI, localName));
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.document.setXmlStandalone(xmlStandalone);
    }

    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.document.setXmlVersion(xmlVersion);
    }

    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.document.setStrictErrorChecking(strictErrorChecking);
    }

    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    public void setDocumentURI(String documentURI) {
        this.document.setDocumentURI(documentURI);
    }

    public Node adoptNode(Node source) throws DOMException {
        return this.nodeOf(this.document.adoptNode(source.get()));
    }

    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    public void normalizeDocument() {
        this.document.normalizeDocument();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.nodeOf(this.document.renameNode(n.get(), namespaceURI, qualifiedName));
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.document.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.nodeOf(this.document.getParentNode());
    }

    public List<Node> getChildNodes() {
        return this.toList(this.document.getChildNodes());
    }

    public Node getFirstChild() {
        return this.nodeOf(this.document.getFirstChild());
    }

    public Node getLastChild() {
        return this.nodeOf(this.document.getLastChild());
    }

    public Node getPreviousSibling() {
        return this.nodeOf(this.document.getPreviousSibling());
    }

    public Node getNextSibling() {
        return this.nodeOf(this.document.getNextSibling());
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public org.w3c.dom.Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.nodeOf(this.document.insertBefore(newChild.get(), refChild.get()));
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.nodeOf(this.document.replaceChild(newChild.get(), oldChild.get()));
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.nodeOf(this.document.removeChild(oldChild.get()));
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.nodeOf(this.document.appendChild(newChild.get()));
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.nodeOf(this.document.cloneNode(deep));
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.document.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    public String getBaseURI() {
        return this.document.getBaseURI();
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return this.document.compareDocumentPosition(other.get());
    }

    public String getTextContent() throws DOMException {
        return this.document.getTextContent();
    }

    public void setTextContent(String textContent) throws DOMException {
        this.document.setTextContent(textContent);
    }

    public boolean isSameNode(Node other) {
        return this.document.isSameNode(other.get());
    }

    public String lookupPrefix(String namespaceURI) {
        return this.document.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.document.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.document.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(Node arg) {
        return this.document.isEqualNode(arg.get());
    }

    public Object getFeature(String feature, String version) {
        return this.document.getFeature(feature, version);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.document.setUserData(key, data, handler);
    }

    public Object getUserData(String key) {
        return this.document.getUserData(key);
    }

    public Node child(String type) {
        return this.getChildNodes().stream().filter(child -> child.getNodeName().equalsIgnoreCase(type)).findFirst().orElse(null);
    }

    public List<Node> children(String type) {
        return this.getChildNodes().stream().filter(child -> child.getNodeName().equalsIgnoreCase(type)).collect(Collectors.toList());
    }

    public String toString() {
        return this.getTextContent();
    }

    private List<Node> toList(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).map(Node::new).collect(Collectors.toList());
    }

    private Node nodeOf(org.w3c.dom.Node importNode) {
        return new Node(importNode);
    }
}

