/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;

public class Attributes {
    private final HashMap<String, ArrayList<String>> store = new LinkedHashMap<String, ArrayList<String>>();

    public void clear() {
        this.store.clear();
    }

    public void clearAttribute(String name) {
        this.store.remove(name);
    }

    public HashMap<String, ArrayList<String>> getAll() {
        return this.store;
    }

    public int getCount() {
        return this.store.size();
    }

    public List<String> findAttribute(String name) {
        if (!this.store.containsKey(name)) {
            return Collections.emptyList();
        }
        return this.store.get(name.trim());
    }

    public void addAttribute(String name, String value) {
        if (!this.store.containsKey(name)) {
            this.store.put(name, new ArrayList());
        }
        this.store.get(name).add(value);
    }

    public int size() {
        return this.store.keySet().size();
    }

    public String getContent() {
        int idx;
        StringBuilder content = new StringBuilder("");
        for (String name : this.store.keySet()) {
            content.append(name).append("=");
            for (String value : this.store.get(name)) {
                content.append(value).append("@\\");
            }
            idx = content.lastIndexOf("@\\");
            content = new StringBuilder(content.substring(0, idx));
            content.append("\r\n");
        }
        idx = content.lastIndexOf("\r\n");
        if (idx >= 0) {
            content = new StringBuilder(content.substring(0, idx));
        }
        return content.toString();
    }

    public void setContent(String content) {
        String[] attributes;
        this.clear();
        if (content.equals("")) {
            return;
        }
        for (String attribute : attributes = content.split(Pattern.quote("\r\n"))) {
            String[] valueParts;
            int idxEqual = attribute.indexOf("=");
            String name = attribute.substring(0, idxEqual);
            String values = attribute.substring(idxEqual + 1);
            for (String value : valueParts = values.split(Pattern.quote("@\\"))) {
                this.addAttribute(name, value);
            }
        }
    }
}

